/*
 * Decompiled with CFR 0.152.
 */
package alma.entity.xmlbinding.obsproject;

import alma.entity.xmlbinding.obsproject.ObsProgramT;
import alma.entity.xmlbinding.obsproject.ObsProjectEntityT;
import alma.entity.xmlbinding.obsproject.SubmissionRecordT;
import alma.entity.xmlbinding.obsproject.types.ObsProjectStatusType;
import alma.entity.xmlbinding.obsproposal.ObsProposalRefT;
import alma.entity.xmlbinding.obsreview.ObsReviewRefT;
import alma.entity.xmlbinding.projectstatus.ProjectStatusRefT;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class ObsProject
implements Serializable {
    private String _schemaVersion = "13";
    private String _revision = "29";
    private String _almatype = "APDM::ObsProject";
    private ObsProjectStatusType _status = ObsProjectStatusType.valueOf("NewPhase1");
    private ObsProjectEntityT _obsProjectEntity;
    private ObsProposalRefT _obsProposalRef;
    private ObsReviewRefT _obsReviewRef;
    private ProjectStatusRefT _projectStatusRef;
    private String _projectName;
    private String _pI;
    private String _version = "0";
    private String _code = "None Assigned";
    private int _assignedPriority = 0;
    private boolean _has_assignedPriority;
    private String _timeOfCreation = "0000-00-00";
    private boolean _manualMode = false;
    private boolean _has_manualMode;
    private boolean _simulationMode = false;
    private boolean _has_simulationMode;
    private boolean _isCommissioning = false;
    private boolean _has_isCommissioning;
    private boolean _isCalibration = false;
    private boolean _has_isCalibration;
    private String _letterGrade = "D";
    private int _scientificRank = 1;
    private boolean _has_scientificRank;
    private double _scientificScore = 1.0;
    private boolean _has_scientificScore;
    private String _staffProjectNote;
    private String _taPhase2Comments;
    private String _taMainComments;
    private String _consensusReport;
    private boolean _isDDT = false;
    private boolean _has_isDDT;
    private boolean _p2gAttention = false;
    private boolean _has_p2gAttention;
    private String _p2gAttentionReasons;
    private ObsProgramT _obsProgram;
    private ArrayList _submissionRecordList;

    public ObsProject() {
        this.setSchemaVersion("13");
        this.setRevision("29");
        this.setAlmatype("APDM::ObsProject");
        this.setStatus(ObsProjectStatusType.valueOf("NewPhase1"));
        this.setVersion("0");
        this.setCode("None Assigned");
        this.setTimeOfCreation("0000-00-00");
        this.setLetterGrade("D");
        this._submissionRecordList = new ArrayList();
    }

    public void addSubmissionRecord(SubmissionRecordT vSubmissionRecord) throws IndexOutOfBoundsException {
        this._submissionRecordList.add(vSubmissionRecord);
    }

    public void addSubmissionRecord(int index, SubmissionRecordT vSubmissionRecord) throws IndexOutOfBoundsException {
        this._submissionRecordList.add(index, vSubmissionRecord);
    }

    public void clearSubmissionRecord() {
        this._submissionRecordList.clear();
    }

    public void deleteAssignedPriority() {
        this._has_assignedPriority = false;
    }

    public void deleteIsCalibration() {
        this._has_isCalibration = false;
    }

    public void deleteIsCommissioning() {
        this._has_isCommissioning = false;
    }

    public void deleteIsDDT() {
        this._has_isDDT = false;
    }

    public void deleteManualMode() {
        this._has_manualMode = false;
    }

    public void deleteP2gAttention() {
        this._has_p2gAttention = false;
    }

    public void deleteScientificRank() {
        this._has_scientificRank = false;
    }

    public void deleteScientificScore() {
        this._has_scientificScore = false;
    }

    public void deleteSimulationMode() {
        this._has_simulationMode = false;
    }

    public Enumeration enumerateSubmissionRecord() {
        return new IteratorEnumeration(this._submissionRecordList.iterator());
    }

    public String getAlmatype() {
        return this._almatype;
    }

    public int getAssignedPriority() {
        return this._assignedPriority;
    }

    public String getCode() {
        return this._code;
    }

    public String getConsensusReport() {
        return this._consensusReport;
    }

    public boolean getIsCalibration() {
        return this._isCalibration;
    }

    public boolean getIsCommissioning() {
        return this._isCommissioning;
    }

    public boolean getIsDDT() {
        return this._isDDT;
    }

    public String getLetterGrade() {
        return this._letterGrade;
    }

    public boolean getManualMode() {
        return this._manualMode;
    }

    public ObsProgramT getObsProgram() {
        return this._obsProgram;
    }

    public ObsProjectEntityT getObsProjectEntity() {
        return this._obsProjectEntity;
    }

    public ObsProposalRefT getObsProposalRef() {
        return this._obsProposalRef;
    }

    public ObsReviewRefT getObsReviewRef() {
        return this._obsReviewRef;
    }

    public boolean getP2gAttention() {
        return this._p2gAttention;
    }

    public String getP2gAttentionReasons() {
        return this._p2gAttentionReasons;
    }

    public String getPI() {
        return this._pI;
    }

    public String getProjectName() {
        return this._projectName;
    }

    public ProjectStatusRefT getProjectStatusRef() {
        return this._projectStatusRef;
    }

    public String getRevision() {
        return this._revision;
    }

    public String getSchemaVersion() {
        return this._schemaVersion;
    }

    public int getScientificRank() {
        return this._scientificRank;
    }

    public double getScientificScore() {
        return this._scientificScore;
    }

    public boolean getSimulationMode() {
        return this._simulationMode;
    }

    public String getStaffProjectNote() {
        return this._staffProjectNote;
    }

    public ObsProjectStatusType getStatus() {
        return this._status;
    }

    public SubmissionRecordT getSubmissionRecord(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._submissionRecordList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (SubmissionRecordT)this._submissionRecordList.get(index);
    }

    public SubmissionRecordT[] getSubmissionRecord() {
        int size = this._submissionRecordList.size();
        SubmissionRecordT[] mArray = new SubmissionRecordT[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (SubmissionRecordT)this._submissionRecordList.get(index);
        }
        return mArray;
    }

    public int getSubmissionRecordCount() {
        return this._submissionRecordList.size();
    }

    public String getTaMainComments() {
        return this._taMainComments;
    }

    public String getTaPhase2Comments() {
        return this._taPhase2Comments;
    }

    public String getTimeOfCreation() {
        return this._timeOfCreation;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean hasAssignedPriority() {
        return this._has_assignedPriority;
    }

    public boolean hasIsCalibration() {
        return this._has_isCalibration;
    }

    public boolean hasIsCommissioning() {
        return this._has_isCommissioning;
    }

    public boolean hasIsDDT() {
        return this._has_isDDT;
    }

    public boolean hasManualMode() {
        return this._has_manualMode;
    }

    public boolean hasP2gAttention() {
        return this._has_p2gAttention;
    }

    public boolean hasScientificRank() {
        return this._has_scientificRank;
    }

    public boolean hasScientificScore() {
        return this._has_scientificScore;
    }

    public boolean hasSimulationMode() {
        return this._has_simulationMode;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeSubmissionRecord(SubmissionRecordT vSubmissionRecord) {
        boolean removed = this._submissionRecordList.remove(vSubmissionRecord);
        return removed;
    }

    public void setAlmatype(String almatype) {
        this._almatype = almatype;
    }

    public void setAssignedPriority(int assignedPriority) {
        this._assignedPriority = assignedPriority;
        this._has_assignedPriority = true;
    }

    public void setCode(String code) {
        this._code = code;
    }

    public void setConsensusReport(String consensusReport) {
        this._consensusReport = consensusReport;
    }

    public void setIsCalibration(boolean isCalibration) {
        this._isCalibration = isCalibration;
        this._has_isCalibration = true;
    }

    public void setIsCommissioning(boolean isCommissioning) {
        this._isCommissioning = isCommissioning;
        this._has_isCommissioning = true;
    }

    public void setIsDDT(boolean isDDT) {
        this._isDDT = isDDT;
        this._has_isDDT = true;
    }

    public void setLetterGrade(String letterGrade) {
        this._letterGrade = letterGrade;
    }

    public void setManualMode(boolean manualMode) {
        this._manualMode = manualMode;
        this._has_manualMode = true;
    }

    public void setObsProgram(ObsProgramT obsProgram) {
        this._obsProgram = obsProgram;
    }

    public void setObsProjectEntity(ObsProjectEntityT obsProjectEntity) {
        this._obsProjectEntity = obsProjectEntity;
    }

    public void setObsProposalRef(ObsProposalRefT obsProposalRef) {
        this._obsProposalRef = obsProposalRef;
    }

    public void setObsReviewRef(ObsReviewRefT obsReviewRef) {
        this._obsReviewRef = obsReviewRef;
    }

    public void setP2gAttention(boolean p2gAttention) {
        this._p2gAttention = p2gAttention;
        this._has_p2gAttention = true;
    }

    public void setP2gAttentionReasons(String p2gAttentionReasons) {
        this._p2gAttentionReasons = p2gAttentionReasons;
    }

    public void setPI(String pI) {
        this._pI = pI;
    }

    public void setProjectName(String projectName) {
        this._projectName = projectName;
    }

    public void setProjectStatusRef(ProjectStatusRefT projectStatusRef) {
        this._projectStatusRef = projectStatusRef;
    }

    public void setRevision(String revision) {
        this._revision = revision;
    }

    public void setSchemaVersion(String schemaVersion) {
        this._schemaVersion = schemaVersion;
    }

    public void setScientificRank(int scientificRank) {
        this._scientificRank = scientificRank;
        this._has_scientificRank = true;
    }

    public void setScientificScore(double scientificScore) {
        this._scientificScore = scientificScore;
        this._has_scientificScore = true;
    }

    public void setSimulationMode(boolean simulationMode) {
        this._simulationMode = simulationMode;
        this._has_simulationMode = true;
    }

    public void setStaffProjectNote(String staffProjectNote) {
        this._staffProjectNote = staffProjectNote;
    }

    public void setStatus(ObsProjectStatusType status) {
        this._status = status;
    }

    public void setSubmissionRecord(int index, SubmissionRecordT vSubmissionRecord) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._submissionRecordList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._submissionRecordList.set(index, vSubmissionRecord);
    }

    public void setSubmissionRecord(SubmissionRecordT[] submissionRecordArray) {
        this._submissionRecordList.clear();
        for (int i = 0; i < submissionRecordArray.length; ++i) {
            this._submissionRecordList.add(submissionRecordArray[i]);
        }
    }

    public void setTaMainComments(String taMainComments) {
        this._taMainComments = taMainComments;
    }

    public void setTaPhase2Comments(String taPhase2Comments) {
        this._taPhase2Comments = taPhase2Comments;
    }

    public void setTimeOfCreation(String timeOfCreation) {
        this._timeOfCreation = timeOfCreation;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public static ObsProject unmarshalObsProject(Reader reader) throws MarshalException, ValidationException {
        return (ObsProject)Unmarshaller.unmarshal(ObsProject.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

