/*
 * Decompiled with CFR 0.152.
 */
package alma.entity.xmlbinding.obsproject;

import alma.entity.xmlbinding.obsattachment.ObsAttachmentRefT;
import alma.entity.xmlbinding.obsproject.ExpectedPropertiesT;
import alma.entity.xmlbinding.obsproject.types.AbstractTargetParametersTSolarSystemObjectType;
import alma.entity.xmlbinding.valuetypes.AngleT;
import alma.entity.xmlbinding.valuetypes.AngularVelocityT;
import alma.entity.xmlbinding.valuetypes.SkyCoordinatesT;
import alma.entity.xmlbinding.valuetypes.VelocityT;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class AbstractTargetParametersT
implements Serializable {
    private AbstractTargetParametersTSolarSystemObjectType _solarSystemObject;
    private String _sourceName;
    private SkyCoordinatesT _sourceCoordinates;
    private AngularVelocityT _pmRA;
    private AngularVelocityT _pmDec;
    private AngleT _parallax;
    private boolean _nonSiderealMotion = false;
    private boolean _has_nonSiderealMotion;
    private String _sourceEphemeris;
    private VelocityT _sourceVelocity;
    private String _ephemerisFileName;
    private int _index = 0;
    private boolean _has_index;
    private ArrayList _sdReferencePositionList = new ArrayList();
    private ExpectedPropertiesT _expectedProperties;
    private ObsAttachmentRefT _imageRef;

    public void addSdReferencePosition(SkyCoordinatesT vSdReferencePosition) throws IndexOutOfBoundsException {
        if (this._sdReferencePositionList.size() >= 2) {
            throw new IndexOutOfBoundsException();
        }
        this._sdReferencePositionList.add(vSdReferencePosition);
    }

    public void addSdReferencePosition(int index, SkyCoordinatesT vSdReferencePosition) throws IndexOutOfBoundsException {
        if (this._sdReferencePositionList.size() >= 2) {
            throw new IndexOutOfBoundsException();
        }
        this._sdReferencePositionList.add(index, vSdReferencePosition);
    }

    public void clearSdReferencePosition() {
        this._sdReferencePositionList.clear();
    }

    public void deleteIndex() {
        this._has_index = false;
    }

    public void deleteNonSiderealMotion() {
        this._has_nonSiderealMotion = false;
    }

    public Enumeration enumerateSdReferencePosition() {
        return new IteratorEnumeration(this._sdReferencePositionList.iterator());
    }

    public String getEphemerisFileName() {
        return this._ephemerisFileName;
    }

    public ExpectedPropertiesT getExpectedProperties() {
        return this._expectedProperties;
    }

    public ObsAttachmentRefT getImageRef() {
        return this._imageRef;
    }

    public int getIndex() {
        return this._index;
    }

    public boolean getNonSiderealMotion() {
        return this._nonSiderealMotion;
    }

    public AngleT getParallax() {
        return this._parallax;
    }

    public AngularVelocityT getPmDec() {
        return this._pmDec;
    }

    public AngularVelocityT getPmRA() {
        return this._pmRA;
    }

    public SkyCoordinatesT getSdReferencePosition(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._sdReferencePositionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (SkyCoordinatesT)this._sdReferencePositionList.get(index);
    }

    public SkyCoordinatesT[] getSdReferencePosition() {
        int size = this._sdReferencePositionList.size();
        SkyCoordinatesT[] mArray = new SkyCoordinatesT[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (SkyCoordinatesT)this._sdReferencePositionList.get(index);
        }
        return mArray;
    }

    public int getSdReferencePositionCount() {
        return this._sdReferencePositionList.size();
    }

    public AbstractTargetParametersTSolarSystemObjectType getSolarSystemObject() {
        return this._solarSystemObject;
    }

    public SkyCoordinatesT getSourceCoordinates() {
        return this._sourceCoordinates;
    }

    public String getSourceEphemeris() {
        return this._sourceEphemeris;
    }

    public String getSourceName() {
        return this._sourceName;
    }

    public VelocityT getSourceVelocity() {
        return this._sourceVelocity;
    }

    public boolean hasIndex() {
        return this._has_index;
    }

    public boolean hasNonSiderealMotion() {
        return this._has_nonSiderealMotion;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeSdReferencePosition(SkyCoordinatesT vSdReferencePosition) {
        boolean removed = this._sdReferencePositionList.remove(vSdReferencePosition);
        return removed;
    }

    public void setEphemerisFileName(String ephemerisFileName) {
        this._ephemerisFileName = ephemerisFileName;
    }

    public void setExpectedProperties(ExpectedPropertiesT expectedProperties) {
        this._expectedProperties = expectedProperties;
    }

    public void setImageRef(ObsAttachmentRefT imageRef) {
        this._imageRef = imageRef;
    }

    public void setIndex(int index) {
        this._index = index;
        this._has_index = true;
    }

    public void setNonSiderealMotion(boolean nonSiderealMotion) {
        this._nonSiderealMotion = nonSiderealMotion;
        this._has_nonSiderealMotion = true;
    }

    public void setParallax(AngleT parallax) {
        this._parallax = parallax;
    }

    public void setPmDec(AngularVelocityT pmDec) {
        this._pmDec = pmDec;
    }

    public void setPmRA(AngularVelocityT pmRA) {
        this._pmRA = pmRA;
    }

    public void setSdReferencePosition(int index, SkyCoordinatesT vSdReferencePosition) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._sdReferencePositionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= 2) {
            throw new IndexOutOfBoundsException();
        }
        this._sdReferencePositionList.set(index, vSdReferencePosition);
    }

    public void setSdReferencePosition(SkyCoordinatesT[] sdReferencePositionArray) {
        this._sdReferencePositionList.clear();
        for (int i = 0; i < sdReferencePositionArray.length; ++i) {
            this._sdReferencePositionList.add(sdReferencePositionArray[i]);
        }
    }

    public void setSolarSystemObject(AbstractTargetParametersTSolarSystemObjectType solarSystemObject) {
        this._solarSystemObject = solarSystemObject;
    }

    public void setSourceCoordinates(SkyCoordinatesT sourceCoordinates) {
        this._sourceCoordinates = sourceCoordinates;
    }

    public void setSourceEphemeris(String sourceEphemeris) {
        this._sourceEphemeris = sourceEphemeris;
    }

    public void setSourceName(String sourceName) {
        this._sourceName = sourceName;
    }

    public void setSourceVelocity(VelocityT sourceVelocity) {
        this._sourceVelocity = sourceVelocity;
    }

    public static AbstractTargetParametersT unmarshalAbstractTargetParametersT(Reader reader) throws MarshalException, ValidationException {
        return (AbstractTargetParametersT)Unmarshaller.unmarshal(AbstractTargetParametersT.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

