/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.prevayler.Command;
import org.prevayler.PrevalentSystem;
import org.prevayler.implementation.ByteCountStream;
import org.prevayler.implementation.NumberFileCreator;

class CommandOutputStream {
    public static final long LOG_FILE_SIZE = 100000L;
    private final NumberFileCreator fileCreator;
    private ObjectOutputStream logStream;
    private ByteCountStream fileStream;

    public CommandOutputStream(NumberFileCreator numberFileCreator) {
        this.fileCreator = numberFileCreator;
    }

    public void writeCommand(Command command) throws IOException {
        ObjectOutputStream objectOutputStream = this.logStream();
        try {
            objectOutputStream.writeObject(command);
            objectOutputStream.reset();
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            this.closeLogStream();
            throw iOException;
        }
    }

    public synchronized void writeSnapshot(PrevalentSystem prevalentSystem) throws IOException {
        this.closeLogStream();
        File file = this.fileCreator.newTempSnapshot();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
        objectOutputStream.writeObject(prevalentSystem);
        objectOutputStream.close();
        File file2 = this.fileCreator.newSnapshot();
        if (!file.renameTo(file2)) {
            throw new IOException("Unable to rename " + file + " to " + file2);
        }
    }

    private ObjectOutputStream logStream() throws IOException {
        if (this.logStream == null) {
            this.fileStream = new ByteCountStream(this.fileCreator.newLog());
            this.logStream = new ObjectOutputStream(this.fileStream);
        }
        if (this.fileStream.bytesWritten() >= 100000L) {
            this.closeLogStream();
            return this.logStream();
        }
        return this.logStream;
    }

    private void closeLogStream() throws IOException {
        if (this.logStream == null) {
            return;
        }
        this.logStream.close();
        this.logStream = null;
    }
}

