/*
 * Decompiled with CFR 0.152.
 */
package spiffy.core.util;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushBackIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private T pushBackCache = null;
    private T lastFetchedElement = null;

    public PushBackIterator(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext() || this.pushBackCache != null;
    }

    @Override
    public T next() {
        if (this.pushBackCache != null) {
            this.lastFetchedElement = this.pushBackCache;
            this.pushBackCache = null;
        } else {
            this.lastFetchedElement = this.iterator.next();
        }
        return this.lastFetchedElement;
    }

    public void pushBack() {
        if (this.lastFetchedElement == null) {
            throw new IllegalStateException("next() must be called before pushBack(). Cannot push back non-existing element...");
        }
        if (this.pushBackCache != null) {
            throw new IllegalStateException("Cannot push back more than one object!");
        }
        this.pushBackCache = this.lastFetchedElement;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Operation not supported yet...");
    }
}

