/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.ukatc.xsltchain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import uk.ac.roe.ukatc.xsltchain.ApplicationOptions;
import uk.ac.roe.ukatc.xsltchain.ChainTranslator;
import uk.ac.roe.ukatc.xsltchain.XsltChain;

public class Convert {
    static Properties props;
    static ApplicationOptions ap;
    static URL base;

    public static void main(String[] args) {
        ChainTranslator ct = null;
        try {
            Convert.load_defaults();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ap = new ApplicationOptions();
        ap.AddOption("I", "in_ver", true, "Input version name");
        ap.AddOption("O", "out_ver", true, "Output version name");
        ap.AddOption("i", "input", true, "Input URL");
        ap.AddOption("o", "output", true, "Output file");
        ap.AddOption("v", "versiontable", true, "Version table URL");
        ap.AddOption("x", "xsd", true, "XSD name");
        ap.ParseArgs(args);
        if (!(ap.VerifyOpt("in_ver") && ap.VerifyOpt("out_ver") && ap.VerifyOpt("versiontable") && ap.VerifyOpt("xsd") && ap.VerifyOpt("input"))) {
            System.exit(1);
        }
        if (props.containsKey("BASE_URL")) {
            try {
                base = new URL(props.getProperty("BASE_URL"));
            }
            catch (MalformedURLException e) {
                System.out.println("Error: Malformed BASE_URL :" + props.getProperty("BASE_URL"));
                e.printStackTrace();
            }
            System.out.println("BASE_URL = " + props.getProperty("BASE_URL"));
        } else {
            System.out.println("BASE_URL not set");
            base = null;
        }
        File out = ap.hasOpt("output") ? new File(ap.getOpt("output")) : null;
        String u = ap.getOpt("versiontable");
        URL vt = null;
        try {
            vt = base != null ? new URL(base, u) : new URL(u);
        }
        catch (MalformedURLException e) {
            System.out.println("Error: Malformed versiontable URL :" + u);
            e.printStackTrace();
            System.exit(1);
        }
        XsltChain xc = new XsltChain();
        try {
            xc.addTranslatorsFromStream(vt.openStream());
        }
        catch (IOException e) {
            System.out.println("Error: IOException on URL :" + u);
            e.printStackTrace();
        }
        String in_ver = ap.getOpt("in_ver");
        String out_ver = ap.getOpt("out_ver");
        String is = ap.getOpt("input");
        String xsd = ap.getOpt("xsd");
        URL iu = null;
        try {
            iu = base != null ? new URL(base, is) : new URL(is);
        }
        catch (MalformedURLException e) {
            System.out.println("Error: Malformed input URL :" + is);
            e.printStackTrace();
            System.exit(1);
        }
        try {
            ct = xc.getChainTranslator(xsd, in_ver, out_ver);
        }
        catch (MalformedURLException e) {
            System.out.println("Error: Malformed URL in versiontable");
            e.printStackTrace();
            System.exit(1);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (out == null) {
                ct.Convert(iu.openStream(), System.out);
            } else {
                ct.Convert(iu.openStream(), out);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Properties get_properties(String FileName) throws IOException {
        File pf = new File(FileName);
        if (pf.canRead()) {
            FileInputStream ps = new FileInputStream(pf);
            Properties p = new Properties();
            p.load(ps);
            p.setProperty("PropertyFile", FileName);
            return p;
        }
        return null;
    }

    public static void load_defaults() throws IOException {
        String config_filename = System.getProperty("convertrc");
        if (config_filename != null) {
            Properties p = Convert.get_properties(config_filename);
            if (p == null) {
                throw new FileNotFoundException("Not found or not readable :" + config_filename);
            }
            props = p;
            return;
        }
        String fs = System.getProperty("file.separator");
        String CWD = System.getProperty("user.dir");
        config_filename = String.valueOf(CWD) + fs + ".convertrc";
        Properties p = Convert.get_properties(config_filename);
        if (p != null) {
            props = p;
            return;
        }
        String homedir = System.getProperty("user.home");
        config_filename = String.valueOf(homedir) + fs + ".convertrc";
        p = Convert.get_properties(config_filename);
        if (p != null) {
            props = p;
            return;
        }
        props = new Properties();
        props.setProperty("PropertyFile", "");
    }
}

