/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.IOException;
import java.io.PrintStream;

public class LineReader {
    public static String readString(String prompt, PrintStream outStrm) throws IOException {
        outStrm.print(prompt);
        outStrm.flush();
        StringBuffer ibuf = new StringBuffer();
        boolean done = false;
        block3: while (!done) {
            int c = System.in.read();
            switch (c) {
                case -1: 
                case 10: 
                case 13: {
                    done = true;
                    continue block3;
                }
            }
            ibuf.append((char)c);
        }
        return ibuf.toString();
    }

    public static String readMaskedString(String prompt, PrintStream outStrm) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        char linesep0 = System.getProperty("line.separator").charAt(0);
        MaskingThread masker = new MaskingThread(prompt, outStrm);
        masker.start();
        try {
            while (true) {
                int c;
                if ((c = System.in.read()) == linesep0 || c < 0) {
                    masker.interrupt();
                    if (c < 0) {
                        outStrm.println();
                    }
                    break;
                }
                sbuf.append((char)c);
            }
        }
        catch (IOException e) {
            masker.interrupt();
            outStrm.println();
            throw e;
        }
        return sbuf.toString();
    }

    private static class MaskingThread
    extends Thread {
        final String prompt;
        final PrintStream ostrm;

        public MaskingThread(String prompt, PrintStream ostrm) {
            this.ostrm = ostrm;
            this.prompt = prompt;
        }

        public void run() {
            while (!MaskingThread.interrupted()) {
                this.ostrm.print('\r' + this.prompt + " \r" + this.prompt);
                this.ostrm.flush();
                try {
                    MaskingThread.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }
    }
}

