/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging;

import alma.ACSErrTypeCommon.wrappers.AcsJCouldntPerformActionEx;
import alma.Logging.AcsLogServiceHelper;
import alma.Logging.AcsLogServiceOperations;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.AcsLoggingHandler;
import alma.acs.logging.DispatchingLogQueue;
import alma.acs.logging.LogThrottle;
import alma.acs.logging.RemoteLogDispatcher;
import alma.acs.logging.StdOutConsoleHandler;
import alma.acs.logging.adapters.AcsJacorbLoggingInitializer;
import alma.acs.logging.config.LogConfig;
import alma.acs.logging.config.LogConfigException;
import alma.acs.logging.config.LogConfigSubscriber;
import alma.acs.logging.formatters.AcsBinLogFormatter;
import alma.acs.logging.formatters.AcsXMLLogFormatter;
import alma.acs.logging.formatters.ConsoleLogFormatter;
import alma.acs.logging.level.AcsLogLevelDefinition;
import alma.acs.util.ACSPorts;
import alma.maciErrType.CannotGetComponentEx;
import alma.maciErrType.ComponentConfigurationNotFoundEx;
import alma.maciErrType.ComponentNotAlreadyActivatedEx;
import alma.maciErrType.NoPermissionEx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import si.ijs.maci.Manager;

public class ClientLogManager
implements LogConfigSubscriber {
    private static volatile ClientLogManager s_instance;
    protected final LogConfig sharedLogConfig;
    private volatile String logServiceName;
    private volatile int flushPeriodSeconds;
    private final Map<String, AcsLoggerInfo> loggers = new HashMap<String, AcsLoggerInfo>();
    private Logger parentRemoteLogger;
    protected volatile DispatchingLogQueue logQueue;
    private final ReentrantLock logQueueLock = new ReentrantLock();
    private RemoteLogDispatcher logDispatcher;
    private final Logger m_internalLogger;
    private boolean DEBUG = Boolean.getBoolean("alma.acs.logging.verbose");
    private boolean LOG_BIN_TYPE = Boolean.getBoolean("ACS.loggingBin");
    private volatile String processName;
    private final ReentrantLock processNameLock = new ReentrantLock();
    private volatile boolean suppressCorbaRemoteLogging = false;
    private final LogThrottle logThrottle;
    private volatile LogAlarmHandler logAlarmHandler;

    public static synchronized ClientLogManager getAcsLogManager() {
        if (s_instance == null) {
            s_instance = new ClientLogManager();
        }
        return s_instance;
    }

    protected ClientLogManager() {
        this.sharedLogConfig = new LogConfig();
        try {
            this.sharedLogConfig.initialize(false);
            this.configureLogging(this.sharedLogConfig);
        }
        catch (LogConfigException ex) {
            System.out.println("Failed to configure logging: " + ex.toString());
        }
        this.parentRemoteLogger = Logger.getLogger("AcsRemoteLogger");
        this.parentRemoteLogger.setUseParentHandlers(false);
        this.prepareRemoteLogging();
        this.m_internalLogger = this.getAcsLogger("alma.acs.logging", LoggerOwnerType.OtherLogger);
        this.sharedLogConfig.setInternalLogger(this.m_internalLogger);
        ThrottleCallback throttleCallback = new ThrottleCallback();
        this.logThrottle = new LogThrottle(this.sharedLogConfig, throttleCallback);
        if (this.DEBUG) {
            this.m_internalLogger.fine("ClientLogManager instance is created.");
        }
        this.sharedLogConfig.addSubscriber(this);
    }

    @Override
    public void configureLogging(LogConfig logConfig) {
        if (!logConfig.getCentralizedLogger().equals(this.logServiceName)) {
            if (this.logServiceName == null) {
                this.logServiceName = logConfig.getCentralizedLogger();
            } else {
                this.m_internalLogger.warning("Dynamic switching of Log service not yet supported!");
            }
        }
        this.flushPeriodSeconds = logConfig.getFlushPeriodSeconds();
        this.logQueueLock.lock();
        try {
            if (this.logQueue != null) {
                if (this.logQueue.hasRemoteDispatcher()) {
                    this.logQueue.setPeriodicFlushing(this.flushPeriodSeconds * 1000);
                }
                this.logQueue.setMaxQueueSize(logConfig.getMaxLogQueueSize());
            }
        }
        finally {
            this.logQueueLock.unlock();
        }
    }

    public LogConfig getLogConfig() {
        return this.sharedLogConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareRemoteLogging() {
        this.logQueueLock.lock();
        try {
            if (this.logQueue == null) {
                this.logQueue = this.createDispatchingLogQueue();
                this.logQueue.setMaxQueueSize(this.getLogConfig().getMaxLogQueueSize());
            }
        }
        finally {
            this.logQueueLock.unlock();
        }
        Map<String, AcsLoggerInfo> map = this.loggers;
        synchronized (map) {
            for (String loggerName : this.loggers.keySet()) {
                AcsLoggerInfo loggerInfo = this.loggers.get(loggerName);
                AcsLogger logger = loggerInfo.logger;
                if (logger.getLoggerName() == null || !logger.getLoggerName().equals(loggerName)) {
                    logger.setLoggerName(loggerName);
                    logger.info("Logging name mismatch resolved for '" + loggerName + "'. Should be reported to ACS developers");
                }
                this.addRemoteHandler(logger);
            }
        }
    }

    protected DispatchingLogQueue createDispatchingLogQueue() {
        return new DispatchingLogQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disableRemoteLogging() {
        Map<String, AcsLoggerInfo> map = this.loggers;
        synchronized (map) {
            for (String loggerName : this.loggers.keySet()) {
                try {
                    AcsLoggerInfo loggerInfo = this.loggers.get(loggerName);
                    AcsLogger logger = loggerInfo.logger;
                    if (loggerInfo.remoteHandler == null) continue;
                    logger.removeHandler(loggerInfo.remoteHandler);
                    loggerInfo.remoteHandler.close();
                    loggerInfo.remoteHandler = null;
                }
                catch (Throwable thr) {
                    System.out.println("Unexpected exception while disabling remote logging for '" + loggerName + "': " + thr.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcsLoggingHandler addRemoteHandler(AcsLogger logger) {
        AcsLoggingHandler remoteHandler = null;
        Map<String, AcsLoggerInfo> map = this.loggers;
        synchronized (map) {
            String loggerName = logger.getLoggerName();
            AcsLoggerInfo loggerInfo = this.loggers.get(loggerName);
            if (this.logQueue != null) {
                for (Handler handler : logger.getHandlers()) {
                    if (!(handler instanceof AcsLoggingHandler)) continue;
                    remoteHandler = (AcsLoggingHandler)handler;
                    if (loggerInfo == null || remoteHandler.equals(loggerInfo.remoteHandler)) break;
                    logger.info("Remote logging handler mismatch resolved for '" + loggerName + "'. Should be reported to ACS developers");
                    break;
                }
                if (remoteHandler == null) {
                    remoteHandler = new AcsLoggingHandler(this.logQueue, this.sharedLogConfig, loggerName, this.logThrottle);
                    logger.addHandler(remoteHandler);
                    if (loggerInfo != null && loggerInfo.remoteHandler != null) {
                        logger.info("Logging handler mismatch resolved for '" + loggerName + "'. Should be reported to ACS developers");
                    }
                }
            }
            if (loggerInfo != null) {
                loggerInfo.remoteHandler = remoteHandler;
            }
        }
        return remoteHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StdOutConsoleHandler addLocalHandler(AcsLogger logger) {
        StdOutConsoleHandler localHandler = null;
        Map<String, AcsLoggerInfo> map = this.loggers;
        synchronized (map) {
            String loggerName = logger.getLoggerName();
            AcsLoggerInfo loggerInfo = this.loggers.get(loggerName);
            for (Handler handler : logger.getHandlers()) {
                if (!(handler instanceof StdOutConsoleHandler)) continue;
                localHandler = (StdOutConsoleHandler)handler;
                if (loggerInfo == null || localHandler.equals(loggerInfo.localHandler)) break;
                logger.info("Stdout logging handler mismatch resolved for '" + loggerName + "'. Should be reported to ACS developers");
                break;
            }
            if (localHandler == null) {
                localHandler = this.createStdOutConsoleHandlerWithFormatter(this.sharedLogConfig, loggerName, this.logThrottle);
                logger.addHandler(localHandler);
                if (loggerInfo != null && loggerInfo.localHandler != null) {
                    logger.info("Logging handler mismatch resolved for '" + loggerName + "'. Should be reported to ACS developers");
                }
            }
            if (loggerInfo != null) {
                loggerInfo.localHandler = localHandler;
            }
        }
        return localHandler;
    }

    protected StdOutConsoleHandler createStdOutConsoleHandlerWithFormatter(LogConfig logConfig, String loggerName, LogThrottle throttle) {
        StdOutConsoleHandler localHandler = new StdOutConsoleHandler(logConfig, loggerName, throttle);
        localHandler.setFormatter(new ConsoleLogFormatter());
        return localHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcsLogger getAcsLogger(String loggerName, LoggerOwnerType loggerOwnerType) {
        if (loggerName == null || ((String)loggerName).trim().isEmpty()) {
            throw new IllegalArgumentException("loggerName must not be null or empty");
        }
        AcsLoggerInfo loggerInfo = null;
        try {
            Map<String, AcsLoggerInfo> map = this.loggers;
            synchronized (map) {
                loggerInfo = this.loggers.get(loggerName);
                int counter = 2;
                while (loggerInfo != null && loggerOwnerType != loggerInfo.loggerOwnerType) {
                    int lastIndexUnderscore = ((String)loggerName).lastIndexOf(95);
                    if (lastIndexUnderscore > 0 && ((String)loggerName).length() > lastIndexUnderscore + 1) {
                        try {
                            int oldCounter = Integer.parseInt(((String)loggerName).substring(lastIndexUnderscore + 1));
                            counter = Math.max(counter, oldCounter + 1);
                            loggerName = ((String)loggerName).substring(0, lastIndexUnderscore + 1) + counter;
                            loggerInfo = this.loggers.get(loggerName);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    loggerName = (String)loggerName + "_" + counter;
                    loggerInfo = this.loggers.get(loggerName);
                }
                if (loggerInfo == null) {
                    loggerInfo = new AcsLoggerInfo();
                    loggerInfo.logger = new AcsLogger((String)loggerName, null, this.sharedLogConfig);
                    loggerInfo.logger.setParent(this.parentRemoteLogger);
                    loggerInfo.logger.setUseParentHandlers(false);
                    loggerInfo.logger.setProcessName(this.processName);
                    if (loggerOwnerType == LoggerOwnerType.ComponentLogger || loggerOwnerType == LoggerOwnerType.FrameworkLogger) {
                        loggerInfo.logger.setSourceObject((String)loggerName);
                    } else {
                        loggerInfo.logger.setSourceObject(this.processName);
                    }
                    loggerInfo.localHandler = this.addLocalHandler(loggerInfo.logger);
                    loggerInfo.remoteHandler = this.addRemoteHandler(loggerInfo.logger);
                    loggerInfo.loggerOwnerType = loggerOwnerType;
                    this.loggers.put((String)loggerName, loggerInfo);
                }
                if (this.DEBUG) {
                    System.out.println("created remote logger '" + (String)loggerName + "' (level " + loggerInfo.logger.getLevel() + ") and separate local handler.");
                }
            }
        }
        catch (Throwable thr) {
            System.out.println("failed to create logger '" + (String)loggerName + "'. Stack trace follows.");
            thr.printStackTrace(System.out);
        }
        return loggerInfo.logger;
    }

    public boolean initRemoteLoggingForService(ORB orb, boolean retry) {
        return this.initRemoteLogging(orb, null, 0, retry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean internalInitRemoteLogging(ORB orb, Manager manager, int managerHandle, boolean retry) {
        String errMsg;
        if (this.logDispatcher != null) {
            System.out.println("Ignoring call to ClientLogManager#init: already initialized!");
            return false;
        }
        if (orb == null) {
            System.out.println("Given ORB is null.");
            return false;
        }
        if (manager == null) {
            System.out.println("Will retrieve the log service reference from the naming service...");
        } else if (managerHandle <= 0) {
            System.out.println("can't connect to log service: invalid handle " + managerHandle);
            return false;
        }
        AcsLogServiceOperations logService = null;
        int count = 0;
        do {
            block19: {
                errMsg = null;
                ++count;
                try {
                    this.prepareRemoteLogging();
                    logService = manager != null ? this.getLogService(manager, managerHandle) : this.getLogServiceFromNameSarvice(orb);
                    if (logService == null) {
                        errMsg = "Failed to obtain central log service '" + this.logServiceName + "': reference is 'null'. ";
                        break block19;
                    }
                    this.logQueueLock.lock();
                    try {
                        if (this.logQueue == null) {
                            System.out.println("Will abort ClientLogManager#initRemoteLogging because remote logging seems no longer needed.");
                            boolean bl = false;
                            return bl;
                        }
                        if (count > 1) {
                            this.m_internalLogger.info("Connected to central log service after initial failure. ");
                        }
                        this.logDispatcher = this.LOG_BIN_TYPE ? new RemoteLogDispatcher(orb, logService, new AcsBinLogFormatter()) : new RemoteLogDispatcher(orb, logService, new AcsXMLLogFormatter());
                        this.logQueue.setRemoteLogDispatcher(this.logDispatcher);
                        this.logQueue.flushAllAndWait();
                        this.logQueue.setPeriodicFlushing(this.flushPeriodSeconds * 1000);
                    }
                    finally {
                        this.logQueueLock.unlock();
                    }
                }
                catch (Throwable thr) {
                    errMsg = "Failed to connect to central log service with exception " + thr.toString();
                    StackTraceElement[] trace = thr.getStackTrace();
                    if (trace != null && trace.length > 0) {
                        StackTraceElement traceOrigin = trace[0];
                        errMsg = errMsg + " in file " + traceOrigin.getFileName() + ", line " + traceOrigin.getLineNumber();
                    }
                    errMsg = errMsg + ". ";
                }
            }
            if (errMsg == null) continue;
            if (retry) {
                System.out.println(errMsg + "Will try again in 10 seconds.");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    System.out.println("Abandoning ClientLogManager#initRemoteLogging retries because of thread interruption.");
                    retry = false;
                }
                continue;
            }
            System.out.println(errMsg);
        } while (retry && count <= 5 && errMsg != null);
        if (errMsg != null) return false;
        return true;
    }

    public boolean initRemoteLogging(ORB orb, Manager manager, int managerHandle, boolean retry) {
        return this.internalInitRemoteLogging(orb, manager, managerHandle, retry);
    }

    protected AcsLogServiceOperations getLogService(Manager manager, int managerHandle) throws ComponentNotAlreadyActivatedEx, CannotGetComponentEx, NoPermissionEx, ComponentConfigurationNotFoundEx {
        return AcsLogServiceHelper.narrow((Object)manager.get_service(managerHandle, this.logServiceName, true));
    }

    protected AcsLogServiceOperations getLogServiceFromNameSarvice(ORB orb) throws InvalidName {
        if (orb == null) {
            throw new IllegalArgumentException("The ORB can't be null!");
        }
        Object obj = orb.resolve_initial_references("NameService");
        NamingContextExt context = NamingContextExtHelper.narrow((Object)obj);
        if (context == null) {
            throw new NullPointerException("Got a null NamingContext");
        }
        try {
            NameComponent[] nameComponent = new NameComponent[]{new NameComponent("Log", "")};
            Object logObj = context.resolve(nameComponent);
            return AcsLogServiceHelper.narrow((Object)logObj);
        }
        catch (Throwable th) {
            System.out.println("Failed to obtain alarm service reference from naming service, trying corbaloc...");
            String corbaloc = "corbaloc::" + ACSPorts.getIP() + ":" + ACSPorts.getLogPort() + "/Log";
            Object logObj = orb.string_to_object(corbaloc);
            return AcsLogServiceHelper.narrow((Object)logObj);
        }
    }

    public void suppressRemoteLogging() {
        this.logQueueLock.lock();
        try {
            System.out.println("suppressRemoteLogging called");
            this.disableRemoteLogging();
            this.logQueue = null;
        }
        finally {
            this.logQueueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suppressCorbaRemoteLogging() {
        this.suppressCorbaRemoteLogging = true;
        Map<String, AcsLoggerInfo> map = this.loggers;
        synchronized (map) {
            for (AcsLoggerInfo loggerInfo : this.loggers.values()) {
                if (loggerInfo.loggerOwnerType != LoggerOwnerType.FrameworkLogger) continue;
                this.sharedLogConfig.setAndLockMinLogLevel(AcsLogLevelDefinition.OFF, loggerInfo.logger.getLoggerName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AcsLogger getLoggerForCorba(String frameworkName, boolean autoConfigureContextName) {
        java.lang.Object loggerName = frameworkName;
        AcsLogger frameworkLogger = null;
        this.processNameLock.lock();
        try {
            if (autoConfigureContextName && this.processName != null) {
                loggerName = (String)loggerName + "@" + this.processName;
            }
            frameworkLogger = this.getAcsLogger((String)loggerName, LoggerOwnerType.FrameworkLogger);
            if (frameworkName.equals("jacorb")) {
                frameworkLogger.addIgnoreLogs("org.omg.DsLogAdmin._LogStub", "write_records");
                frameworkLogger.addIgnoreLogs("alma.Logging._AcsLogServiceStub", "write_records");
                frameworkLogger.addIgnoreLogs("alma.Logging._AcsLogServiceStub", "writeRecords");
            }
            if (autoConfigureContextName && this.processName == null) {
                AcsLoggerInfo loggerInfo = this.loggers.get(loggerName);
                loggerInfo.needsProcessNameUpdate = true;
            }
        }
        finally {
            this.processNameLock.unlock();
        }
        if (this.suppressCorbaRemoteLogging) {
            this.sharedLogConfig.setAndLockMinLogLevel(AcsLogLevelDefinition.OFF, (String)loggerName);
        } else if (!this.sharedLogConfig.hasCustomConfig((String)loggerName)) {
            AcsLogLevelDefinition minCustomLevel = null;
            if (frameworkName.startsWith("hibernate") || frameworkName.startsWith("hibernateSQL") || frameworkName.startsWith("scxml")) {
                minCustomLevel = AcsLogLevelDefinition.WARNING;
            } else if (frameworkName.equals("jacorb")) {
                AcsLogLevelDefinition level = AcsJacorbLoggingInitializer.getLogLevelFromJacorbVerbosity();
                if (level != null) {
                    minCustomLevel = level;
                } else {
                    minCustomLevel = AcsLogLevelDefinition.WARNING;
                    this.m_internalLogger.info("Failed to consider jacorb log level property, will use only ACS log level mechanisms.");
                }
            }
            if (minCustomLevel != null) {
                AcsLogLevelDefinition customLevel = minCustomLevel.compareTo(this.sharedLogConfig.getDefaultMinLogLevel()) > 0 ? minCustomLevel : this.sharedLogConfig.getDefaultMinLogLevel();
                this.sharedLogConfig.setMinLogLevel(customLevel, (String)loggerName);
                AcsLogLevelDefinition customLevelLocal = minCustomLevel.compareTo(this.sharedLogConfig.getDefaultMinLogLevelLocal()) > 0 ? minCustomLevel : this.sharedLogConfig.getDefaultMinLogLevelLocal();
                this.sharedLogConfig.setMinLogLevelLocal(customLevelLocal, (String)loggerName);
                this.m_internalLogger.info("Logger " + (String)loggerName + " created with custom log levels local=" + customLevelLocal.name + ", remote=" + customLevel.name + " to avoid log jams due to careless default log level settings.");
            }
        }
        return frameworkLogger;
    }

    public AcsLogger getLoggerForContainer(String containerName) {
        this.setProcessName(containerName);
        return this.getAcsLogger(containerName, LoggerOwnerType.ContainerLogger);
    }

    public AcsLogger getLoggerForComponent(String componentName) {
        return this.getAcsLogger(componentName, LoggerOwnerType.ComponentLogger);
    }

    public AcsLogger getLoggerByName(String loggerName) {
        AcsLoggerInfo loggerInfo = null;
        try {
            loggerInfo = this.loggers.get(loggerName);
            return loggerInfo.logger;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public AcsLogger getLoggerForApplication(String loggerName, boolean enableRemoteLogging) {
        if (loggerName == null || loggerName.trim().length() == 0) {
            loggerName = "unknownClientApplication";
        } else {
            this.setProcessName(loggerName);
        }
        AcsLogger logger = null;
        if (enableRemoteLogging) {
            logger = this.getAcsLogger(loggerName, LoggerOwnerType.OtherLogger);
        } else {
            logger = AcsLogger.createUnconfiguredLogger(loggerName, null);
            logger.setUseParentHandlers(false);
            this.addLocalHandler(logger);
            logger.configureLevels(this.sharedLogConfig.getNamedLoggerConfig(loggerName));
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProcessName(String newProcessName) {
        if (newProcessName == null) {
            return;
        }
        if (!newProcessName.equals(this.processName)) {
            this.processNameLock.lock();
            try {
                String oldProcessName = this.processName;
                this.processName = newProcessName;
                Map<String, AcsLoggerInfo> map = this.loggers;
                synchronized (map) {
                    for (String oldLoggerName : new ArrayList<String>(this.loggers.keySet())) {
                        AcsLoggerInfo loggerInfo = this.loggers.get(oldLoggerName);
                        if (!loggerInfo.needsProcessNameUpdate) continue;
                        String newLoggerName = oldLoggerName + "@" + newProcessName;
                        loggerInfo.logger.setLoggerName(newLoggerName);
                        loggerInfo.logger.setProcessName(newProcessName);
                        loggerInfo.needsProcessNameUpdate = false;
                        AcsLoggerInfo gonner = this.loggers.put(newLoggerName, loggerInfo);
                        if (gonner != null) {
                            this.m_internalLogger.info("Process name update on logger '" + newLoggerName + "' overwrote an existing logger. This should be reported to the ACS developers.");
                        }
                        this.loggers.remove(oldLoggerName);
                    }
                }
                this.m_internalLogger.finer("Changed processName='" + oldProcessName + "' to '" + newProcessName + "' and updated logger names.");
            }
            finally {
                this.processNameLock.unlock();
            }
        }
    }

    public void enableLoggingAlarms(LogAlarmHandler logAlarmHandler) {
        this.logAlarmHandler = logAlarmHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait) {
        if (this.DEBUG) {
            System.out.println("ClientLogManager#shutdown(" + wait + ") called.");
        }
        this.logQueueLock.lock();
        try {
            if (this.logQueue != null) {
                this.disableRemoteLogging();
                if (wait) {
                    this.flushAll();
                } else {
                    Future<Boolean> flushFuture = this.logQueue.flush();
                    try {
                        flushFuture.get(200L, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.logQueue.shutDown();
                this.logQueue = null;
            }
            s_instance = null;
        }
        finally {
            this.logQueueLock.unlock();
        }
    }

    public void flushAll() {
        if (this.logQueue != null) {
            this.logQueue.flushAllAndWait();
        }
    }

    private class ThrottleCallback
    implements LogThrottle.ThrottleCallback {
        public static final String throttleAlarmFF = "Logging";
        private String throttleAlarmFM;
        public static final int throttleAlarmFC = 10;
        private final AtomicLong suppressedLocalLogCount = new AtomicLong();
        private final AtomicLong suppressedRemoteLogCount = new AtomicLong();

        private ThrottleCallback() {
        }

        @Override
        public void suppressedLog(boolean remoteLog) {
            boolean firstSuppressed;
            boolean bl = firstSuppressed = this.suppressedLocalLogCount.get() + this.suppressedRemoteLogCount.get() == 0L;
            if (remoteLog) {
                this.suppressedRemoteLogCount.incrementAndGet();
            } else {
                this.suppressedLocalLogCount.incrementAndGet();
            }
            if (firstSuppressed) {
                if (ClientLogManager.this.logAlarmHandler != null && ClientLogManager.this.processName != null) {
                    this.throttleAlarmFM = ClientLogManager.this.processName;
                    try {
                        ClientLogManager.this.logAlarmHandler.raiseAlarm(throttleAlarmFF, this.throttleAlarmFM, 10);
                        ClientLogManager.this.m_internalLogger.fine("Log throttle kicked in, suppressing logs. Alarm has been raised.");
                    }
                    catch (AcsJCouldntPerformActionEx ex) {
                        ClientLogManager.this.m_internalLogger.severe("Failed to publish alarm about dropping logs in the log throttle.");
                    }
                } else {
                    ClientLogManager.this.m_internalLogger.warning("Cannot raise alarm about log throttle action because alarm callback or process name is not yet available.");
                }
            }
        }

        @Override
        public void clearedLogSuppression() {
            this.suppressedLocalLogCount.set(0L);
            this.suppressedRemoteLogCount.set(0L);
            if (ClientLogManager.this.logAlarmHandler != null) {
                try {
                    ClientLogManager.this.logAlarmHandler.clearAlarm(throttleAlarmFF, this.throttleAlarmFM, 10);
                    ClientLogManager.this.m_internalLogger.fine("Log throttle disengaged. Alarm has been cleared.");
                }
                catch (AcsJCouldntPerformActionEx ex) {
                    ClientLogManager.this.m_internalLogger.severe("Failed to clear alarm about dropping logs in the log throttle.");
                }
            }
        }
    }

    public static interface LogAlarmHandler {
        public void raiseAlarm(String var1, String var2, int var3) throws AcsJCouldntPerformActionEx;

        public void clearAlarm(String var1, String var2, int var3) throws AcsJCouldntPerformActionEx;
    }

    private static class AcsLoggerInfo {
        AcsLogger logger;
        AcsLoggingHandler remoteHandler;
        StdOutConsoleHandler localHandler;
        LoggerOwnerType loggerOwnerType = LoggerOwnerType.UnknownLogger;
        boolean needsProcessNameUpdate = false;

        private AcsLoggerInfo() {
        }
    }

    public static enum LoggerOwnerType {
        ContainerLogger,
        ComponentLogger,
        FrameworkLogger,
        OtherLogger,
        UnknownLogger;

    }
}

