/*
 * Decompiled with CFR 0.152.
 */
package alma.maci.loggingconfig;

import alma.maci.loggingconfig.NamedLogger;
import alma.maci.loggingconfig.UnnamedLogger;
import alma.maci.loggingconfig.types.LogLevel;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class LoggingConfig
extends UnnamedLogger
implements Serializable {
    private String _centralizedLogger = "Log";
    private int _dispatchPacketSize = 100;
    private boolean _has_dispatchPacketSize;
    private LogLevel _immediateDispatchLevel = LogLevel.valueOf("10");
    private int _flushPeriodSeconds = 10;
    private boolean _has_flushPeriodSeconds;
    private int _maxLogQueueSize = 1000;
    private boolean _has_maxLogQueueSize;
    private int _maxLogsPerSecond = -1;
    private boolean _has_maxLogsPerSecond;
    private ArrayList _eList;

    public LoggingConfig() {
        this.setCentralizedLogger("Log");
        this.setImmediateDispatchLevel(LogLevel.valueOf("10"));
        this._eList = new ArrayList();
    }

    public void addE(NamedLogger vE) throws IndexOutOfBoundsException {
        this._eList.add(vE);
    }

    public void addE(int index, NamedLogger vE) throws IndexOutOfBoundsException {
        this._eList.add(index, vE);
    }

    public void clearE() {
        this._eList.clear();
    }

    public void deleteDispatchPacketSize() {
        this._has_dispatchPacketSize = false;
    }

    public void deleteFlushPeriodSeconds() {
        this._has_flushPeriodSeconds = false;
    }

    public void deleteMaxLogQueueSize() {
        this._has_maxLogQueueSize = false;
    }

    public void deleteMaxLogsPerSecond() {
        this._has_maxLogsPerSecond = false;
    }

    public Enumeration enumerateE() {
        return new IteratorEnumeration(this._eList.iterator());
    }

    public String getCentralizedLogger() {
        return this._centralizedLogger;
    }

    public int getDispatchPacketSize() {
        return this._dispatchPacketSize;
    }

    public NamedLogger getE(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._eList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (NamedLogger)this._eList.get(index);
    }

    public NamedLogger[] getE() {
        int size = this._eList.size();
        NamedLogger[] mArray = new NamedLogger[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (NamedLogger)this._eList.get(index);
        }
        return mArray;
    }

    public int getECount() {
        return this._eList.size();
    }

    public int getFlushPeriodSeconds() {
        return this._flushPeriodSeconds;
    }

    public LogLevel getImmediateDispatchLevel() {
        return this._immediateDispatchLevel;
    }

    public int getMaxLogQueueSize() {
        return this._maxLogQueueSize;
    }

    public int getMaxLogsPerSecond() {
        return this._maxLogsPerSecond;
    }

    public boolean hasDispatchPacketSize() {
        return this._has_dispatchPacketSize;
    }

    public boolean hasFlushPeriodSeconds() {
        return this._has_flushPeriodSeconds;
    }

    public boolean hasMaxLogQueueSize() {
        return this._has_maxLogQueueSize;
    }

    public boolean hasMaxLogsPerSecond() {
        return this._has_maxLogsPerSecond;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeE(NamedLogger vE) {
        boolean removed = this._eList.remove(vE);
        return removed;
    }

    public void setCentralizedLogger(String centralizedLogger) {
        this._centralizedLogger = centralizedLogger;
    }

    public void setDispatchPacketSize(int dispatchPacketSize) {
        this._dispatchPacketSize = dispatchPacketSize;
        this._has_dispatchPacketSize = true;
    }

    public void setE(int index, NamedLogger vE) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._eList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._eList.set(index, vE);
    }

    public void setE(NamedLogger[] eArray) {
        this._eList.clear();
        for (int i = 0; i < eArray.length; ++i) {
            this._eList.add(eArray[i]);
        }
    }

    public void setFlushPeriodSeconds(int flushPeriodSeconds) {
        this._flushPeriodSeconds = flushPeriodSeconds;
        this._has_flushPeriodSeconds = true;
    }

    public void setImmediateDispatchLevel(LogLevel immediateDispatchLevel) {
        this._immediateDispatchLevel = immediateDispatchLevel;
    }

    public void setMaxLogQueueSize(int maxLogQueueSize) {
        this._maxLogQueueSize = maxLogQueueSize;
        this._has_maxLogQueueSize = true;
    }

    public void setMaxLogsPerSecond(int maxLogsPerSecond) {
        this._maxLogsPerSecond = maxLogsPerSecond;
        this._has_maxLogsPerSecond = true;
    }

    public static LoggingConfig unmarshalLoggingConfig(Reader reader) throws MarshalException, ValidationException {
        return (LoggingConfig)Unmarshaller.unmarshal(LoggingConfig.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

