/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing.graphics;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicToolTipUI;
import net.jxta.swing.graphics.DefaultRangeDataSet;
import net.jxta.swing.graphics.GraphGroup;
import net.jxta.swing.graphics.RangeDataSet;

public class RangeDataGraph
extends JPanel {
    protected static Color background = new Color(0, 40, 0);
    protected static Color gridlines = new Color(0, 100, 0);
    protected static Color textColor = Color.yellow;
    private static ArrayList defaultColors = new ArrayList();
    private static final int BAR = 100;
    private static final int LINE = 200;
    protected static int GRID_ROWS = 10;
    protected static int GRID_SIZE = 9;
    protected static int GRID_COLS = 40;
    protected static int BAR_SIZE = 3;
    protected static Dimension PREF_SIZE = new Dimension(GRID_COLS * GRID_SIZE + 6, GRID_ROWS * GRID_SIZE + 8);
    static int FIXED_VERTICAL_GRID_INTERVAL = 10;
    private int numDataPerSet = 1;
    private ArrayList rangeDataSets = new ArrayList();
    private ArrayList colors = new ArrayList();
    private double minValue = 0.0;
    private double maxValue = 100.0;
    private double horizontalGridInterval = 10.0;
    private double verticalGridInterval = 0.1;
    private boolean fixedMinFromSet = false;
    private boolean fixedMaxToSet = false;
    private double fixedMinFrom;
    private double fixedMaxTo;
    private double minFrom = 0.0;
    private double maxTo = 0.0;
    private double horizontalScale = 1.0;
    private boolean autoVerticalScale = true;
    private boolean stackData = true;
    private boolean showVerticalGridLines = true;
    private boolean showHorizontalGridLines = true;
    private boolean autoScroll = false;
    private double scrollPosition;
    private boolean useScrollPosition = false;
    private int drawMode = 100;
    private Graph graph = new Graph();
    private GraphGroup graphGroup;
    private String label;
    private String[] dataLabels;
    private String verticalScaleUnits = "";
    private String horizontalScaleUnits = "";
    private boolean useHorizontalScaleLabel = false;
    private boolean useVerticalScaleLabel = true;
    JSlider maxVisibleSlider = new JSlider(1, 1, 100, 100);
    FontRenderContext parentFontRenderContext;
    FontRenderContext toolTipFontRenderContext;

    static {
        ToolTipManager.sharedInstance().setInitialDelay(1000);
        defaultColors.add(RangeDataGraph.makeTranslucent(Color.red, 128));
        defaultColors.add(RangeDataGraph.makeTranslucent(Color.green, 128));
        defaultColors.add(RangeDataGraph.makeTranslucent(Color.blue, 128));
    }

    public RangeDataGraph(int numDataPerSet) {
        this(numDataPerSet, defaultColors);
    }

    public RangeDataGraph(int numDataPerSet, ArrayList colors) {
        super.setLayout(new BorderLayout());
        this.setPreferredSize(PREF_SIZE);
        this.numDataPerSet = numDataPerSet;
        this.colors = colors;
        colors.add(RangeDataGraph.makeTranslucent(Color.red, 128));
        colors.add(RangeDataGraph.makeTranslucent(Color.green, 128));
        colors.add(RangeDataGraph.makeTranslucent(Color.blue, 128));
        this.add((Component)this.graph, "Center");
        this.add((Component)this.maxVisibleSlider, "East");
        this.maxVisibleSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RangeDataGraph.this.repaint();
            }
        });
        this.maxVisibleSlider.setToolTipText("Percentage of largest value to display");
    }

    public RangeDataGraph(int numDataPerSet, String label) {
        this(numDataPerSet);
        this.label = label;
    }

    public static Color makeTranslucent(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public void setDrawMode(int drawMode) {
        this.drawMode = drawMode;
        this.repaint();
    }

    public int getNumDataPerSet() {
        return this.numDataPerSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRangeDataSet(RangeDataSet rangeDataSet) {
        ArrayList arrayList = this.rangeDataSets;
        synchronized (arrayList) {
            this.rangeDataSets.add(rangeDataSet);
        }
        this.computeGraphSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRangeDataSet(RangeDataSet rangeDataSet) {
        ArrayList arrayList = this.rangeDataSets;
        synchronized (arrayList) {
            this.rangeDataSets.remove(rangeDataSet);
        }
        this.computeGraphSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDataBefore(int value) {
        ArrayList arrayList = this.rangeDataSets;
        synchronized (arrayList) {
            Iterator i = this.rangeDataSets.iterator();
            while (i.hasNext()) {
                RangeDataSet rangeDataSet = (RangeDataSet)i.next();
                if (!(rangeDataSet.getTo() <= (double)value)) continue;
                i.remove();
            }
        }
        this.computeGraphSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllData() {
        ArrayList arrayList = this.rangeDataSets;
        synchronized (arrayList) {
            this.rangeDataSets.clear();
        }
        this.computeGraphSize();
    }

    public void setFixedMinimumVerticalValue(double newvalue) {
        this.minValue = newvalue;
    }

    public void setFixedMaximumVerticalValue(double newvalue) {
        this.maxValue = newvalue;
    }

    public void setFixedMinimumHorizontalValue(double newvalue) {
        this.fixedMinFrom = newvalue;
        this.fixedMinFromSet = true;
    }

    public void setFixedMaximumHorizontalValue(double newvalue) {
        this.fixedMaxTo = newvalue;
        this.fixedMaxToSet = true;
    }

    public void unsetFixedMinimumHorizontalValue() {
        this.fixedMinFromSet = false;
    }

    public void unsetFixedMaximumHorizontalValue() {
        this.fixedMaxToSet = false;
    }

    public boolean isFixedMinimumHorizontalValue() {
        return this.fixedMinFromSet;
    }

    public boolean isFixedMaximumHorizontalValue() {
        return this.fixedMaxToSet;
    }

    public void setHorizontalScale(double newvalue) {
        this.horizontalScale = newvalue;
    }

    public void setHorizontalGridInterval(double newvalue) {
        this.horizontalGridInterval = newvalue;
    }

    public void setVerticalGridInterval(double newvalue) {
        this.verticalGridInterval = newvalue;
    }

    public void setAutoVerticalScale(boolean is) {
        this.autoVerticalScale = is;
    }

    public void setShowVerticalGridLines(boolean is) {
        this.showVerticalGridLines = is;
    }

    public void setShowHorizontalGridLines(boolean is) {
        this.showHorizontalGridLines = is;
    }

    public void setAutoScroll(boolean is) {
        this.autoScroll = is;
    }

    public void setScrollPosition(double pos) {
        this.scrollPosition = pos;
        this.graph.repaint();
    }

    public void setUseScrollPosition(boolean is) {
        this.useScrollPosition = is;
    }

    public double getFixedMinimumHorizontalValue() {
        return this.fixedMinFrom;
    }

    public double getFixedMaximumHorizontalValue() {
        return this.fixedMaxTo;
    }

    public boolean isUsingFixedMinimumHorizontalValue() {
        return this.fixedMinFromSet;
    }

    public boolean isUsingFixedMaximumHorizontalValue() {
        return this.fixedMaxToSet;
    }

    public double getMinimumHorizontalValue() {
        return this.minFrom;
    }

    public double getMaximumHorizontalValue() {
        return this.maxTo;
    }

    public void setGraphGroup(GraphGroup newBox) {
        this.graphGroup = newBox;
    }

    public String getLabel() {
        return this.label;
    }

    public int numDataSets() {
        return this.rangeDataSets.size();
    }

    private void computeGraphSize() {
        if (this.graphGroup != null) {
            this.graphGroup.dataChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRanges() {
        ArrayList arrayList = this.rangeDataSets;
        synchronized (arrayList) {
            boolean minSet = false;
            boolean maxSet = false;
            boolean fromSet = false;
            boolean toSet = false;
            for (RangeDataSet rangeDataSet : this.rangeDataSets) {
                if (this.autoVerticalScale) {
                    double top = 0.0;
                    int i = 0;
                    while (i < this.numDataPerSet) {
                        double value = rangeDataSet.getValue(i);
                        top += value;
                        ++i;
                    }
                    if (!maxSet || top > this.maxValue) {
                        this.maxValue = top;
                        maxSet = true;
                    }
                }
                if (!fromSet || rangeDataSet.getFrom() < this.minFrom) {
                    this.minFrom = rangeDataSet.getFrom();
                    fromSet = true;
                }
                if (toSet && !(rangeDataSet.getTo() > this.maxTo)) continue;
                this.maxTo = rangeDataSet.getTo();
                toSet = true;
            }
        }
    }

    public int getGraphWidth() {
        return this.graph.getWidth();
    }

    public void setDataLabels(String[] labels) {
        this.dataLabels = labels;
        this.setToolTipText();
    }

    public void setVerticalScaleUnits(String units) {
        this.verticalScaleUnits = units;
    }

    public void setHorizontalScaleUnits(String units) {
        this.horizontalScaleUnits = units;
    }

    public void useHorizontalScaleLabel(boolean use) {
        this.useHorizontalScaleLabel = use;
    }

    public void useVerticalScaleLabel(boolean use) {
        this.useVerticalScaleLabel = use;
    }

    protected void setToolTipText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Data (bottom to top): ");
        int i = 0;
        while (i < this.dataLabels.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.dataLabels[i]);
            ++i;
        }
        this.setToolTipText(buffer.toString());
    }

    public JToolTip createToolTip() {
        if (this.dataLabels != null) {
            return new GraphToolTip();
        }
        return super.createToolTip();
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            RangeDataGraph rangeDataGraph = new RangeDataGraph(3);
            int i = 1;
            while (i < 100) {
                int val = (int)(20.0 * Math.sin(Math.PI * (double)i / 20.0));
                rangeDataGraph.addRangeDataSet(new DefaultRangeDataSet(i * 10, (i + 1) * 10, new double[]{30 + val, 10 + val / 2, 5 + val / 3}));
                ++i;
            }
            Box buttonBox = new Box(0);
            ButtonGroup group = new ButtonGroup();
            JToggleButton barToggle = new JToggleButton("Bar Mode");
            JToggleButton lineToggle = new JToggleButton("Line Mode");
            group.add(barToggle);
            group.add(lineToggle);
            barToggle.setSelected(true);
            barToggle.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    RangeDataGraph.this.setDrawMode(100);
                }
            });
            lineToggle.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    RangeDataGraph.this.setDrawMode(200);
                }
            });
            buttonBox.add(Box.createHorizontalGlue());
            buttonBox.add(barToggle);
            buttonBox.add(Box.createHorizontalStrut(5));
            buttonBox.add(lineToggle);
            buttonBox.add(Box.createHorizontalGlue());
            JPanel buttonPanel = new JPanel(new GridLayout(1, 1));
            buttonPanel.add(buttonBox);
            buttonPanel.setBorder(new EmptyBorder(3, 3, 3, 0));
            frame.setLocation(200, 250);
            JScrollPane scrollPane = new JScrollPane(rangeDataGraph);
            frame.getContentPane().add((Component)scrollPane, "Center");
            frame.getContentPane().add((Component)buttonPanel, "South");
            frame.pack();
            frame.setResizable(true);
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Graph
    extends JPanel {
        Image image;
        Image scaledImage;

        Graph() {
            this.setBackground(background);
            this.setBorder(new EmptyBorder(2, 2, 0, 2));
            this.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ Graph this$1;
                {
                    this.this$1 = graph;
                }

                public void componentResized(ComponentEvent event) {
                    this.this$1.image = null;
                    this.this$1.repaint();
                }
            });
        }

        private void recomputeSize() {
            boolean fromSet = false;
            boolean toSet = false;
            double minFrom = 0.0;
            double maxTo = 0.0;
            for (RangeDataSet rangeDataSet : RangeDataGraph.this.rangeDataSets) {
                if (!fromSet || rangeDataSet.getFrom() < minFrom) {
                    minFrom = rangeDataSet.getFrom();
                    fromSet = true;
                }
                if (toSet && !(rangeDataSet.getTo() > maxTo)) continue;
                maxTo = rangeDataSet.getTo();
                toSet = true;
            }
            if ((double)this.getWidth() < maxTo - minFrom) {
                Dimension newSize = new Dimension((int)(maxTo - minFrom), RangeDataGraph.this.getHeight());
                try {
                    RangeDataGraph.this.setPreferredSize(newSize);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                RangeDataGraph.this.setMinimumSize(newSize);
                RangeDataGraph.this.setPreferredSize(newSize);
                RangeDataGraph.this.setSize(newSize);
                RangeDataGraph.this.setPreferredSize(newSize);
                this.setSize(newSize);
                this.setPreferredSize(newSize);
                this.setMinimumSize(newSize);
            }
        }

        public void paint(Graphics g) {
            if (RangeDataGraph.this.toolTipFontRenderContext == null) {
                RangeDataGraph.this.parentFontRenderContext = ((Graphics2D)g).getFontRenderContext();
            }
            g.setColor(background);
            super.paint(g);
            this.paintImage(g);
            if (RangeDataGraph.this.label != null) {
                g.setColor(textColor);
                g.drawString(RangeDataGraph.this.label, 10, 20);
            }
            if (RangeDataGraph.this.useVerticalScaleLabel) {
                g.drawString("(Grid Height: " + RangeDataGraph.this.verticalGridInterval + " " + RangeDataGraph.this.verticalScaleUnits + ")", 10, 35);
            }
            if (RangeDataGraph.this.useHorizontalScaleLabel) {
                g.drawString("Grid Width " + RangeDataGraph.this.horizontalGridInterval + " " + RangeDataGraph.this.horizontalScaleUnits + ")", 10, 50);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintImage(Graphics g) {
            g.translate(3, 3);
            Dimension size = this.getSize();
            g.setColor(background);
            g.fillRect(0, 0, size.width, size.height);
            g.setColor(gridlines);
            Stroke origStroke = ((Graphics2D)g).getStroke();
            int height = size.height;
            int width = size.width;
            ArrayList arrayList = RangeDataGraph.this.rangeDataSets;
            synchronized (arrayList) {
                RangeDataGraph.this.setRanges();
                double displayMaxValue = RangeDataGraph.this.maxValue * (double)RangeDataGraph.this.maxVisibleSlider.getValue() / 100.0;
                double range = displayMaxValue - RangeDataGraph.this.minValue;
                if (range != 0.0) {
                    int magnitude;
                    int numLines = height / FIXED_VERTICAL_GRID_INTERVAL;
                    if (numLines * FIXED_VERTICAL_GRID_INTERVAL < height) {
                        ++numLines;
                    }
                    RangeDataGraph.this.verticalGridInterval = range / (double)numLines;
                    if (RangeDataGraph.this.verticalGridInterval < 1.0) {
                        magnitude = 0;
                        while (RangeDataGraph.this.verticalGridInterval < 1.0) {
                            ++magnitude;
                            RangeDataGraph rangeDataGraph = RangeDataGraph.this;
                            rangeDataGraph.verticalGridInterval = rangeDataGraph.verticalGridInterval * 10.0;
                        }
                        RangeDataGraph.this.verticalGridInterval = Math.ceil(RangeDataGraph.this.verticalGridInterval) / Math.pow(10.0, magnitude);
                    } else if (RangeDataGraph.this.verticalGridInterval >= 10.0) {
                        magnitude = 0;
                        while (RangeDataGraph.this.verticalGridInterval >= 10.0) {
                            ++magnitude;
                            RangeDataGraph rangeDataGraph = RangeDataGraph.this;
                            rangeDataGraph.verticalGridInterval = rangeDataGraph.verticalGridInterval / 10.0;
                        }
                        RangeDataGraph.this.verticalGridInterval = Math.ceil(RangeDataGraph.this.verticalGridInterval) * Math.pow(10.0, magnitude);
                    }
                    range = RangeDataGraph.this.verticalGridInterval * (double)numLines;
                }
                g.setColor(gridlines);
                int rowPos = FIXED_VERTICAL_GRID_INTERVAL;
                while (rowPos < height) {
                    g.drawLine(0, rowPos, width - 6, rowPos);
                    rowPos += FIXED_VERTICAL_GRID_INTERVAL;
                }
                double colPos = RangeDataGraph.this.horizontalGridInterval * RangeDataGraph.this.horizontalScale;
                while (colPos <= (double)width) {
                    g.drawLine((int)colPos, 0, (int)colPos, height - 4);
                    colPos += RangeDataGraph.this.horizontalGridInterval * RangeDataGraph.this.horizontalScale;
                }
                g.setColor(Color.cyan);
                ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (RangeDataSet rangeDataSet : RangeDataGraph.this.rangeDataSets) {
                    double from = rangeDataSet.getFrom();
                    double to = rangeDataSet.getTo();
                    if (!(to > RangeDataGraph.this.scrollPosition) || !(from < RangeDataGraph.this.scrollPosition + (double)width / RangeDataGraph.this.horizontalScale)) continue;
                    int base = 0;
                    int i = 0;
                    while (i < RangeDataGraph.this.numDataPerSet) {
                        g.setColor((Color)RangeDataGraph.this.colors.get(i % RangeDataGraph.this.colors.size()));
                        double value = rangeDataSet.getValue(i);
                        value = value * (double)height / range;
                        int rectX = (int)Math.round((from - RangeDataGraph.this.scrollPosition) * RangeDataGraph.this.horizontalScale);
                        int rectWidth = Math.max(1, (int)Math.round((to - from) * RangeDataGraph.this.horizontalScale));
                        g.fillRect(rectX, (int)((double)(height - base) - value), rectWidth, (int)value);
                        base = (int)((double)base + value);
                        ++i;
                    }
                }
            }
            ((Graphics2D)g).setStroke(origStroke);
            g.translate(-3, -3);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    class GraphToolTipUI
    extends BasicToolTipUI {
        GraphToolTipUI() {
        }

        public Dimension getPreferredSize(JComponent c) {
            String tipText = ((JToolTip)c).getTipText();
            double maxWidth = 0.0;
            double maxHeight = 0.0;
            int i = 0;
            while (i < RangeDataGraph.this.dataLabels.length) {
                Rectangle2D rect = c.getFont().getStringBounds(RangeDataGraph.this.dataLabels[i], this.getFontRenderContext());
                maxWidth = maxWidth < rect.getWidth() ? rect.getWidth() : maxWidth;
                maxHeight = maxHeight < rect.getHeight() ? rect.getHeight() : maxHeight;
                ++i;
            }
            double height = Math.max(maxHeight, 8.0) * (double)(RangeDataGraph.this.dataLabels.length + 1);
            return new Dimension((int)(maxWidth + 8.0 + Math.max(maxHeight - 6.0, 4.0)), (int)(height + 6.0));
        }

        protected FontRenderContext getFontRenderContext() {
            return RangeDataGraph.this.toolTipFontRenderContext != null ? RangeDataGraph.this.toolTipFontRenderContext : RangeDataGraph.this.parentFontRenderContext;
        }

        public void paint(Graphics g, JComponent c) {
            if (RangeDataGraph.this.toolTipFontRenderContext == null) {
                RangeDataGraph.this.toolTipFontRenderContext = ((Graphics2D)g).getFontRenderContext();
                RangeDataGraph.this.parentFontRenderContext = null;
            }
            g.setColor(Color.black);
            String dataString = "Data: ";
            LineMetrics metrics = g.getFont().getLineMetrics(dataString, this.getFontRenderContext());
            double lineIncrement = Math.max(metrics.getHeight(), 8.0f);
            double leading = metrics.getLeading();
            int yoffset = (int)(3.0f + metrics.getHeight());
            g.drawString(dataString, 3, yoffset);
            int boxSize = (int)Math.max(metrics.getHeight() - 6.0f, 4.0f);
            int i = RangeDataGraph.this.dataLabels.length - 1;
            while (i >= 0) {
                g.setColor((Color)RangeDataGraph.this.colors.get(i % RangeDataGraph.this.colors.size()));
                yoffset = (int)((double)yoffset + lineIncrement);
                g.fillRect(3, yoffset - boxSize, boxSize, boxSize);
                g.setColor(Color.black);
                g.drawString(RangeDataGraph.this.dataLabels[i], 3 + boxSize + 3, yoffset);
                --i;
            }
        }
    }

    class GraphToolTip
    extends JToolTip {
        public GraphToolTip() {
            this.setUI(new GraphToolTipUI());
        }
    }
}

