/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing.graphics;

import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import net.jxta.swing.graphics.RangeDataGraph;

public class GraphGroup {
    JPanel graphGroupContainer;
    JScrollBar hScrollBar = new JScrollBar(0);
    private double horizontalScale = 0.01;
    private int slopAmount = 20;
    private boolean autoScroll = true;
    private double baseXvalue = 0.0;
    private boolean baseXvalueNotSet = true;
    double graphMinFrom;
    double graphMaxTo;
    boolean minSet;
    boolean maxSet;
    private ArrayList graphs = new ArrayList();

    public GraphGroup(JPanel graphGroupContainer) {
        this.graphGroupContainer = graphGroupContainer;
        this.hScrollBar.setUnitIncrement(1000);
        this.hScrollBar.setBlockIncrement(10000);
        this.setScrollExtent();
        this.hScrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent event) {
                GraphGroup.this.setScrollValue(event.getValue());
            }
        });
        if (graphGroupContainer != null) {
            graphGroupContainer.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent event) {
                    GraphGroup.this.setScrollExtent();
                }
            });
        }
    }

    private int getGroupWidth() {
        int maxWidth = 0;
        for (RangeDataGraph graph : this.graphs) {
            if (graph.getGraphWidth() <= maxWidth) continue;
            maxWidth = graph.getGraphWidth();
        }
        return maxWidth;
    }

    public synchronized void sizeChanged() {
        this.setScrollExtent();
    }

    private void setScrollExtent() {
        int newExtent = this.calulateScrollExtent();
        int scrollValue = this.hScrollBar.getValue();
        int maximum = this.hScrollBar.getMaximum();
        this.hScrollBar.setVisibleAmount((int)((double)this.getGroupWidth() / this.horizontalScale));
        this.validateScrollBar();
    }

    private int calulateScrollExtent() {
        return (int)((double)this.getGroupWidth() / this.horizontalScale);
    }

    public synchronized void add(RangeDataGraph newGraph) {
        this.graphs.add(newGraph);
        this.checkScrollValues(newGraph);
        newGraph.setGraphGroup(this);
        newGraph.setHorizontalScale(this.horizontalScale);
        newGraph.setUseScrollPosition(true);
        this.checkScrollValues(newGraph);
        this.validateScrollBar();
    }

    public synchronized void remove(RangeDataGraph graph) {
        this.graphs.remove(graph);
    }

    public boolean isEmpty() {
        return this.graphs == null || this.graphs.size() == 0;
    }

    private void validateScrollBar() {
        int min = this.hScrollBar.getMinimum();
        int max = this.hScrollBar.getMaximum();
        boolean shouldBeVisble = (double)min >= this.graphMinFrom && min != max;
        this.hScrollBar.setVisible(shouldBeVisble);
    }

    public synchronized void setScrollMax(long max) {
        if (this.graphs.size() > 0) {
            this.checkScrollValues((RangeDataGraph)this.graphs.get(0));
        }
        if (!this.maxSet || (double)max > this.graphMaxTo) {
            this.graphMaxTo = max;
            this.setScrollbarMax((int)this.graphMaxTo);
            this.maxSet = true;
            if (this.autoScroll && !this.hScrollBar.getValueIsAdjusting() && this.hScrollBar.getMaximum() - this.hScrollBar.getMinimum() > this.hScrollBar.getVisibleAmount()) {
                this.hScrollBar.setValue(this.hScrollBar.getMaximum());
                this.setScrollValue(this.hScrollBar.getValue());
            }
        }
        this.validateScrollBar();
    }

    private void setScrollbarMax(int proposedMax) {
        this.hScrollBar.setMaximum(proposedMax);
    }

    private void checkScrollValues(RangeDataGraph graph) {
        graph.setRanges();
        double min = graph.getMinimumHorizontalValue();
        double max = graph.getMaximumHorizontalValue();
        if (graph.numDataSets() > 0) {
            if (!this.minSet || min < this.graphMinFrom) {
                this.graphMinFrom = min;
                this.hScrollBar.setMinimum((int)min);
                this.minSet = true;
            }
            if (!this.maxSet || max > this.graphMaxTo) {
                this.graphMaxTo = max;
                this.setScrollbarMax((int)this.graphMaxTo);
                this.maxSet = true;
            }
            int newExtent = this.calulateScrollExtent();
            int value = this.hScrollBar.getValue();
            if ((double)value < this.graphMinFrom) {
                value = (int)this.graphMinFrom;
            }
            if ((double)(value + newExtent) > this.graphMaxTo) {
                value = (int)(this.graphMaxTo - (double)newExtent);
            }
            if (!this.hScrollBar.getValueIsAdjusting()) {
                this.hScrollBar.setValues(value, newExtent, (int)this.graphMinFrom, (int)this.graphMaxTo);
            } else {
                this.setScrollbarMax((int)this.graphMaxTo);
            }
        }
    }

    public synchronized void dataChanged(RangeDataGraph graph) {
        double oldMax = this.graphMaxTo;
        this.checkScrollValues(graph);
        if (this.autoScroll && this.graphMaxTo > oldMax && !this.hScrollBar.getValueIsAdjusting() && this.hScrollBar.getMaximum() - this.hScrollBar.getMinimum() > this.hScrollBar.getVisibleAmount()) {
            this.hScrollBar.setValue(this.hScrollBar.getMaximum());
        }
        this.validateScrollBar();
    }

    public synchronized void setScrollValue(double newValue) {
        for (RangeDataGraph graph : this.graphs) {
            graph.setScrollPosition(newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTimeBetweenLines(long milliseconds) {
        double horizontalGridInterval = milliseconds;
        int groupWidth = this.getGroupWidth();
        double oldScale = this.horizontalScale;
        this.horizontalScale = 10.0 / (double)milliseconds;
        this.hScrollBar.setUnitIncrement((int)milliseconds);
        this.hScrollBar.setBlockIncrement((int)(10L * milliseconds));
        int oldExtent = this.hScrollBar.getVisibleAmount();
        int oldValue = this.hScrollBar.getValue();
        this.setScrollExtent();
        int newValue = oldValue + (int)((double)groupWidth / oldScale - (double)groupWidth / this.horizontalScale);
        if (newValue < this.hScrollBar.getMinimum()) {
            this.hScrollBar.setMinimum(newValue);
            this.minSet = true;
        }
        this.hScrollBar.setValue(newValue);
        ArrayList arrayList = this.graphs;
        synchronized (arrayList) {
            for (RangeDataGraph graph : this.graphs) {
                graph.setHorizontalGridInterval(horizontalGridInterval);
                graph.setHorizontalScale(this.horizontalScale);
                graph.setScrollPosition(newValue);
                graph.repaint();
            }
        }
    }

    public synchronized void setHorizontalScale(double newScale) {
        this.horizontalScale = newScale;
        for (RangeDataGraph graph : this.graphs) {
            graph.setHorizontalScale(newScale);
            graph.repaint();
        }
        this.setScrollExtent();
    }

    public void setAutoScroll(boolean newValue) {
        this.autoScroll = newValue;
    }

    public void setSlopAmount(int newValue) {
        this.slopAmount = newValue;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.hScrollBar;
    }

    public double getBaseXvalue() {
        return this.baseXvalue;
    }

    public void setPossibleBaseXValue(double proposedBaseValue) {
        if (proposedBaseValue < this.baseXvalue || this.baseXvalueNotSet) {
            this.baseXvalue = proposedBaseValue;
            this.baseXvalueNotSet = false;
        }
    }
}

