/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.jxta.swing.TableRow;

public class UpdatableTableModel
extends ArrayList
implements TableModel {
    protected EventListenerList listenerList = new EventListenerList();
    protected String[] columnNames;
    protected String[] columnDescriptions;
    protected Class[] columnClasses;
    static /* synthetic */ Class class$0;

    public UpdatableTableModel(String[] columnNames, String[] columnDescriptions, Class[] columnClasses) {
        this.columnNames = columnNames;
        this.columnDescriptions = columnDescriptions;
        this.columnClasses = columnClasses;
    }

    public final int getColumnCount() {
        return this.columnClasses.length;
    }

    public final String getColumnName(int column) {
        return this.columnNames[column];
    }

    public final String getColumnDescription(int column) {
        return this.columnDescriptions[column];
    }

    public final Class getColumnClass(int column) {
        return this.columnClasses[column];
    }

    public Object getValueAt(int row, int column) {
        TableRow object = null;
        try {
            object = (TableRow)this.get(row);
        }
        catch (ClassCastException ex) {
            return null;
        }
        return object.getColumnValue(column);
    }

    public final int getRowCount() {
        return this.size();
    }

    public Object set(int index, Object element) {
        Object oldValue = super.set(index, element);
        this.update(index);
        return oldValue;
    }

    public void update(int index) {
        this.fireTableRowUpdated(index);
    }

    public boolean add(Object element) {
        boolean result = super.add(element);
        this.fireTableRowAdded();
        return result;
    }

    public void add(int index, Object element) {
        super.add(index, element);
        this.fireTableRowInserted(index);
    }

    public Object remove(int index) {
        Object oldValue = super.remove(index);
        this.fireTableRowDeleted(index);
        return oldValue;
    }

    public void clear() {
        int savedSize = this.size();
        super.clear();
        this.fireTableRowsDeleted(0, savedSize);
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("Collection adds are not supported");
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException("Collection adds are not supported");
    }

    public final void setValueAt(Object value, int row, int column) {
        throw new UnsupportedOperationException("UpdateableTableModels do not support setValueAt()");
    }

    public final boolean isCellEditable(int row, int column) {
        return false;
    }

    public void addTableModelListener(TableModelListener listener) {
        this.listenerList.add(TableModelListener.class, listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.listenerList.remove(TableModelListener.class, listener);
    }

    protected void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected void fireTableRowAdded() {
        this.fireTableChanged(new TableModelEvent(this, this.size(), this.size(), -1, 1));
    }

    protected void fireTableRowInserted(int row) {
        this.fireTableChanged(new TableModelEvent(this, row, row, -1, 1));
    }

    protected void fireTableRowUpdated(int row) {
        this.fireTableChanged(new TableModelEvent(this, row, row, -1, 0));
    }

    protected void fireTableRowDeleted(int row) {
        this.fireTableChanged(new TableModelEvent(this, row, row, -1, -1));
    }

    protected void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    protected void fireTableChanged(TableModelEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TableModelListener.class) {
                ((TableModelListener)listeners[i + 1]).tableChanged(event);
            }
            i -= 2;
        }
    }

    public void fireTableChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    protected EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }
}

