/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SwingTools {
    private static int controlBarHeight = 25;
    private static LinkedList fixedFontFamilies;

    public static void setLocation(Window parent, Window child) {
        SwingTools.setLocation(parent, child, 0, 0.0);
    }

    public static void setLocation(Component parent, Window child) {
        SwingTools.setLocation(parent, child, 0, 0.0);
    }

    public static void setLocation(Component parent, Window child, int direction, double offset) {
        Window parentWindow = SwingUtilities.getWindowAncestor(child);
        if (parent == null) {
            return;
        }
        SwingTools.setLocation(parentWindow, child, direction, offset);
    }

    public static void setLocation(Window parent, Window child, int direction, double offset) {
        if (child == null) {
            return;
        }
        Dimension childSize = child.getSize();
        Dimension screenSize = child.getToolkit().getScreenSize();
        int centerX = screenSize.width / 2;
        int centerY = screenSize.height / 2;
        if (parent != null) {
            Dimension parentSize = parent.getSize();
            centerX = parent.getX() + parentSize.width / 2;
            centerY = parent.getY() + parentSize.height / 2;
        }
        double widthOrHeightForDiagonalDirection = offset / Math.sqrt(2.0);
        switch (direction) {
            case 1: {
                centerY = (int)((double)centerY - offset);
                break;
            }
            case 5: {
                centerY = (int)((double)centerY + offset);
                break;
            }
            case 3: {
                centerX = (int)((double)centerX + offset);
                break;
            }
            case 7: {
                centerX = (int)((double)centerX - offset);
                break;
            }
            case 2: {
                centerX = (int)((double)centerX + widthOrHeightForDiagonalDirection);
                centerY = (int)((double)centerY - widthOrHeightForDiagonalDirection);
                break;
            }
            case 4: {
                centerX = (int)((double)centerX + widthOrHeightForDiagonalDirection);
                centerY = (int)((double)centerY + widthOrHeightForDiagonalDirection);
                break;
            }
            case 8: {
                centerX = (int)((double)centerX - widthOrHeightForDiagonalDirection);
                centerY = (int)((double)centerY - widthOrHeightForDiagonalDirection);
                break;
            }
            case 6: {
                centerX = (int)((double)centerX - widthOrHeightForDiagonalDirection);
                centerY = (int)((double)centerY + widthOrHeightForDiagonalDirection);
            }
        }
        int transformedChildX = centerX - childSize.width / 2;
        int transformedChildY = centerY - childSize.height / 2;
        child.setLocation(transformedChildX, transformedChildY);
        SwingTools.ensureWindowVisible(child);
    }

    public static void ensureWindowVisible(Window window) {
        if (window == null) {
            return;
        }
        Dimension windowSize = window.getSize();
        Dimension screenSize = window.getToolkit().getScreenSize();
        int newWidth = windowSize.width;
        int newHeight = windowSize.height;
        int newX = window.getX();
        int newY = window.getY();
        if (newHeight > screenSize.height) {
            newHeight = screenSize.height;
        }
        if (newWidth > screenSize.width) {
            newWidth = screenSize.width;
        }
        while (newX < 0) {
            ++newX;
        }
        while (newY < 0) {
            ++newY;
        }
        while (newX + newWidth > screenSize.width) {
            --newX;
        }
        while (newY + newHeight > screenSize.height) {
            --newY;
        }
        window.setSize(newWidth, newHeight);
        window.setLocation(newX, newY);
    }

    public static void ensureWindowUsable(Window window) {
        if (window == null) {
            return;
        }
        Dimension windowSize = window.getSize();
        Dimension screenSize = window.getToolkit().getScreenSize();
        int newWidth = windowSize.width;
        int newHeight = windowSize.height;
        int newX = window.getX();
        int newY = window.getY();
        if (newHeight > screenSize.height) {
            newHeight = screenSize.height;
        }
        if (newWidth > screenSize.width) {
            newWidth = screenSize.width;
        }
        while (newX < 0) {
            ++newX;
        }
        while (newY < 0) {
            ++newY;
        }
        while (newX + 100 > screenSize.width) {
            --newX;
        }
        while (newY + 100 > screenSize.height) {
            --newY;
        }
        window.setSize(newWidth, newHeight);
        window.setLocation(newX, newY);
    }

    public static Iterator getFixedFontFamilies() {
        JTextArea textArea = new JTextArea();
        fixedFontFamilies = new LinkedList();
        String[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Font font = null;
        FontMetrics metrics = null;
        int i = 0;
        while (i < fontFamilies.length) {
            font = new Font(fontFamilies[i], 0, 12);
            metrics = textArea.getFontMetrics(font);
            if (font.canDisplay('a') && metrics.charWidth('W') == metrics.charWidth('i')) {
                fixedFontFamilies.add(fontFamilies[i]);
            }
            ++i;
        }
        return fixedFontFamilies.iterator();
    }

    public static void showJPopupMenu(Component component, JPopupMenu popup, int x, int y) {
        int tooLow;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Dimension popupSize = popup.getPreferredSize();
        Point componentLocation = component.getLocationOnScreen();
        int tooFarRight = screenSize.width - (x + componentLocation.x + popupSize.width);
        if (tooFarRight < 0) {
            x += tooFarRight;
        }
        if ((tooLow = screenSize.height - (y + componentLocation.y + popupSize.height + controlBarHeight)) < 0) {
            y += tooLow;
        }
        popup.show(component, x, y);
    }

    public static JFrame createJFrame(String title, Component component) {
        return SwingTools.createJFrame(title, component, 0, 0, -1, -1);
    }

    public static JFrame createJFrame(String title, Component component, int x, int y) {
        return SwingTools.createJFrame(title, component, x, y, -1, -1);
    }

    public static JFrame createJFrame(String title, final Component component, final int x, final int y, final int width, final int height) {
        final JFrame frame = new JFrame(title);
        SwingTools.invokeNow(new Runnable(){

            public void run() {
                frame.getContentPane().setLayout(new GridLayout(1, 1));
                frame.getContentPane().add(component);
                frame.setLocation(x, y);
                if (width < 0 || height < 0) {
                    frame.pack();
                    Dimension size = frame.getSize();
                    if (size.width < 5 || size.height < 5) {
                        frame.setSize(100, 100);
                    }
                } else {
                    frame.setSize(width, height);
                }
                frame.setVisible(true);
            }
        });
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeNow(Runnable runnable) {
        RunnableWrapper runnableWrapper;
        RunnableWrapper runnableWrapper2 = runnableWrapper = new RunnableWrapper(runnable);
        synchronized (runnableWrapper2) {
            try {
                while (!runnableWrapper.complete) {
                    runnableWrapper.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("testing utils");
        frame.setVisible(true);
        frame.setSize(50, 50);
        SwingTools.setLocation(null, (Window)frame);
        JFrame child = new JFrame("child frame");
        child.setVisible(true);
        child.setSize(200, 200);
        SwingTools.setLocation(frame, (Window)child, 4, 1700.0);
    }

    private static class RunnableWrapper
    implements Runnable {
        Runnable runnable;
        boolean complete = false;

        RunnableWrapper(Runnable runnable) {
            this.runnable = runnable;
            SwingUtilities.invokeLater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.runnable.run();
            this.complete = true;
            RunnableWrapper runnableWrapper = this;
            synchronized (runnableWrapper) {
                this.notify();
            }
        }
    }
}

