/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.jxta.swing.UpdatableTableModel;

public class SortableTableModelFilter
implements TableModel {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    public static final int NO_SORT = -1;
    protected UpdatableTableModel delegate;
    protected int sortColumn = -1;
    protected int direction = 0;
    protected Object[] sortedList;
    protected ArrayList columnList = new ArrayList();
    protected BitSet bitSet;

    public SortableTableModelFilter(UpdatableTableModel delegate) {
        this.delegate = delegate;
        this.bitSet = new BitSet(this.delegate.getColumnCount());
        int i = 0;
        while (i < this.delegate.getColumnCount()) {
            this.bitSet.set(i);
            ++i;
        }
        this.recalcColumnList();
        this.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (e.getType() != 0 && SortableTableModelFilter.this.sortColumn != -1) {
                    SortableTableModelFilter.this.setSortColumn(SortableTableModelFilter.this.sortColumn);
                }
            }
        });
    }

    public void setColumnVisible(int column, boolean visible) {
        if (visible && !this.bitSet.get(column)) {
            this.bitSet.set(column);
            this.recalcColumnList();
        } else if (!visible && this.bitSet.get(column)) {
            this.bitSet.clear(column);
            this.recalcColumnList();
        }
    }

    public boolean isColumnVisible(int column) {
        return this.bitSet.get(column);
    }

    protected void recalcColumnList() {
        this.columnList.clear();
        int i = 0;
        while (i < this.delegate.getColumnCount()) {
            if (this.bitSet.get(i)) {
                this.columnList.add(new Integer(i));
            }
            ++i;
        }
        if (this.delegate instanceof UpdatableTableModel) {
            this.delegate.fireTableChanged();
        }
    }

    public int getMappedColumn(int column) {
        Integer mappedColumn = (Integer)this.columnList.get(column);
        return mappedColumn;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
        if (this.sortedList == null || this.delegate.getRowCount() != this.sortedList.length) {
            this.sortedList = new Object[this.delegate.getRowCount()];
        }
        int i = 0;
        while (i < this.delegate.getRowCount()) {
            Comparable value = (Comparable)this.delegate.getValueAt(i, sortColumn);
            this.sortedList[i] = new SortValue(value, i);
            ++i;
        }
        Arrays.sort(this.sortedList);
    }

    public int getDelegateColumnCount() {
        return this.delegate.getColumnCount();
    }

    public int getColumnCount() {
        return this.columnList.size();
    }

    public int getRowCount() {
        return this.delegate.getRowCount();
    }

    public Class getColumnClass(int index) {
        int mappedColumn = this.getMappedColumn(index);
        return this.delegate.getColumnClass(index);
    }

    public String getColumnName(int index) {
        int mappedColumn = this.getMappedColumn(index);
        return this.delegate.getColumnName(mappedColumn);
    }

    public String getDelegateColumnName(int index) {
        return this.delegate.getColumnName(index);
    }

    public String getDelegateColumnDescription(int index) {
        return this.delegate.getColumnDescription(index);
    }

    public Object getValueAt(int row, int column) {
        int sortedRow = this.getSortedRow(row);
        int mappedColumn = this.getMappedColumn(column);
        return this.delegate.getValueAt(sortedRow, mappedColumn);
    }

    public boolean isCellEditable(int row, int column) {
        int sortedRow = this.getSortedRow(row);
        int mappedColumn = this.getMappedColumn(column);
        return this.delegate.isCellEditable(sortedRow, mappedColumn);
    }

    public void setValueAt(Object value, int row, int column) {
        int sortedRow = this.getSortedRow(row);
        int mappedColumn = this.getMappedColumn(column);
        this.delegate.setValueAt(value, sortedRow, mappedColumn);
    }

    public void addTableModelListener(TableModelListener listener) {
        this.delegate.addTableModelListener(listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.delegate.removeTableModelListener(listener);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public void toggleDirection() {
        this.direction = this.direction == 0 ? 1 : 0;
    }

    protected int getSortedRow(int row) {
        if (this.sortColumn == -1 || this.sortedList == null || this.sortedList.length == 0) {
            return row;
        }
        if (this.direction == 0) {
            return ((SortValue)this.sortedList[row]).index;
        }
        return ((SortValue)this.sortedList[this.sortedList.length - row - 1]).index;
    }

    public void update(int index) {
        this.delegate.update(index);
    }

    public void set(int index, Object element) {
        this.delegate.set(index, element);
    }

    public boolean add(Object element) {
        return this.delegate.add(element);
    }

    public void add(int index, Object element) {
        this.delegate.add(index, element);
    }

    public int indexOf(Object whatever) {
        return this.delegate.indexOf(whatever);
    }

    public Object getRowAt(int index) {
        return this.delegate.get(index);
    }

    private class SortValue
    implements Comparable {
        Comparable comparable;
        int index;

        SortValue(Comparable c, int index) {
            this.comparable = c;
            this.index = index;
        }

        public int compareTo(Object obj) {
            if (obj instanceof SortValue) {
                SortValue other = (SortValue)obj;
                if (other.comparable == null) {
                    return -1;
                }
                if (this.comparable == null) {
                    return 1;
                }
                return this.comparable.compareTo(other.comparable);
            }
            if (obj == null) {
                return -1;
            }
            if (this.comparable == null) {
                return 1;
            }
            return this.comparable.compareTo(obj);
        }
    }
}

