/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.jxta.swing.ListPanelElementRenderer;

public class ListPanel
extends JSplitPane {
    private DefaultListModel listModel = new DefaultListModel();
    private JList list = new JList(this.listModel);
    private ListPanelElementRenderer listPanelElementRenderer;
    private JPanel EMPTY_PANEL = new JPanel();
    private JScrollPane listScroll = new JScrollPane(this.list);
    private ListSelectionListener listSelectionListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent evt) {
            int index = ListPanel.this.list.getMinSelectionIndex();
            if (index < 0) {
                ListPanel.this.setRightComponent(ListPanel.this.EMPTY_PANEL);
            } else {
                Object element = ListPanel.this.listModel.elementAt(index);
                Component renderingComponent = ListPanel.this.listPanelElementRenderer.getListPanelElementRenderingComponent(ListPanel.this, element, index);
                int location = ListPanel.this.getDividerLocation();
                ListPanel.this.setRightComponent(renderingComponent);
                ListPanel.this.setDividerLocation(location);
            }
        }
    };

    public ListPanel(ListPanelElementRenderer listPanelElementRenderer) {
        this.listPanelElementRenderer = listPanelElementRenderer;
        this.list.addListSelectionListener(this.listSelectionListener);
        this.setLeftComponent(this.listScroll);
        this.setRightComponent(this.EMPTY_PANEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Object item) {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            this.listModel.addElement(item);
            if (this.listModel.size() == 1) {
                this.list.setSelectedIndex(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(Object item) {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            this.listModel.removeElement(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            this.listModel.clear();
        }
    }

    public int getListSize() {
        return this.listModel.getSize();
    }

    public Object getElementAt(int pos) {
        return this.listModel.getElementAt(pos);
    }

    public Object getSelectedValue() {
        return this.list.getSelectedValue();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.list.setSelectedIndex(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getElementIterator() {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            int size = this.getListSize();
            LinkedList<Object> elements = new LinkedList<Object>();
            int i = 0;
            while (i < size) {
                elements.add(this.getElementAt(i));
                ++i;
            }
            return elements.iterator();
        }
    }
}

