/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class JTabFrame
extends JFrame {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private static JTabFrame defaultJTabFrame;

    public JTabFrame(String title, int x, int y, int width, int height) {
        this(title, x, y, width, height, true);
    }

    public JTabFrame(String title, int x, int y) {
        this(title, x, y, 500, 300, true);
    }

    public JTabFrame(String title, int x, int y, boolean visible) {
        this(title, x, y, 500, 300, visible);
    }

    public JTabFrame(String title, boolean visible) {
        this(title, 0, 0, 500, 300, visible);
    }

    public JTabFrame(String title) {
        this(title, 0, 0, 500, 300, true);
    }

    public JTabFrame(String title, int x, int y, int width, int height, boolean visible) {
        super(title);
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(this.tabbedPane);
        this.setSize(width, height);
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    public JTabbedPane getJTabbedPane() {
        return this.tabbedPane;
    }

    public void addTab(String label, Component component) {
        this.tabbedPane.addTab(label, component);
    }

    public void remove(Component component) {
        this.tabbedPane.remove(component);
    }

    public void removeTab(Component component) {
        this.remove(component);
    }

    public void setTabName(Component component, String name) {
        int index = this.tabbedPane.indexOfComponent(component);
        if (index >= 0) {
            this.tabbedPane.setTitleAt(index, name);
        }
    }

    public static JTabFrame getDefaultJTabFrame() {
        return defaultJTabFrame != null ? defaultJTabFrame : JTabFrame.getDefaultJTabFrame("Default Frame", 20, 20);
    }

    public static JTabFrame getDefaultJTabFrame(String title, int x, int y) {
        if (defaultJTabFrame == null) {
            defaultJTabFrame = new JTabFrame(title, x, y);
        }
        if (!defaultJTabFrame.isVisible()) {
            defaultJTabFrame.setVisible(true);
        }
        return defaultJTabFrame;
    }
}

