/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedList;
import javax.swing.JDialog;

public class EscapableDialog
extends JDialog
implements KeyListener {
    private LinkedList keyListeners = new LinkedList();
    private boolean initialized = false;

    public EscapableDialog() {
    }

    public EscapableDialog(Dialog owner) {
        super(owner);
    }

    public EscapableDialog(Dialog owner, boolean modal) {
        super(owner, modal);
    }

    public EscapableDialog(Dialog owner, String title) {
        super(owner, title);
    }

    public EscapableDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public EscapableDialog(Frame owner) {
        super(owner);
    }

    public EscapableDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    public EscapableDialog(Frame owner, String title) {
        super(owner, title);
    }

    public EscapableDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public void addEscapeKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 27) {
                    EscapableDialog.this.dispose();
                }
            }
        });
    }

    private void initGlobalKeyListener() {
        this.getRootPane().addKeyListener(this);
        this.getContentPane().addKeyListener(this);
        Container c = this.getContentPane();
        this.addKeyListeners(this.getContentPane());
        this.initialized = true;
    }

    private void addKeyListeners(Container c) {
        Component[] components = c.getComponents();
        int i = 0;
        while (i < components.length) {
            try {
                if (components[i] instanceof Container) {
                    this.addKeyListeners((Container)components[i]);
                    components[i].addKeyListener(this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public void addKeyListener(KeyListener listener) {
        if (!this.initialized) {
            this.initGlobalKeyListener();
        }
        if (!this.keyListeners.contains(listener)) {
            this.keyListeners.add(listener);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        this.keyListeners.remove(listener);
    }

    public void keyPressed(KeyEvent e) {
        for (KeyListener listener : this.keyListeners) {
            try {
                listener.keyPressed(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        for (KeyListener listener : this.keyListeners) {
            try {
                listener.keyReleased(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void keyTyped(KeyEvent e) {
        for (KeyListener listener : this.keyListeners) {
            try {
                listener.keyTyped(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

