/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.table.TableColumnModel;
import net.jxta.swing.EscapableDialog;
import net.jxta.swing.SortableTableModelFilter;

public class ColumnShowHideDialog
extends EscapableDialog
implements ActionListener {
    protected JButton okButton = new JButton("OK");
    protected JButton cancelButton = new JButton("Cancel");
    protected JPanel checkBoxPanel = new JPanel();
    protected JPanel buttonPanel = new JPanel(new FlowLayout());
    protected SortableTableModelFilter filter;
    protected TableColumnModel columnModel;
    protected JCheckBox[] checkBoxArray;

    public ColumnShowHideDialog(Frame parent, SortableTableModelFilter filter, TableColumnModel columnModel) {
        super(parent, "Select Columns", true);
        this.filter = filter;
        this.columnModel = columnModel;
        this.initCheckBoxPanel();
        this.initButtonPanel();
        this.getContentPane().add((Component)this.checkBoxPanel, "North");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setDefaultCloseOperation(2);
        this.addEscapeKeyListener();
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
    }

    protected void initCheckBoxPanel() {
        int numBoxes = this.filter.getDelegateColumnCount();
        this.checkBoxArray = new JCheckBox[numBoxes];
        int numRows = numBoxes / 3;
        if (numBoxes % 3 != 0) {
            ++numRows;
        }
        int numCols = numBoxes / numRows;
        this.checkBoxPanel.setLayout(new GridLayout(numRows, 3));
        int row = 0;
        while (row < numRows) {
            int col = 0;
            while (col < 3) {
                int boxNum = col * numRows + row;
                if (boxNum < numBoxes) {
                    this.checkBoxArray[boxNum] = new JCheckBox(this.filter.getDelegateColumnDescription(boxNum));
                    this.checkBoxPanel.add(this.checkBoxArray[boxNum]);
                    this.checkBoxArray[boxNum].setSelected(this.filter.isColumnVisible(boxNum));
                }
                ++col;
            }
            ++row;
        }
        if (this.filter.getSortColumn() != -1) {
            int sortColumn = this.filter.getMappedColumn(this.filter.getSortColumn());
            this.checkBoxArray[sortColumn].setSelected(true);
            this.checkBoxArray[sortColumn].setEnabled(false);
        }
        this.checkBoxPanel.setBorder(new EtchedBorder());
    }

    protected void initButtonPanel() {
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.cancelButton) {
            this.setVisible(false);
            return;
        }
        if (event.getSource() == this.okButton) {
            this.handleColumnChanges();
            this.setVisible(false);
            return;
        }
    }

    protected void handleColumnChanges() {
        int z = 0;
        while (z < this.filter.getDelegateColumnCount()) {
            this.filter.setColumnVisible(z, this.checkBoxArray[z].isSelected());
            ++z;
        }
    }
}

