/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.jxta.swing.MultiSplitPane;
import net.jxta.swing.TitleBar;
import net.jxta.swing.TitleBarListener;

public class MSPeval {
    JFrame frame;
    protected String[] lafs = new String[]{"com.l2fprod.gui.plaf.skin.SkinLookAndFeel", "javax.swing.plaf.metal.MetalLookAndFeel", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel"};
    boolean skinLafEnabled = false;

    public static void main(String[] args) {
        try {
            new MSPeval().go();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void go() throws Exception {
        this.frame = new JFrame("Test");
        this.frame.setDefaultCloseOperation(3);
        final MultiSplitPane multiSplitPane = new MultiSplitPane(1);
        String[] samples = new String[]{"Sleepy", "Dopey", "Doc"};
        int i = 0;
        while (i < samples.length) {
            String label = samples[i];
            TitleBar titleBar = new TitleBar("Sample - " + label, true, true);
            final JButton button = new JButton(label);
            titleBar.addTitleBarListener(new TitleBarListener(){

                public void minimize() {
                    multiSplitPane.hideComponent(button);
                }

                public void restore() {
                    multiSplitPane.showComponent(button);
                }

                public void maximize() {
                }

                public void closing() {
                    multiSplitPane.removeComponent(button);
                }

                public void closed() {
                }
            });
            multiSplitPane.add((Component)button, titleBar);
            ++i;
        }
        this.frame.getContentPane().add((Component)this.lafToolbar(), "North");
        this.frame.getContentPane().add(new JScrollPane(multiSplitPane));
        this.frame.setSize(500, 500);
        this.frame.setVisible(true);
    }

    protected JToolBar lafToolbar() {
        JToolBar ret = new JToolBar();
        int i = 0;
        while (i < this.lafs.length) {
            JButton b = new JButton(String.valueOf(i));
            final int index = i++;
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MSPeval.this.activateLookAndFeel(index);
                }
            });
            ret.add(b);
        }
        return ret;
    }

    protected void activateLookAndFeel(final int index) {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    if (index == 0 && !MSPeval.this.skinLafEnabled) {
                        String themePackName = "skinlf-themepack.zip";
                        MSPeval.this.skinLafEnabled = true;
                    }
                    LookAndFeel lafInstance = (LookAndFeel)Class.forName(MSPeval.this.lafs[index]).newInstance();
                    UIManager.setLookAndFeel(lafInstance);
                    SwingUtilities.updateComponentTreeUI(MSPeval.this.frame);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }
}

