/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.monitoring;

import alma.acs.monitoring.RemoteThreadsClient;
import alma.acs.monitoring.RemoteThreadsException;
import alma.acs.monitoring.RemoteThreadsMBean;
import alma.acs.monitoring.RemoteThreadsUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class RemoteThreadsMonitor {
    private RemoteThreadsClient rtc = null;

    public static void main(String[] args) {
        if (args.length != 1 && args.length != 2) {
            RemoteThreadsMonitor.usage();
            System.exit(1);
        }
        RemoteThreadsMonitor rtm = new RemoteThreadsMonitor(args);
        RemoteThreadsMBean mbean = rtm.getMBean();
        System.out.println("Total JacORB threads: " + mbean.getJacORBThreadsCount());
        System.out.println("Runnable JacORB's threads:");
        RemoteThreadsUtil.printThreadsInfo(RemoteThreadsUtil.toThreadsInfo(mbean.getJacORBThreadsInfo(Thread.State.RUNNABLE)), System.out, false);
        System.out.println("\nRunnable JacORB's threads (grouped):");
        RemoteThreadsUtil.printThreadsInfo(RemoteThreadsUtil.toThreadsInfo(mbean.getJacORBThreadsInfo(Thread.State.RUNNABLE)), System.out, true);
        System.out.println("\nTotal number of threads: " + mbean.getAllThreadsCount());
        RemoteThreadsUtil.printThreadsInfo(RemoteThreadsUtil.toThreadsInfo(mbean.getAllThreadsInfo()), System.out, true);
        System.out.println("\nThreads staying at org.jacorb.poa.RequestProcessor: " + mbean.getThreadsCount("org.jacorb.poa.RequestProcessor", null));
        rtm.close();
    }

    public RemoteThreadsMonitor(String[] args) {
        if (args.length == 1) {
            boolean isNumber = true;
            boolean isHost = true;
            int pid = 0;
            InetAddress remoteHost = null;
            try {
                pid = Integer.valueOf(args[0]);
            }
            catch (NumberFormatException e) {
                isNumber = false;
            }
            try {
                remoteHost = InetAddress.getByName(args[0]);
            }
            catch (UnknownHostException e) {
                isHost = false;
            }
            if (isNumber) {
                try {
                    this.rtc = new RemoteThreadsClient(pid);
                }
                catch (RemoteThreadsException e) {
                    System.err.println("Can't create a RemoteThreadsClient");
                    e.printStackTrace();
                    System.exit(1);
                }
            } else if (isHost) {
                try {
                    this.rtc = new RemoteThreadsClient(remoteHost);
                }
                catch (RemoteThreadsException e) {
                    System.err.println("Can't create a RemoteThreadsClient");
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                try {
                    this.rtc = new RemoteThreadsClient(args[0]);
                }
                catch (RemoteThreadsException e) {
                    System.err.println("Can't create a RemoteThreadsClient");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        } else if (args.length == 2) {
            try {
                InetAddress remoteHost = null;
                try {
                    remoteHost = InetAddress.getByName(args[0]);
                }
                catch (UnknownHostException e) {
                    System.err.println("Unknown host " + args[0]);
                    System.exit(1);
                }
                this.rtc = new RemoteThreadsClient(remoteHost, Integer.valueOf(args[1]));
            }
            catch (NumberFormatException e) {
                System.err.println("The given port is not a number");
                e.printStackTrace();
                System.exit(1);
            }
            catch (RemoteThreadsException e) {
                System.err.println("Can't create a RemoteThreadsClient");
                e.printStackTrace();
                System.exit(1);
            }
        }
        if (this.rtc != null && this.rtc.connect()) {
            System.out.println("Connected to the remote JVM");
        } else {
            System.err.println("Can't connect to the remote JVM");
            System.exit(1);
        }
    }

    public static void usage() {
        System.out.println("Usage:\n");
        System.out.println("For local processes:  RemoteThreadsMonitor <pid>");
        System.out.println("                      RemoteThreadsMonitor <className>\n");
        System.out.println("For remote processes: RemoteThreadsMonitor <host>");
        System.out.println("                      RemoteThreadsMonitor <host> <RMIport>\n");
    }

    public RemoteThreadsMBean getMBean() {
        RemoteThreadsMBean mbean = null;
        try {
            mbean = this.rtc.getMBean();
        }
        catch (RemoteThreadsException e) {
            System.err.println("Can't get the MBean");
            e.printStackTrace();
        }
        return mbean;
    }

    public void close() {
        try {
            this.rtc.close();
        }
        catch (RemoteThreadsException e) {
            System.err.println("Can't close connection to the MBean server");
        }
    }
}

