/*
 * Decompiled with CFR 0.152.
 */
package alma.ssr.observingmodes;

import alma.ssr.observingmodes.TargetType;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Group
implements Serializable {
    private int _number;
    private boolean _has_number;
    private boolean _required;
    private boolean _has_required;
    private ArrayList _targetTypeList = new ArrayList();

    public void addTargetType(TargetType targetType) throws IndexOutOfBoundsException {
        this._targetTypeList.add(targetType);
    }

    public void addTargetType(int n, TargetType targetType) throws IndexOutOfBoundsException {
        this._targetTypeList.add(n, targetType);
    }

    public void clearTargetType() {
        this._targetTypeList.clear();
    }

    public void deleteNumber() {
        this._has_number = false;
    }

    public void deleteRequired() {
        this._has_required = false;
    }

    public Enumeration enumerateTargetType() {
        return new IteratorEnumeration(this._targetTypeList.iterator());
    }

    public int getNumber() {
        return this._number;
    }

    public boolean getRequired() {
        return this._required;
    }

    public TargetType getTargetType(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._targetTypeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (TargetType)this._targetTypeList.get(n);
    }

    public TargetType[] getTargetType() {
        int n = this._targetTypeList.size();
        TargetType[] targetTypeArray = new TargetType[n];
        for (int i = 0; i < n; ++i) {
            targetTypeArray[i] = (TargetType)this._targetTypeList.get(i);
        }
        return targetTypeArray;
    }

    public int getTargetTypeCount() {
        return this._targetTypeList.size();
    }

    public boolean hasNumber() {
        return this._has_number;
    }

    public boolean hasRequired() {
        return this._has_required;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException validationException) {
            return false;
        }
        return true;
    }

    public void marshal(Writer writer) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)writer);
    }

    public void marshal(ContentHandler contentHandler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)contentHandler);
    }

    public boolean removeTargetType(TargetType targetType) {
        boolean bl = this._targetTypeList.remove(targetType);
        return bl;
    }

    public void setNumber(int n) {
        this._number = n;
        this._has_number = true;
    }

    public void setRequired(boolean bl) {
        this._required = bl;
        this._has_required = true;
    }

    public void setTargetType(int n, TargetType targetType) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._targetTypeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._targetTypeList.set(n, targetType);
    }

    public void setTargetType(TargetType[] targetTypeArray) {
        this._targetTypeList.clear();
        for (int i = 0; i < targetTypeArray.length; ++i) {
            this._targetTypeList.add(targetTypeArray[i]);
        }
    }

    public static Group unmarshalGroup(Reader reader) throws MarshalException, ValidationException {
        return (Group)Unmarshaller.unmarshal(Group.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

