<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:id="Alma/ObsPrep/SchedBlock"
                xmlns:op="Alma/ObsPrep/ObsProject"
		xmlns:vt="Alma/ValueTypes">
		
<!--Two significant sets of changes, plus some minor ones.
    Major 1: Change to schemaversioning, modify the top level and the entity
    Major 2: Significant structural changes to the SpectralSpec item for total power work
    Minors: Add uniDirectionalScan to HolographyParameters
-->

<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>


<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<!-- This forms the basis of the project document transform, ensuring that the information is copied.
     All other templates will override this to do something else -->

<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>

<xsl:template match="id:SchedBlock">
<SchedBlock xmlns="Alma/ObsPrep/SchedBlock">
  <xsl:attribute name="schemaVersion">9</xsl:attribute>
  <xsl:attribute name="revision"><xsl:value-of select="@revision"/></xsl:attribute>
  <!-- "status" element becomes an attribute (enumerated) - try with no value  to start with  -->
<!-- <xsl:attribute name="status"></xsl:attribute> -->
  <xsl:attribute name="xsi:type">SchedBlock</xsl:attribute>
  <xsl:apply-templates select="node()"/> 
  <xsl:comment>Converted to V9 by SchedBlock8-9.xslt</xsl:comment>
</SchedBlock>
</xsl:template>

<xsl:template match="id:SchedBlockEntity">
<SchedBlockEntity>
<xsl:attribute name="entityId"><xsl:value-of select="@entityId"/></xsl:attribute>
<xsl:attribute name="entityIdEncrypted"><xsl:value-of select="@entityIdEncrypted"/></xsl:attribute>
<xsl:attribute name="entityTypeName"><xsl:value-of select="@entityTypeName"/></xsl:attribute>
<xsl:attribute name="schemaVersion">9</xsl:attribute>
</SchedBlockEntity>
</xsl:template>

<!-- "status" element becomes an attribute (enumerated) - delete the element version -->
<xsl:template match="id:SchedBlock/op:status"></xsl:template>


</xsl:stylesheet>
