<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:id="Alma/ObsPrep/SchedBlock"
                xmlns:op="Alma/ObsPrep/ObsProject"
		xmlns:vt="Alma/ValueTypes">
		
<!-- Major change for this script is the reworking of the Correlator configuration
	to allow for the ACA Correlator.  Since old projects did not support the ACA corr,
	then assume ALL correlator configurations are BL ones - this simplifies things.
	(But it does leave a loophole in that if someone had specified ACA as arrayRequested
	then the SB will become invalid - leave this possibility to be sorted by the user, it is
	unlikely and really non problematic in any case
-->

<!--
     Notice that I've put 
                 xmlns:id="Alma/ObsPrep/SchedBlock"
     in as a namespace and used it to match against. This is the 
     same URI (Alma/ObsPrep/SchedBlock) as the default namespace in the
     Alma documents. For an idea of why this is necessary, see 
     http://www.topxml.com/people/bosley/defaultns.asp
 -->
<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- Be careful - this matches ALL attributes called datamodelVersion
     'cause I couldn't figure out how to address ObsProjectEntity -->
<xsl:template match="id:SchedBlockEntity/@datamodelVersion">
  <xsl:attribute name="datamodelVersion">1.74</xsl:attribute>
  <xsl:comment>Converted to 1.74 by SchedBlock50-60.xslt</xsl:comment>
</xsl:template>


<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>

<!-- Change the holography parameters, to eliminate resolution and replace with rows/size. -->
<xsl:template match="id:HolographyParameters">
<HolographyParameters>
   <xsl:attribute name="entityPartId"><xsl:value-of select="./@entityPartId"/></xsl:attribute>
      <xsl:attribute name="towerName"><xsl:value-of select="./@towerName"/></xsl:attribute>
         <xsl:attribute name="scanDirection"><xsl:value-of select="./@scanDirection"/></xsl:attribute>
            <xsl:attribute name="calMode"><xsl:value-of select="./@calMode"/></xsl:attribute>
<!-- Delete resolution (i.e. do nothing) -->

<!-- Add nRows and rowSize -->
   <nRows>180</nRows>
   <rowSize unit="degrees">1.24</rowSize>

<!-- Simply copy most things -->
   <xsl:apply-templates select="./id:name"/>
   <xsl:apply-templates select="./id:frequency"/>
   <xsl:apply-templates select="./id:startFraction"/>
   <xsl:apply-templates select="./id:speed"/>
   <xsl:apply-templates select="./id:rowsCal"/>
   <xsl:apply-templates select="./id:calTime"/>
   
</HolographyParameters>

</xsl:template>


</xsl:stylesheet>
