<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:id="Alma/ObsPrep/SchedBlock"
                xmlns:op="Alma/ObsPrep/ObsProject"
		xmlns:vt="Alma/ValueTypes">
<!--
     Notice that I've put 
                 xmlns:id="Alma/ObsPrep/SchedBlock"
     in as a namespace and used it to match against. This is the 
     same URI (Alma/ObsPrep/SchedBlock) as the default namespace in the
     Alma documents. For an idea of why this is necessary, see 
     http://www.topxml.com/people/bosley/defaultns.asp
 -->
<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- Be careful - this matches ALL attributes called datamodelVersion
     'cause I couldn't figure out how to address ObsProjectEntity -->
<xsl:template match="id:SchedBlockEntity/@datamodelVersion">
  <xsl:attribute name="datamodelVersion">1.62</xsl:attribute>
  <xsl:comment>Converted to 1.62 by SchedBlock30-40.xslt</xsl:comment>
</xsl:template>


<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>

<!-- Add ABSOLUTE to sourceCoordinates if it is not there... -->
<xsl:template match="id:sourceCoordinates">
<sourceCoordinates>
   <xsl:attribute name="system"><xsl:value-of select="@system"/></xsl:attribute>
   <xsl:choose>
   <xsl:when test="@type">
      <xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
         </xsl:when>
   <xsl:otherwise>
      <xsl:attribute name="type">ABSOLUTE</xsl:attribute>
   </xsl:otherwise>
   </xsl:choose>
   <xsl:copy-of select="node()"/>
</sourceCoordinates>
</xsl:template>


<!-- All integrationTimes need to switch from "s" to "sec" -->
<xsl:template match="id:integrationTime">
   <integrationTime unit="sec"><xsl:value-of select="."/></integrationTime>
</xsl:template>

</xsl:stylesheet>