<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:id="Alma/ObsPrep/SchedBlock"
                xmlns:op="Alma/ObsPrep/ObsProject"
		xmlns:vt="Alma/ValueTypes">
<!--
     Notice that I've put 
                 xmlns:id="Alma/ObsPrep/SchedBlock"
     in as a namespace and used it to match against. This is the 
     same URI (Alma/ObsPrep/SchedBlock) as the default namespace in the
     Alma documents. For an idea of why this is necessary, see 
     http://www.topxml.com/people/bosley/defaultns.asp
 -->
<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- Be careful - this matches ALL attributes called datamodelVersion
     'cause I couldn't figure out how to address ObsProjectEntity -->
<xsl:template match="id:SchedBlockEntity/@datamodelVersion">
  <xsl:attribute name="datamodelVersion">1.59</xsl:attribute>
  <xsl:comment>Converted from 1.58 to 1.59 by SchedBlock158-159.xslt</xsl:comment>
</xsl:template>

<!-- Rename the array names in array Requested -->
<xsl:template match="op:ObsUnitControl">
<ObsUnitControl>
   <xsl:choose>
      <xsl:when test="@arrayRequested = 'ALMAMain'">
         <xsl:attribute name="arrayRequested">TWELVE-M</xsl:attribute>
      </xsl:when>
      <xsl:when test="@arrayRequested = 'ACA7m'">
         <xsl:attribute name="arrayRequested">SEVEN-M</xsl:attribute>
      </xsl:when>
      <xsl:when test="@arrayRequested = 'ACA12m'">
         <xsl:attribute name="arrayRequested">TP-Array</xsl:attribute>
      </xsl:when>
      <xsl:when test="@arrayRequested = 'ACA12m+7m'">
         <xsl:attribute name="arrayRequested">ACA</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="arrayRequested">Unknown</xsl:attribute>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates/>
</ObsUnitControl>
</xsl:template>

<!-- Make modeType an attribute from an element, and change modetype="Observer" to "User" 
     Note that when addressing the SchedBlock (root) element the namespace appears to be necessary -->
<xsl:template match="id:SchedBlock">
<SchedBlock xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="SchedBlock">
   <xsl:choose>
      <xsl:when test="./id:modeType = 'Observer'">
         <xsl:attribute name="modeType">User</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="modeType"><xsl:value-of select="./id:modeType"/></xsl:attribute>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates/>
</SchedBlock>
</xsl:template>

<!-- and delete the modeType element -->
<xsl:template match="id:modeType"></xsl:template>

<!-- Rename Receiver bands - struggling with this at moment -->
<xsl:template match="id:SpectralSpec/id:FrequencySetup">
<FrequencySetup>
   <xsl:choose>
      <xsl:when test="./id:receiverBand = '1'">
         <xsl:attribute name="receiverBand">ALMA_RB_01</xsl:attribute>
      </xsl:when>
      <xsl:when test="./id:receiverBand = '2'">
         <xsl:attribute name="receiverBand">ALMA_RB_02</xsl:attribute>
      </xsl:when>
      <xsl:when test="./id:receiverBand = '3'">
         <xsl:attribute name="receiverBand">ALMA_RB_03</xsl:attribute>
      </xsl:when>
      <xsl:when test="./id:receiverBand = '4'">
         <xsl:attribute name="receiverBand">ALMA_RB_04</xsl:attribute>
      </xsl:when>
      <xsl:when test="./id:receiverBand = '5'">
         <xsl:attribute name="receiverBand">ALMA_RB_05</xsl:attribute>
      </xsl:when>
      <xsl:when test="./id:receiverBand = '6'">
         <xsl:attribute name="receiverBand">ALMA_RB_06</xsl:attribute>
      </xsl:when>
      <xsl:when test="./id:receiverBand = '7'">
         <xsl:attribute name="receiverBand">ALMA_RB_07</xsl:attribute>
      </xsl:when>
      <xsl:when test="./id:receiverBand = '8'">
         <xsl:attribute name="receiverBand">ALMA_RB_08</xsl:attribute>
      </xsl:when>
      <xsl:when test="./id:receiverBand = '9'">
         <xsl:attribute name="receiverBand">ALMA_RB_09</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="receiverBand">Unknown</xsl:attribute>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates/>
</FrequencySetup>
</xsl:template>

<!-- delete receiverBand element -->
<xsl:template match="id:receiverBand"></xsl:template>

<!-- Add a copy of "intergrationTime" from SpectralSpec into Science Parameters 
     we *should do this*. But it will be tricky - we need to dereference which particular
     SpectralSpec is in use first. Perhaps it will be simpler to set a default... -->

<!-- Rename intTimeReference -->
<xsl:template match="id:Reference/id:intTimeReference">
<integrationTime>
    <xsl:copy-of select="@* | node()"/>
</integrationTime>
</xsl:template>

<!-- Delete intTimeSource -->
<xsl:template match="id:Reference/id:intTimeSource"></xsl:template>

<!-- Refactor RectanglePattern -->
<xsl:template match="id:RectanglePattern/id:phaseCenterCoordinates">
<patternCenterCoordinates>
<!--    <xsl:copy-of select="@* | node()"/> -->
    <xsl:apply-templates select="@* | node()"/>
</patternCenterCoordinates>
</xsl:template>

<!-- Delete longitudeStep -->
<xsl:template match="id:RectanglePattern/id:longitudeStep"></xsl:template>

<!-- Rename latitudeStep -->
<xsl:template match="id:RectanglePattern/id:latitudeStep">
<orthogonalStep>
    <xsl:copy-of select="@* | node()"/>
</orthogonalStep>
</xsl:template>

<!-- Rename offset and absolute pointing patterns -->
<xsl:template match="id:OffsetPointingPattern">
<PointingPattern>
    <xsl:apply-templates select="@* | node()"/>
</PointingPattern>
</xsl:template>

<!-- Add RELATIVE to phaseCenterCoordinates if it is not there... -->
<xsl:template match="id:OffsetPointingPattern/id:phaseCenterCoordinates">
<phaseCenterCoordinates>
   <xsl:choose>
   <xsl:when test="@system">
      <xsl:attribute name="system"><xsl:value-of select="@system"/></xsl:attribute>
         </xsl:when>
   <xsl:otherwise>
      <xsl:attribute name="system">J2000</xsl:attribute>
   </xsl:otherwise>
   </xsl:choose>
   <xsl:choose>
   <xsl:when test="@type">
      <xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
         </xsl:when>
   <xsl:otherwise>
      <xsl:attribute name="type">RELATIVE</xsl:attribute>
   </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates select="node()"/>
</phaseCenterCoordinates>
</xsl:template>

<xsl:template match="id:AbsolutePointingPattern">
<PointingPattern>
    <xsl:copy-of select="@* | node()"/>
</PointingPattern>
</xsl:template>

<!-- Add ABSOLUTE to phaseCenterCoordinates if it is not there... -->
<xsl:template match="id:AbsolutePointingPattern/id:phaseCenterCoordinates">
<phaseCenterCoordinates>
   <xsl:choose>
   <xsl:when test="@system">
      <xsl:attribute name="system"><xsl:value-of select="@system"/></xsl:attribute>
         </xsl:when>
   <xsl:otherwise>
      <xsl:attribute name="system">J2000</xsl:attribute>
   </xsl:otherwise>
   </xsl:choose>
   <xsl:choose>
   <xsl:when test="@type">
      <xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
         </xsl:when>
   <xsl:otherwise>
      <xsl:attribute name="type">ABSOLUTE</xsl:attribute>
   </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates select="node()"/>
</phaseCenterCoordinates>
</xsl:template>

<!-- Add ABSOLUTE to sourceCoordinates if it is not there... -->
<xsl:template match="id:sourceCoordinates">
<sourceCoordinates>
   <xsl:attribute name="system"><xsl:value-of select="@system"/></xsl:attribute>
   <xsl:choose>
   <xsl:when test="@type">
      <xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
         </xsl:when>
   <xsl:otherwise>
      <xsl:attribute name="type">ABSOLUTE</xsl:attribute>
   </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates select="node()"/>
</sourceCoordinates>
</xsl:template>

<!-- All longitudes and latitudes need to switch to degrees -->
<xsl:template match="vt:longitude">
   <vt:longitude unit="degrees"><xsl:value-of select="."/></vt:longitude>
</xsl:template>
<xsl:template match="id:longitude">
   <vt:longitude unit="degrees"><xsl:value-of select="."/></vt:longitude>
</xsl:template>
<xsl:template match="vt:latitude">
   <vt:latitude unit="degrees"><xsl:value-of select="."/></vt:latitude>
</xsl:template>

<!-- Delete any remaining repeatCounts (just in case...) -->
<xsl:template match="id:repeatCount"></xsl:template>

<!-- Add excursion to PointingCalParameters (if present)
<xsl:template match="id:PointingCalParameters">
<PointingCalParameters>
   <xsl:attribute name="entityPartId"><xsl:value-of select="@entityPartId"/></xsl:attribute>
   <excursion unit="arcsec">30.0</excursion>
   <xsl:apply-templates select="node()"/>
</PointingCalParameters>
</xsl:template>
-->
<!-- Add integrationTime to ScienceParameters (if present) -->
<xsl:template match="id:ScienceParameters">
<ScienceParameters>
   <xsl:attribute name="entityPartId"><xsl:value-of select="@entityPartId"/></xsl:attribute>
   <integrationTime unit="sec">1.0</integrationTime>
   <xsl:apply-templates select="node()"/>
</ScienceParameters>
</xsl:template>

<!--
  Dont do this, it produces a weird duplicate namesapce called id;
    <xsl:element name="executionCount" namespace="Alma/ObsPrep/SchedBlock">
        <xsl:value-of select="."/>
    </xsl:element>
-->


<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>
</xsl:stylesheet>
