<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:id="Alma/ObsPrep/SchedBlock"
                xmlns:op="Alma/ObsPrep/ObsProject"
		xmlns:vt="Alma/ValueTypes">
<!--
     Notice that I've put 
                 xmlns:id="Alma/ObsPrep/SchedBlock"
     in as a namespace and used it to match against. This is the 
     same URI (Alma/ObsPrep/SchedBlock) as the default namespace in the
     Alma documents. For an idea of why this is necessary, see 
     http://www.topxml.com/people/bosley/defaultns.asp
 -->
<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- Be careful - this matches ALL attributes called datamodelVersion
     'cause I couldn't figure out how to address ObsProjectEntity -->
<xsl:template match="id:SchedBlockEntity/@datamodelVersion">
  <xsl:attribute name="datamodelVersion">1.58.4.4</xsl:attribute>
  <xsl:comment>Converted from 1.58 to 1.58.4.4 by SchedBlock158-15844.xslt</xsl:comment>
</xsl:template>


<!-- Rename array names -->
<xsl:template match="op:ObsUnitControl[@arrayRequested='ALMAMain']">
<ObsUnitControl>
  <xsl:attribute name="almatype">APDM::ObsUnitControl</xsl:attribute>
  <xsl:attribute name="arrayRequested">TWELVE-M</xsl:attribute>
  <xsl:copy-of select="node()"/>
</ObsUnitControl>
</xsl:template>

<xsl:template match="op:ObsUnitControl[@arrayRequested='ACA7m']">
<ObsUnitControl>
  <xsl:attribute name="almatype">APDM::ObsUnitControl</xsl:attribute>
  <xsl:attribute name="arrayRequested">SEVEN-M</xsl:attribute>
  <xsl:copy-of select="node()"/>
</ObsUnitControl>
</xsl:template>

<xsl:template match="op:ObsUnitControl[@arrayRequested='ACA12m']">
<ObsUnitControl>
  <xsl:attribute name="almatype">APDM::ObsUnitControl</xsl:attribute>
  <xsl:attribute name="arrayRequested">TP-Array</xsl:attribute>
  <xsl:copy-of select="node()"/>
</ObsUnitControl>
</xsl:template>

<xsl:template match="op:ObsUnitControl[@arrayRequested='ACA12m+7m']">
<ObsUnitControl>
  <xsl:attribute name="almatype">APDM::ObsUnitControl</xsl:attribute>
  <xsl:attribute name="arrayRequested">ACA</xsl:attribute>
  <xsl:copy-of select="node()"/>
</ObsUnitControl>
</xsl:template>

<!-- Rename any modetype="Observer"
<xsl:template match="id:SchedBlock[id:modeType='Observer']">
  <xsl:attribute name="modeType">User</xsl:attribute>
</xsl:template> -->
<xsl:template match="id:modeType"></xsl:template>

<!-- delete receiverBand for now - should be renaming it -->
<xsl:template match="id:receiverBand"></xsl:template>

<!-- Rename Receiver bands - struggling with this at moment
<xsl:template match="id:SpectralSpec/id:FrequencySetup[id:receiverBand='1']">
<FrequencySetup almatype="APDM::FrequencySetup">
  <xsl:copy-of select="id:restFrequency"/>
  <xsl:copy-of select="id:transitionName"/>
  <receiverBand>ALMA_RB_01</receiverBand>
</FrequencySetup>
</xsl:template>
<xsl:template match="id:SpectralSpec/id:FrequencySetup[id:receiverBand='2']">
<FrequencySetup almatype="APDM::FrequencySetup">
  <xsl:copy-of select="id:restFrequency"/>
  <xsl:copy-of select="id:transitionName"/>
  <receiverBand>ALMA_RB_02</receiverBand>
</FrequencySetup>
</xsl:template>
<xsl:template match="id:SpectralSpec/id:FrequencySetup[id:receiverBand='3']">
<FrequencySetup almatype="APDM::FrequencySetup">
  <xsl:copy-of select="id:restFrequency"/>
  <xsl:copy-of select="id:transitionName"/>
  <receiverBand>ALMA_RB_03</receiverBand>
</FrequencySetup>
</xsl:template>
<xsl:template match="id:SpectralSpec/id:FrequencySetup[id:receiverBand='4']">
<FrequencySetup almatype="APDM::FrequencySetup">
  <xsl:copy-of select="id:restFrequency"/>
  <xsl:copy-of select="id:transitionName"/>
  <receiverBand>ALMA_RB_04</receiverBand>
</FrequencySetup>
</xsl:template>
<xsl:template match="id:SpectralSpec/id:FrequencySetup[id:receiverBand='5']">
<FrequencySetup almatype="APDM::FrequencySetup">
  <xsl:copy-of select="id:restFrequency"/>
  <xsl:copy-of select="id:transitionName"/>
  <receiverBand>ALMA_RB_05</receiverBand>
</FrequencySetup>
</xsl:template>
<xsl:template match="id:SpectralSpec/id:FrequencySetup[id:receiverBand='6']">
<FrequencySetup almatype="APDM::FrequencySetup">
  <xsl:copy-of select="id:restFrequency"/>
  <xsl:copy-of select="id:transitionName"/>
  <receiverBand>ALMA_RB_06</receiverBand>
</FrequencySetup>
</xsl:template>
<xsl:template match="id:SpectralSpec/id:FrequencySetup[id:receiverBand='7']">
<FrequencySetup almatype="APDM::FrequencySetup">
  <xsl:copy-of select="id:restFrequency"/>
  <xsl:copy-of select="id:transitionName"/>
  <receiverBand>ALMA_RB_07</receiverBand>
</FrequencySetup>
</xsl:template>
<xsl:template match="id:SpectralSpec/id:FrequencySetup[id:receiverBand='8']">
<FrequencySetup almatype="APDM::FrequencySetup">
  <xsl:copy-of select="id:restFrequency"/>
  <xsl:copy-of select="id:transitionName"/>
  <receiverBand>ALMA_RB_08</receiverBand>
</FrequencySetup>
</xsl:template>
<xsl:template match="id:SpectralSpec/id:FrequencySetup[id:receiverBand='9']">
<FrequencySetup almatype="APDM::FrequencySetup">
  <xsl:copy-of select="id:restFrequency"/>
  <xsl:copy-of select="id:transitionName"/>
  <receiverBand>ALMA_RB_09</receiverBand>
</FrequencySetup>
</xsl:template>
<xsl:template match="id:SpectralSpec/id:FrequencySetup[id:receiverBand='10']">
<FrequencySetup almatype="APDM::FrequencySetup">
  <xsl:copy-of select="id:restFrequency"/>
  <xsl:copy-of select="id:transitionName"/>
  <receiverBand>ALMA_RB_10</receiverBand>
</FrequencySetup>
</xsl:template> -->


<!-- Rename intTimeReference -->
<xsl:template match="id:Reference/id:intTimeReference">
<integrationTime>
    <xsl:copy-of select="@* | node()"/>
</integrationTime>
</xsl:template>

<!-- Delete intTimeSource -->
<xsl:template match="id:Reference/id:intTimeSource"></xsl:template>

<!-- Refactor RectanglePattern -->
<xsl:template match="id:RectanglePattern/id:phaseCenterCoordinates">
<patternCenterCoordinates>
<!--    <xsl:copy-of select="@* | node()"/> -->
    <xsl:apply-templates select="@* | node()"/>
</patternCenterCoordinates>
</xsl:template>

<!-- Delete longitudeStep -->
<xsl:template match="id:RectanglePattern/id:longitudeStep"></xsl:template>

<!-- Rename latitudeStep -->
<xsl:template match="id:RectanglePattern/id:latitudeStep">
<orthogonalStep>
    <xsl:copy-of select="@* | node()"/>
</orthogonalStep>
</xsl:template>

<!-- Rename offset and absolute pointing patterns -->
<xsl:template match="id:OffsetPointingPattern">
<PointingPattern>
    <xsl:apply-templates select="@* | node()"/>
<!--   <xsl:attribute name="type">RELATIVE</xsl:attribute> -->
</PointingPattern>
</xsl:template>
<xsl:template match="id:AbsolutePointingPattern">
<PointingPattern>
    <xsl:copy-of select="@* | node()"/>
<!--    <type>ABSOLUTE</type> -->
</PointingPattern>
</xsl:template>

<!-- Delete any remaining repeatCounts (just in case...) -->
<xsl:template match="id:repeatCount"></xsl:template>

<!-- All longitudes and latitudes need to switch to degrees -->
<xsl:template match="vt:longitude">
<longitude unit="degrees"><xsl:value-of select="."/></longitude>
</xsl:template>
<xsl:template match="vt:latitude">
<latitude unit="degrees"><xsl:value-of select="."/></latitude>
</xsl:template>

<!--
  Dont do this, it produces a weird duplicate namesapce called id;
    <xsl:element name="executionCount" namespace="Alma/ObsPrep/SchedBlock">
        <xsl:value-of select="."/>
    </xsl:element>
-->


<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>
</xsl:stylesheet>
