<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:txfms="file:///home/ab/AlmaDev/XsltChain/ConvertZip"
                xmlns:alma="http://www.roe.ac.uk/ukatc/projects/alma/ConvertZip"
                xmlns:op="Alma/ObsPrep/ObsProject"
                xmlns:prp="Alma/ObsPrep/ObsProposal"
                xmlns:id="Alma/ObsPrep/SchedBlock"
                xmlns:vt="Alma/ValueTypes">
                
<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- Import the "identity" stylesheet. This will ensure everything is copied to the output,  if 
     not directly addressed below. Still having problems with import. To be investigated.
     So for the moment still have this template in place explicitly. AB 20070720. 
<xsl:import href="alma:basic-copy.xslt"/> 
-->                

<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<!-- This forms the basis of the project document transform, ensuring that the information is copied.
     All other templates will override this to do something else -->

<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>

<xsl:template match="op:ObsProject">
<ObsProject xmlns="Alma/ObsPrep/ObsProject">
  <xsl:attribute name="schemaVersion">9</xsl:attribute>
  <xsl:attribute name="revision"><xsl:value-of select="@revision"/></xsl:attribute>
  <!-- "status" element becomes an attribute (enumerated) - try with no value  to start with  -->
  <xsl:attribute name="status">NewPhase2</xsl:attribute>
  <xsl:attribute name="xsi:type">ObsProject</xsl:attribute>
  <xsl:apply-templates select="node()"/>
  
  <xsl:comment>Converted to V9 by ObsProject8-9.xslt</xsl:comment>

</ObsProject>
</xsl:template>

<xsl:template match="op:ObsProjectEntity">
<ObsProjectEntity>
<xsl:attribute name="entityId"><xsl:value-of select="@entityId"/></xsl:attribute>
<xsl:attribute name="entityIdEncrypted"><xsl:value-of select="@entityIdEncrypted"/></xsl:attribute>
<xsl:attribute name="entityTypeName"><xsl:value-of select="@entityTypeName"/></xsl:attribute>
<xsl:attribute name="schemaVersion">9</xsl:attribute>
</ObsProjectEntity>
</xsl:template>

<!-- "status" element becomes an attribute (enumerated) - delete the element version -->
<xsl:template match="op:status"></xsl:template>
  
  <!-- "status" element becomes an attribute (enumerated) - delete the element version
  <xsl:template match="op:ObsUnitSet/op:status"></xsl:template> -->
  
</xsl:stylesheet>
