<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:txfms="file:///home/ab/AlmaDev/XsltChain/ConvertZip"
                xmlns:alma="http://www.roe.ac.uk/ukatc/projects/alma/ConvertZip"
                xmlns:op="Alma/ObsPrep/ObsProject"
                xmlns:vt="Alma/ValueTypes">
                
<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- Import the "identity" stylesheet. This will ensure everything is copied to the output,  if 
     not directly addressed below. Still having problems with import. To be investigated.
     So for the moment still have this template in place explicitly. AB 20070720. 
<xsl:import href="alma:basic-copy.xslt"/> 
-->                

<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<!-- This forms the basis of the project document transform, ensuring that the information is copied.
     All other templates will override this to do something else -->

<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>

  <!-- All unit attributes with certain values need changing -->
  <xsl:template match="@unit">
    <xsl:choose>
      <xsl:when test="current()='sec'">
        <xsl:attribute name="unit">s</xsl:attribute>
      </xsl:when>
      <xsl:when test="current()='min'">
        <xsl:attribute name="unit">m</xsl:attribute>
      </xsl:when>
      <xsl:when test="current()='hrs'">
        <xsl:attribute name="unit">h</xsl:attribute>
      </xsl:when>
      <xsl:when test="current()='degrees'">
        <xsl:attribute name="unit">deg</xsl:attribute>
      </xsl:when>
      <xsl:when test="current()='radians'">
        <xsl:attribute name="unit">rad</xsl:attribute>
      </xsl:when>
      <xsl:when test="current()='micsec'">
        <xsl:attribute name="unit">us</xsl:attribute>
      </xsl:when>
      <xsl:when test="current()='msec'">
        <xsl:attribute name="unit">ms</xsl:attribute>
      </xsl:when>
      <xsl:when test="current()='nsec'">
        <xsl:attribute name="unit">ns</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  

<!-- For ObsProject modify the entity and copy everything else -->

<xsl:template match="op:ObsProject">
<ObsProject xmlns="Alma/ObsPrep/ObsProject">
  <xsl:attribute name="schemaVersion">7</xsl:attribute>
  <xsl:attribute name="revision"><xsl:value-of select="op:ObsProjectEntity/@datamodelVersion"/></xsl:attribute>
  <xsl:attribute name="xsi:type">ObsProject</xsl:attribute>
  <xsl:apply-templates select="node()"/>
 
  <xsl:comment>Converted to V7 by ObsProject60-7.xslt</xsl:comment>
  
</ObsProject>
</xsl:template>

<xsl:template match="op:ObsProjectEntity">
<ObsProjectEntity>
<xsl:attribute name="entityId"><xsl:value-of select="@entityId"/></xsl:attribute>
<xsl:attribute name="entityIdEncrypted"><xsl:value-of select="@entityIdEncrypted"/></xsl:attribute>
<xsl:attribute name="entityTypeName"><xsl:value-of select="@entityTypeName"/></xsl:attribute>
<xsl:attribute name="schemaVersion">7</xsl:attribute>
</ObsProjectEntity>
</xsl:template>

<!-- move polarisation from perf params to spectral setup - just delete it and add the new default of "DOUBLE"-->
<xsl:template match="op:SpectralSetupParameters">
  <SpectralSetupParameters>
  <xsl:attribute name="polarisation">DOUBLE</xsl:attribute>
  <xsl:choose>
    <xsl:when test="./@type='line'">
      <xsl:attribute name="type">full</xsl:attribute>
    </xsl:when>
    <xsl:otherwise>
       <xsl:apply-templates select="./@type"/>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:apply-templates select="./op:SpectralLine"></xsl:apply-templates>
  <xsl:apply-templates select="./op:SpectralContinuum"></xsl:apply-templates>

</SpectralSetupParameters>
</xsl:template>

 <xsl:template match="op:PerformanceParameters/op:polarisation">
</xsl:template>

<!-- Both SpectralLine and SpectralContinuum become a ScienceSpectralWindow -->
  <xsl:template match="op:SpectralContinuum">
    <ScienceSpectralWindow>
      <xsl:attribute name="groupResourceUse">FULL</xsl:attribute>
      <centerFrequency>
        <xsl:attribute name="unit"><xsl:value-of select="./op:restFrequency/@unit"/></xsl:attribute>
        <xsl:value-of select="./op:restFrequency"/>
      </centerFrequency>
      <transitionName>Continuum</transitionName>
      <bandWidth units="GHz">2.0</bandWidth>
      <spectralResolution units="MHz">1.0</spectralResolution>
      <isContinuum>true</isContinuum>
      <groupIndex>1</groupIndex>
    </ScienceSpectralWindow>
  </xsl:template>
  
  <xsl:template match="op:SpectralLine">
    <ScienceSpectralWindow>
      <xsl:attribute name="groupResourceUse">FULL</xsl:attribute>
      <centerFrequency>
        <xsl:attribute name="unit"><xsl:value-of select="./op:restFrequency/@unit"/></xsl:attribute>
        <xsl:value-of select="./op:restFrequency"/>
      </centerFrequency>
      <xsl:apply-templates select="./op:transitionName"/>
      <xsl:apply-templates select="./op:bandWidth"/>
      <xsl:apply-templates select="./op:spectralResolution"/>
      <isContinuum>false</isContinuum>
      <groupIndex>1</groupIndex>
    </ScienceSpectralWindow>
  </xsl:template>
</xsl:stylesheet>
