<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:op="Alma/ObsPrep/ObsProject"
                xmlns:vt="Alma/ValueTypes">
                
<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- Be careful - this matches ALL attributes called datamodelVersion
     'cause I couldn't figure out how to address ObsProjectEntity -->
<xsl:template match="@datamodelVersion">
  <xsl:attribute name="datamodelVersion">1.58.4.4</xsl:attribute>
  <xsl:comment>Converted from 1.58 to 1.58.4.4 by ObsProject158-15844.xslt</xsl:comment>
</xsl:template>

<!-- Rename array names -->
<xsl:template match="op:ObsUnitControl[@arrayRequested='ALMAMain']">
<ObsUnitControl>
  <xsl:attribute name="almatype">APDM::ObsUnitControl</xsl:attribute>
  <xsl:attribute name="arrayRequested">TWELVE-M</xsl:attribute>
  <xsl:copy-of select="node()"/>
</ObsUnitControl>
</xsl:template>

<xsl:template match="op:ObsUnitControl[@arrayRequested='ACA7m']">
<ObsUnitControl>
  <xsl:attribute name="almatype">APDM::ObsUnitControl</xsl:attribute>
  <xsl:attribute name="arrayRequested">SEVEN-M</xsl:attribute>
  <xsl:copy-of select="node()"/>
</ObsUnitControl>
</xsl:template>

<xsl:template match="op:ObsUnitControl[@arrayRequested='ACA12m']">
<ObsUnitControl>
  <xsl:attribute name="almatype">APDM::ObsUnitControl</xsl:attribute>
  <xsl:attribute name="arrayRequested">TP-Array</xsl:attribute>
  <xsl:copy-of select="node()"/>
</ObsUnitControl>
</xsl:template>

<xsl:template match="op:ObsUnitControl[@arrayRequested='ACA12m+7m']">
<ObsUnitControl>
  <xsl:attribute name="almatype">APDM::ObsUnitControl</xsl:attribute>
  <xsl:attribute name="arrayRequested">ACA</xsl:attribute>
  <xsl:copy-of select="node()"/>
</ObsUnitControl>
</xsl:template>

<!-- Add type=RELATIVE to SingleFieldTargetParameters.pointingCenter -->
<xsl:template match="op:pointingCenter">
<pointingCenter>
    <xsl:copy-of select="@* | node()"/>
<!--    <type>RELATIVE</type> -->
</pointingCenter>
</xsl:template>

<!-- All longitudes and latitudes need to switch to degrees -->
<xsl:template match="vt:longitude">
<longitude unit="degrees"><xsl:value-of select="."/></longitude>
</xsl:template>
<xsl:template match="vt:latitude">
<latitude unit="degrees"><xsl:value-of select="."/></latitude>
</xsl:template>

<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>
</xsl:stylesheet>
