/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import uk.ac.starlink.plastic.ValueTypeException;

public class ValueType {
    private final String name_;
    private final Class jClazz_;
    private final Object blank_;
    public static ValueType ANY = new ValueType("ANY", Object.class, ""){

        public void checkJavaValue(Object jValue) throws ValueTypeException {
            super.checkJavaValue(jValue);
            ValueType.checkObject(jValue);
        }
    };
    public static ValueType INT = new ValueType("INT", Integer.class, new Integer(0));
    public static ValueType BOOLEAN = new ValueType("BOOLEAN", Boolean.class, Boolean.FALSE);
    public static ValueType STRING = new ValueType("STRING", String.class, "");
    public static ValueType DOUBLE = new ValueType("DOUBLE", Double.class, new Double(0.0));
    public static ValueType DATE = new ValueType("DATE", Date.class, new Date(0L));
    public static ValueType MAP = new ValueType("MAP", Map.class, new Hashtable()){

        public void checkJavaValue(Object jValue) throws ValueTypeException {
            super.checkJavaValue(jValue);
            ValueType.checkMap((Map)jValue);
        }
    };
    public static ValueType LIST = new ValueType("LIST", List.class, new Vector()){

        public void checkJavaValue(Object jValue) throws ValueTypeException {
            super.checkJavaValue(jValue);
            ValueType.checkList((List)jValue);
        }
    };
    public static ValueType VOID = new ValueType("VOID", null, null){

        public void checkJavaValue(Object jValue) throws ValueTypeException {
            if (!(jValue == null || "".equals(jValue) || jValue instanceof Collection && ((Collection)jValue).isEmpty())) {
                throw new ValueTypeException("Value " + jValue + " should have been null");
            }
        }
    };
    public static ValueType STRING_URL = new ValueType("STRING_URL", String.class, ""){

        public void checkJavaValue(Object jValue) throws ValueTypeException {
            super.checkJavaValue(jValue);
            String str = (String)jValue;
            try {
                new URL(str);
                if (str.matches("file:/?[^/].*")) {
                    throw new ValueTypeException("file:-type URL " + str + " " + "violates RFC1738 - " + "should be " + "file://localhost/...");
                }
            }
            catch (MalformedURLException e) {
                throw new ValueTypeException("Badly formed URL: " + str, e);
            }
        }
    };
    public static ValueType STRING_IVORN = new ValueType("STRING_IVORN", String.class, ""){

        public void checkJavaValue(Object jValue) throws ValueTypeException {
            super.checkJavaValue(jValue);
            String str = (String)jValue;
            try {
                new URI(str);
                if (!str.startsWith("ivo:")) {
                    throw new ValueTypeException("IVORN should start ivo:  not " + str);
                }
            }
            catch (URISyntaxException e) {
                throw new ValueTypeException("Badly formed URI: " + str, e);
            }
        }
    };
    public static ValueType STRING_URI = new ValueType("STRING_URI", String.class, ""){

        public void checkJavaValue(Object jValue) throws ValueTypeException {
            super.checkJavaValue(jValue);
            String str = (String)jValue;
            try {
                new URI(str);
            }
            catch (URISyntaxException e) {
                throw new ValueTypeException("Badly formed URI: " + str, e);
            }
        }
    };
    public static ValueType LIST_INTS = new ValueType("LIST_INTS", List.class, new Vector()){

        public void checkJavaValue(Object jValue) throws ValueTypeException {
            super.checkJavaValue(jValue);
            List list = (List)jValue;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                if (it.next() instanceof Integer) continue;
                throw new ValueTypeException("List elements are not all Integers");
            }
        }
    };

    public ValueType(String name, Class jClazz, Object blank) {
        this.name_ = name;
        this.jClazz_ = jClazz;
        this.blank_ = blank;
    }

    public void checkJavaValue(Object jValue) throws ValueTypeException {
        if (jValue == null) {
            throw new ValueTypeException("Null value illegal");
        }
        if (!this.jClazz_.isAssignableFrom(jValue.getClass())) {
            throw new ValueTypeException(jValue + " (" + ValueType.objClassName(jValue) + ")" + " is not a " + ValueType.className(this.jClazz_));
        }
    }

    public Object getBlankValue() {
        return this.blank_;
    }

    public String toString() {
        return this.name_;
    }

    public static ValueType inferValueType(Object value) throws ValueTypeException {
        ValueType.checkObject(value);
        ValueType[] tries = new ValueType[]{INT, BOOLEAN, STRING, DOUBLE, DATE, LIST, MAP};
        for (int i = 0; i < tries.length; ++i) {
            try {
                tries[i].checkJavaValue(value);
                return tries[i];
            }
            catch (ValueTypeException valueTypeException) {
                continue;
            }
        }
        throw new ValueTypeException("Value not of legal type: " + value);
    }

    private static void checkObject(Object obj) throws ValueTypeException {
        if (obj == null) {
            throw new ValueTypeException("Null value illegal");
        }
        Class<?> clazz = obj.getClass();
        if (clazz == Integer.class || clazz == Boolean.class || clazz == String.class || clazz == Double.class || clazz == Date.class || clazz == [B.class) {
            return;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            ValueType.checkMap((Map)obj);
        } else if (List.class.isAssignableFrom(clazz)) {
            ValueType.checkList((List)obj);
        } else {
            throw new ValueTypeException("Unsupported type " + clazz + " of " + obj);
        }
    }

    private static void checkList(List list) throws ValueTypeException {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ValueType.checkObject(it.next());
        }
    }

    private static void checkMap(Map map) throws ValueTypeException {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null) {
                throw new ValueTypeException("Illegal null map key value");
            }
            if (key.getClass() != (class$java$lang$String == null ? ValueType.class$("java.lang.String") : class$java$lang$String)) {
                throw new ValueTypeException("Illegal map key value " + key + " (" + ValueType.objClassName(key) + ")" + " should be a String");
            }
            ValueType.checkObject(value);
        }
    }

    private static String objClassName(Object obj) {
        return obj == null ? "null" : ValueType.className(obj.getClass());
    }

    private static String className(Class clazz) {
        return clazz.getName().replaceFirst("^java\\.lang\\.", "");
    }
}

