/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.logging.Logger;
import net.ladypleaser.rmilite.Client;
import net.ladypleaser.rmilite.Server;
import org.apache.xmlrpc.WebServer;
import org.votech.plastic.PlasticHubListener;
import org.votech.plastic.PlasticListener;
import uk.ac.starlink.plastic.PlasticUtils;

public class ServerSet {
    private final Server rmiServer_;
    private final int rmiPort_;
    private final WebServer xmlrpcServer_;
    private final URL xmlrpcUrl_;
    private final File configFile_;
    private final String serverIdValue_;
    private static final String SERVER_ID_KEY = "uk.ac.starlink.plastic.servid";
    private boolean stopped_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.plastic");

    public ServerSet(File configFile) throws IOException, RemoteException {
        this.configFile_ = configFile;
        this.serverIdValue_ = this.toString();
        if (configFile != null && configFile.exists()) {
            Properties props = new Properties();
            try {
                BufferedInputStream propStream = new BufferedInputStream(new FileInputStream(configFile));
                props.load(propStream);
                ((InputStream)propStream).close();
            }
            catch (IOException e) {
                throw (IOException)new IOException("File " + configFile + "exists " + "but is unreadable").initCause(e);
            }
            String rmiPort = props.getProperty("plastic.rmi.port");
            boolean badFile = false;
            if (rmiPort != null) {
                try {
                    Client client = new Client("localhost", Integer.parseInt(rmiPort));
                    client.exportInterface(PlasticListener.class);
                    PlasticHubListener hub = (PlasticHubListener)client.lookup(PlasticHubListener.class);
                }
                catch (NumberFormatException e) {
                    badFile = true;
                }
                catch (Exception e) {
                    if (this.configFile_.delete()) {
                        logger_.warning("Apparently moribund " + configFile + " - deleting");
                    }
                    throw new IOException("Tried and failed to delete apparently moribund " + configFile);
                }
            } else {
                badFile = true;
            }
            if (configFile.exists()) {
                String msg = badFile ? "File " + configFile + " exists but looks wrong" + " - delete it?" : "Hub described at " + configFile + " is already running";
                throw new IOException(msg);
            }
        }
        int rmiPort = 1098;
        Server rmiServer = null;
        RemoteException rmiBindError = null;
        for (int i = 0; i < 20 && rmiServer == null; ++i) {
            ++rmiPort;
            try {
                rmiServer = new Server(rmiPort);
                continue;
            }
            catch (RemoteException e) {
                rmiBindError = e;
            }
        }
        if (rmiServer == null) {
            throw rmiBindError;
        }
        this.rmiPort_ = rmiPort;
        this.rmiServer_ = rmiServer;
        int xrPort = PlasticUtils.getUnusedPort(2112);
        WebServer xrServer = null;
        try {
            xrServer = new WebServer(xrPort);
            xrServer.start();
        }
        catch (RuntimeException e) {
            throw new RemoteException("Can't start XML-RPC server", e);
        }
        this.xmlrpcServer_ = xrServer;
        this.xmlrpcUrl_ = new URL("http://" + InetAddress.getLocalHost().getCanonicalHostName() + ":" + xrPort + "/");
        if (configFile != null) {
            this.storeConfig(configFile);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                ServerSet.this.stop();
            }
        });
    }

    public Server getRmiServer() {
        return this.rmiServer_;
    }

    public WebServer getXmlRpcServer() {
        return this.xmlrpcServer_;
    }

    public URL getXmlRpcUrl() {
        return this.xmlrpcUrl_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeConfig(File configFile) throws IOException {
        Properties props = new Properties();
        props.setProperty("plastic.version", "0.4");
        props.setProperty("plastic.rmi.port", Integer.toString(this.rmiPort_));
        props.setProperty("plastic.xmlrpc.url", this.xmlrpcUrl_.toString());
        props.setProperty(SERVER_ID_KEY, this.serverIdValue_);
        FileOutputStream out = new FileOutputStream(configFile);
        try {
            props.store(out, "PLASTIC server " + this.getClass().getName());
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        boolean stop;
        ServerSet serverSet = this;
        synchronized (serverSet) {
            stop = !this.stopped_;
            this.stopped_ = true;
        }
        if (stop) {
            try {
                if (this.configFile_ != null && this.configFile_.exists()) {
                    Properties props = new Properties();
                    FileInputStream configStream = new FileInputStream(this.configFile_);
                    try {
                        props.load(configStream);
                    }
                    finally {
                        ((InputStream)configStream).close();
                    }
                    if (this.serverIdValue_.equals(props.getProperty(SERVER_ID_KEY))) {
                        this.configFile_.delete();
                    }
                }
                this.xmlrpcServer_.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.stop();
        }
        finally {
            super.finalize();
        }
    }
}

