/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.votech.plastic.PlasticHubListener;
import uk.ac.starlink.plastic.ApplicationItem;
import uk.ac.starlink.plastic.HubManager;
import uk.ac.starlink.util.gui.ErrorDialog;

public abstract class PlasticTransmitter {
    private final HubManager hubman_;
    private final URI messageId_;
    private final String sendType_;
    private final ListModel appList_;
    private final Action broadcastAct_;
    private List sendActList_;
    private boolean enabled_;
    private List menuList_;

    public PlasticTransmitter(HubManager hubman, URI messageId, String sendType) {
        this.hubman_ = hubman;
        this.messageId_ = messageId;
        this.sendType_ = sendType;
        this.appList_ = hubman.getApplicationListModel();
        this.appList_.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent evt) {
                PlasticTransmitter.this.updateState();
            }

            public void intervalAdded(ListDataEvent evt) {
                PlasticTransmitter.this.updateState();
            }

            public void intervalRemoved(ListDataEvent evt) {
                PlasticTransmitter.this.updateState();
            }
        });
        this.broadcastAct_ = new TransmitAction(null);
        this.broadcastAct_.putValue("Name", "Broadcast " + this.sendType_);
        this.broadcastAct_.putValue("ShortDescription", "Transmit " + sendType + " to all applications " + "listening with the PLASTIC protocol");
        this.enabled_ = true;
        this.menuList_ = new ArrayList();
        this.updateState();
    }

    protected abstract void transmit(PlasticHubListener var1, URI var2, ApplicationItem var3) throws IOException;

    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
        this.updateEnabledness();
    }

    public Action getBroadcastAction() {
        return this.broadcastAct_;
    }

    public JMenu createSendMenu() {
        JMenu menu = new JMenu("Send " + this.sendType_ + " to ...");
        Iterator it = this.sendActList_.iterator();
        while (it.hasNext()) {
            menu.add((Action)it.next());
        }
        menu.setToolTipText("Transmit " + this.sendType_ + " to a single " + "application using PLASTIC");
        this.menuList_.add(menu);
        this.updateEnabledness();
        return menu;
    }

    private void updateState() {
        URI self = this.hubman_.getRegisteredId();
        ArrayList<TransmitAction> actList = new ArrayList<TransmitAction>();
        for (int i = 0; i < this.appList_.getSize(); ++i) {
            List msgs;
            ApplicationItem app = (ApplicationItem)this.appList_.getElementAt(i);
            if (app.getId().equals(self) || (msgs = app.getSupportedMessages()) != null && !msgs.isEmpty() && !msgs.contains(this.messageId_)) continue;
            actList.add(new TransmitAction(app));
        }
        if (!((Object)actList).equals(this.sendActList_)) {
            this.sendActList_ = actList;
            Iterator menuIt = this.menuList_.iterator();
            while (menuIt.hasNext()) {
                JMenu menu = (JMenu)menuIt.next();
                menu.removeAll();
                Iterator actIt = this.sendActList_.iterator();
                while (actIt.hasNext()) {
                    menu.add((Action)actIt.next());
                }
            }
            this.updateEnabledness();
        }
    }

    private void updateEnabledness() {
        boolean active = this.enabled_ && this.sendActList_.size() > 0;
        this.broadcastAct_.setEnabled(this.enabled_);
        Iterator it = this.menuList_.iterator();
        while (it.hasNext()) {
            ((JMenu)it.next()).setEnabled(active);
        }
    }

    private class TransmitAction
    extends AbstractAction {
        final ApplicationItem app_;

        TransmitAction(ApplicationItem app) {
            super(app == null ? "Broadcast" : "Send to " + app);
            this.app_ = app;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                PlasticTransmitter.this.hubman_.register();
                PlasticHubListener hub = PlasticTransmitter.this.hubman_.getHub();
                URI clientId = PlasticTransmitter.this.hubman_.getRegisteredId();
                if (hub != null && clientId != null) {
                    PlasticTransmitter.this.transmit(hub, clientId, this.app_);
                }
            }
            catch (IOException e) {
                Object src = evt.getSource();
                Component parent = src instanceof Component ? (Component)src : null;
                ErrorDialog.showError((Component)parent, (String)"PLASTIC Send Error", (Throwable)e);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof TransmitAction) {
                TransmitAction other = (TransmitAction)o;
                return this.app_ == null && other.app_ == null || this.app_ != null && this.app_.equals(other.app_);
            }
            return false;
        }

        public int hashCode() {
            return this.app_ == null ? 0 : this.app_.getId().hashCode();
        }
    }
}

