/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.votech.plastic.PlasticHubListener;
import uk.ac.starlink.plastic.ApplicationItem;
import uk.ac.starlink.plastic.ApplicationListModel;
import uk.ac.starlink.plastic.MessageDefinition;
import uk.ac.starlink.plastic.MessageId;
import uk.ac.starlink.plastic.MessageValidator;
import uk.ac.starlink.plastic.PlasticApplication;
import uk.ac.starlink.plastic.PlasticListWindow;
import uk.ac.starlink.plastic.PlasticUtils;

public class PlasticMonitor
implements PlasticApplication {
    private final String name_;
    private final boolean multiclient_;
    private final PrintStream logOut_;
    private final PrintStream warnOut_;
    private boolean stopped_;
    private ApplicationListModel appListModel_;
    private PlasticHubListener hub_;
    private final MessageValidator validator_;
    private static final Logger logger_;
    private static int MAX_ARG_COUNT;
    private static int MAX_ARG_LENG;
    private static int TRUNC_ARG_LENG;
    private static final Object NULL;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PlasticMonitor(String name, boolean multiclient, PrintStream logOut, PrintStream warnOut) {
        this.name_ = name;
        this.multiclient_ = multiclient;
        this.logOut_ = logOut;
        this.warnOut_ = warnOut;
        this.validator_ = new MessageValidator();
    }

    public String getName() {
        return this.name_;
    }

    public URI[] getSupportedMessages() {
        URI[] uRIArray;
        if (this.multiclient_) {
            uRIArray = MessageId.getKnownMessages();
        } else {
            URI[] uRIArray2 = new URI[8];
            uRIArray2[0] = MessageId.HUB_APPREG;
            uRIArray2[1] = MessageId.HUB_APPUNREG;
            uRIArray2[2] = MessageId.HUB_STOPPING;
            uRIArray2[3] = MessageId.INFO_GETNAME;
            uRIArray2[4] = MessageId.INFO_GETDESCRIPTION;
            uRIArray2[5] = MessageId.INFO_GETICONURL;
            uRIArray2[6] = MessageId.INFO_GETVERSION;
            uRIArray = uRIArray2;
            uRIArray2[7] = MessageId.TEST_ECHO;
        }
        return uRIArray;
    }

    public Object perform(URI sender, URI message, List args) {
        String[] warnings;
        String[] warnings2;
        if (this.logOut_ != null) {
            String summary = PlasticMonitor.stringify(sender) + ": " + PlasticMonitor.stringify(message) + PlasticMonitor.stringify(args);
            this.logOut_.println(summary);
        }
        if (this.warnOut_ != null && (warnings2 = this.validator_.validateRequest(sender, message, args)).length > 0) {
            this.warnOut_.println("WARNINGS: ");
            for (int i = 0; i < warnings2.length; ++i) {
                this.warnOut_.println("    " + warnings2[i]);
            }
        }
        Object result = this.doPerform(sender, message, args);
        if (this.logOut_ != null) {
            this.logOut_.println("\t->" + (result == null ? "null" : "(" + result.getClass().getName() + "): " + result));
        }
        if (this.warnOut_ != null && (warnings = this.validator_.validateResponse(message, result)).length > 0) {
            this.warnOut_.println("WARNINGS: ");
            for (int i = 0; i < warnings.length; ++i) {
                this.warnOut_.println("    " + warnings[i]);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doPerform(URI sender, URI message, List args) {
        MessageDefinition def;
        if (MessageId.HUB_STOPPING.equals(message)) {
            this.stopped_ = true;
            if (this.appListModel_ != null) {
                this.appListModel_.clear();
            }
            PlasticMonitor plasticMonitor = this;
            synchronized (plasticMonitor) {
                this.notifyAll();
            }
            return NULL;
        }
        if (MessageId.INFO_GETNAME.equals(message)) {
            return this.name_;
        }
        if (MessageId.INFO_GETDESCRIPTION.equals(message)) {
            return "Plastic message monitor";
        }
        if (MessageId.INFO_GETICONURL.equals(message)) {
            return "http://www.star.bris.ac.uk/~mbt/plastic/images/eye.gif";
        }
        if (MessageId.INFO_GETVERSION.equals(message)) {
            return "0.4";
        }
        if (MessageId.TEST_ECHO.equals(message)) {
            return args.size() > 0 ? args.get(0) : "";
        }
        if (MessageId.HUB_APPREG.equals(message)) {
            if (this.appListModel_ != null && args.size() > 0) {
                try {
                    URI id = new URI(args.get(0).toString());
                    String name = this.hub_.getName(id);
                    List msgs = this.hub_.getUnderstoodMessages(id);
                    if (id != null && name != null && msgs != null) {
                        this.appListModel_.register(id, name, msgs);
                    }
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
            }
            return NULL;
        }
        if (MessageId.HUB_APPUNREG.equals(message)) {
            if (this.appListModel_ != null && args.size() > 0) {
                try {
                    URI id = new URI(args.get(0).toString());
                    this.appListModel_.unregister(id);
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
            }
            return NULL;
        }
        if (this.multiclient_ && (def = MessageDefinition.getMessage(message)) != null) {
            return def.getReturnType().getBlankValue();
        }
        if (this.warnOut_ != null) {
            this.warnOut_.println("Unsolicited message " + message);
        }
        return NULL;
    }

    public void setHub(PlasticHubListener hub) {
        this.hub_ = hub;
    }

    public void setListModel(ApplicationListModel listModel) {
        this.appListModel_ = listModel;
    }

    public static String stringify(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof URI) {
            return value.toString();
        }
        if (value instanceof Collection) {
            Collection set = (Collection)value;
            StringBuffer sbuf = new StringBuffer();
            sbuf.append('(');
            if (!set.isEmpty()) {
                int iel = 0;
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    sbuf.append(' ');
                    if (++iel > MAX_ARG_COUNT) {
                        sbuf.append("...");
                        break;
                    }
                    sbuf.append(PlasticMonitor.stringify(it.next()));
                    sbuf.append(it.hasNext() ? (char)',' : ' ');
                }
            }
            sbuf.append(')');
            return sbuf.toString();
        }
        String s = value == null ? "null" : value.toString();
        s = s.length() < MAX_ARG_LENG ? s : s.substring(0, TRUNC_ARG_LENG - 3) + "...";
        s = s.replaceAll("\n", "\\n");
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Object hub;
        String usage = "\nUsage:\n       " + PlasticMonitor.class.getName() + "\n           " + " [-xmlrpc|-rmi]" + " [-gui]" + " [-verbose]" + " [-warn]" + " [-multi]" + " [-name name]" + "\n";
        ArrayList<String> argv = new ArrayList<String>(Arrays.asList(args));
        String mode = "rmi";
        boolean gui = false;
        boolean verbose = false;
        boolean validate = false;
        boolean multiclient = false;
        String name = "monitor";
        Iterator it = argv.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if ("-xmlrpc".equals(arg)) {
                it.remove();
                mode = "xmlrpc";
                continue;
            }
            if ("-rmi".equals(arg)) {
                it.remove();
                mode = "rmi";
                continue;
            }
            if ("-gui".equals(arg)) {
                it.remove();
                gui = true;
                continue;
            }
            if ("-verbose".equals(arg)) {
                it.remove();
                verbose = true;
                continue;
            }
            if ("-warn".equals(arg)) {
                it.remove();
                validate = true;
                continue;
            }
            if ("-multi".equals(arg)) {
                it.remove();
                multiclient = true;
                continue;
            }
            if ("-name".equals(arg) && it.hasNext()) {
                it.remove();
                name = (String)it.next();
                it.remove();
                continue;
            }
            if (!arg.startsWith("-h")) continue;
            System.out.println(usage);
            return;
        }
        if (!argv.isEmpty()) {
            System.err.println(usage);
            System.exit(1);
        }
        PrintStream logOut = verbose ? System.out : null;
        PrintStream warnOut = validate ? System.out : null;
        PlasticMonitor mon = new PlasticMonitor(name, multiclient, logOut, warnOut);
        if (gui) {
            hub = PlasticUtils.getLocalHub();
            ApplicationItem[] regApps = PlasticUtils.getRegisteredApplications((PlasticHubListener)hub);
            ApplicationListModel appsList = new ApplicationListModel(regApps);
            mon.setListModel(appsList);
            mon.setHub((PlasticHubListener)hub);
            PlasticListWindow window = new PlasticListWindow(appsList);
            window.setTitle("PlasticMonitor");
            window.pack();
            window.setDefaultCloseOperation(3);
            window.setVisible(true);
        }
        if (logOut != null) {
            logOut.println("Connnecting in " + mode + " mode...");
        }
        if ("rmi".equals(mode)) {
            PlasticUtils.registerRMI(mon);
        } else if ("xmlrpc".equals(mode)) {
            PlasticUtils.registerXMLRPC(mon);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        if (logOut != null) {
            logOut.println("...connected.");
        }
        try {
            hub = mon;
            synchronized (hub) {
                while (!mon.stopped_) {
                    mon.wait();
                }
            }
            if (logOut != null) {
                logOut.println("Hub stopped.");
            }
            System.exit(0);
        }
        catch (InterruptedException e) {
            System.out.println("Interrupted.");
        }
    }

    static {
        $assertionsDisabled = !PlasticMonitor.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.plastic");
        MAX_ARG_COUNT = 64;
        MAX_ARG_LENG = 256;
        TRUNC_ARG_LENG = Math.min(64, MAX_ARG_LENG - 3);
        NULL = new Vector();
    }
}

