/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import uk.ac.starlink.plastic.MinimalHub;

abstract class Agent {
    private final URI id_;
    private final String name_;
    private final String label_;
    private final Collection supportedMessages_;

    public Agent(int iseq, String name, URI[] supportedMessages) {
        this.id_ = MinimalHub.createId(this, name, iseq);
        this.name_ = name;
        this.supportedMessages_ = new HashSet<URI>(Arrays.asList(supportedMessages));
        this.label_ = name + "-" + iseq;
    }

    public URI getId() {
        return this.id_;
    }

    public String getName() {
        return this.name_;
    }

    public abstract String getConnection();

    public boolean supportsMessage(URI msg) {
        return this.supportedMessages_.isEmpty() || this.supportedMessages_.contains(msg);
    }

    public URI[] getSupportedMessages() {
        ArrayList msgs = new ArrayList(this.supportedMessages_);
        Collections.sort(msgs);
        return msgs.toArray(new URI[0]);
    }

    public abstract Object request(URI var1, URI var2, List var3) throws IOException;

    public String toString() {
        return this.label_;
    }
}

