/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutput;
import java.io.IOException;
import uk.ac.starlink.fits.AbstractFitsTableWriter;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.VariableFitsTableSerializer;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;

public class VariableFitsTableWriter
extends AbstractFitsTableWriter {
    private final Boolean longIndexing_;
    private final boolean allowSignedByte_;
    private StoragePolicy storagePolicy_;

    public VariableFitsTableWriter() {
        this(null, true);
    }

    public VariableFitsTableWriter(boolean longIndexing, boolean allowSignedByte) {
        this((Boolean)longIndexing, allowSignedByte);
    }

    private VariableFitsTableWriter(Boolean longIndexing, boolean allowSignedByte) {
        super("fits-var");
        this.longIndexing_ = longIndexing;
        this.allowSignedByte_ = allowSignedByte;
        this.storagePolicy_ = StoragePolicy.getDefaultPolicy();
    }

    public void setStoragePolicy(StoragePolicy storagePolicy) {
        this.storagePolicy_ = storagePolicy;
    }

    public boolean looksLikeFile(String location) {
        return false;
    }

    public void writePrimaryHDU(StarTable startab, FitsTableSerializer fitser, DataOutput out) throws IOException {
        FitsConstants.writeEmptyPrimary(out);
    }

    protected FitsTableSerializer createSerializer(StarTable table) throws IOException {
        VariableFitsTableSerializer fitser = new VariableFitsTableSerializer(table, this.storagePolicy_, this.allowSignedByte_);
        if (this.longIndexing_ != null) {
            fitser.set64BitMode(this.longIndexing_);
        }
        return fitser;
    }
}

