/*
 * Decompiled with CFR 0.152.
 */
package alma.Control.LOSolutions;

import alma.Control.DSBbasebandSpec;
import alma.Control.LOSolutions.FreqBBindex;
import alma.Control.LOSolutions.SSBbasebandInfo;
import alma.Control.LOSolutions.SidebandSelect;
import alma.Control.SSBbasebandSpec;
import java.util.ArrayList;
import java.util.List;

class BasebandInfo {
    SSBbasebandInfo upper = null;
    SSBbasebandInfo lower = null;
    List<SSBbasebandInfo> sb = new ArrayList<SSBbasebandInfo>();
    SidebandSelect sbSelect;
    boolean isUsed = false;
    int index;

    static List<BasebandInfo> toBasebandInfoSSB(List<SSBbasebandSpec> bbSpec) throws Exception {
        int bbIndex = 0;
        ArrayList<BasebandInfo> bbInfo = new ArrayList<BasebandInfo>();
        for (SSBbasebandSpec b : bbSpec) {
            BasebandInfo thisBB = new BasebandInfo(b, bbIndex++);
            if (!thisBB.isUsed) continue;
            bbInfo.add(thisBB);
        }
        if (bbInfo.isEmpty()) {
            throw new Exception("Must have at least one valid base-band.");
        }
        return bbInfo;
    }

    static List<BasebandInfo> toBasebandInfoDSB(List<DSBbasebandSpec> bbSpec) throws Exception {
        int bbIndex = 0;
        ArrayList<BasebandInfo> bbInfo = new ArrayList<BasebandInfo>();
        for (DSBbasebandSpec b : bbSpec) {
            BasebandInfo thisBB = new BasebandInfo(b, bbIndex++);
            if (!thisBB.isUsed) continue;
            bbInfo.add(thisBB);
        }
        if (bbInfo.isEmpty()) {
            throw new Exception("Must have at least one valid base-band.");
        }
        return bbInfo;
    }

    BasebandInfo(SSBbasebandSpec basebandSpec, int index) {
        this.upper = new SSBbasebandInfo(basebandSpec);
        this.upper.sbSelect = SidebandSelect.Upper;
        this.upper.bbIndex = index;
        this.lower = new SSBbasebandInfo(basebandSpec);
        this.lower.sbSelect = SidebandSelect.Lower;
        this.lower.bbIndex = index;
        this.sbSelect = SidebandSelect.sidebandSelect(basebandSpec.sidebandPref);
        this.index = index;
        switch (this.sbSelect) {
            case Upper: {
                this.removeLSB();
                break;
            }
            case Lower: {
                this.removeUSB();
                break;
            }
            default: {
                this.reconstruct();
            }
        }
    }

    BasebandInfo(DSBbasebandSpec basebandSpec, int index) {
        this.upper = new SSBbasebandInfo(basebandSpec.USB);
        this.upper.sbSelect = SidebandSelect.Upper;
        this.upper.bbIndex = index;
        this.lower = new SSBbasebandInfo(basebandSpec.LSB);
        this.lower.sbSelect = SidebandSelect.Lower;
        this.lower.bbIndex = index;
        this.index = index;
        this.reconstruct();
    }

    BasebandInfo(SSBbasebandInfo ssbBaseband) {
        this.index = ssbBaseband.bbIndex;
        if (ssbBaseband.sbSelect == SidebandSelect.Upper) {
            this.upper = new SSBbasebandInfo(ssbBaseband);
        } else {
            this.lower = new SSBbasebandInfo(ssbBaseband);
        }
        this.reconstruct();
    }

    BasebandInfo(int index) {
        this.upper = new SSBbasebandInfo();
        this.upper.sbSelect = SidebandSelect.Upper;
        this.upper.bbIndex = index;
        this.lower = new SSBbasebandInfo();
        this.lower.sbSelect = SidebandSelect.Lower;
        this.lower.bbIndex = index;
        this.index = index;
        this.reconstruct();
    }

    void removeUSB() {
        this.upper = null;
        this.reconstruct();
    }

    void removeLSB() {
        this.lower = null;
        this.reconstruct();
    }

    boolean isDSB() {
        return this.sbSelect == SidebandSelect.Both;
    }

    double weight() {
        if (this.isDSB()) {
            return this.upper.weight + this.lower.weight;
        }
        return this.sb.get((int)0).weight;
    }

    static boolean isOnlySSB(List<BasebandInfo> bbinfo) {
        for (BasebandInfo bb : bbinfo) {
            if (!bb.isUsed || bb.sbSelect != SidebandSelect.Both) continue;
            return false;
        }
        return true;
    }

    void reconstruct() {
        this.isUsed = false;
        this.sb.clear();
        int nSidebands = 0;
        if (this.upper != null && this.upper.isUsed()) {
            this.sbSelect = SidebandSelect.Upper;
            ++nSidebands;
            this.sb.add(this.upper);
            this.isUsed = true;
        } else {
            this.upper = null;
        }
        if (this.lower != null && this.lower.isUsed()) {
            this.sbSelect = SidebandSelect.Lower;
            ++nSidebands;
            this.sb.add(this.lower);
            this.isUsed = true;
        } else {
            this.lower = null;
        }
        if (nSidebands == 2) {
            this.sbSelect = Math.abs(this.upper.skyFreqHz - this.lower.skyFreqHz) < 1000000.0 ? SidebandSelect.Either : SidebandSelect.Both;
        }
    }

    static List<Double> freqVec(List<BasebandInfo> bbinfo) {
        ArrayList<Double> rtn = new ArrayList<Double>();
        for (BasebandInfo b : bbinfo) {
            if (b == null) continue;
            if (SidebandSelect.numSidebandFreqs(b.sbSelect) == 1) {
                rtn.add(b.sb.get((int)0).skyFreqHz);
                continue;
            }
            for (SSBbasebandInfo s : b.sb) {
                rtn.add(s.skyFreqHz);
            }
        }
        return rtn;
    }

    static BasebandInfo basebandWithIndex(List<BasebandInfo> bbinfo, int index) {
        for (BasebandInfo b : bbinfo) {
            if (b.index != index) continue;
            return b;
        }
        return null;
    }

    static List<SSBbasebandInfo> sidebandVec(List<BasebandInfo> bbinfo) {
        ArrayList<SSBbasebandInfo> rtn = new ArrayList<SSBbasebandInfo>();
        for (BasebandInfo b : bbinfo) {
            if (b == null || !b.isUsed) continue;
            for (SSBbasebandInfo s : b.sb) {
                if (s == null) continue;
                rtn.add(s);
            }
        }
        return rtn;
    }

    static List<SSBbasebandInfo> asSidebands(List<BasebandInfo> bbi) {
        ArrayList<SSBbasebandInfo> rtn = new ArrayList<SSBbasebandInfo>();
        for (BasebandInfo b : bbi) {
            if (b == null || !b.isUsed) continue;
            if (b.sbSelect == SidebandSelect.Either) {
                if (b.upper != null) {
                    rtn.add(b.upper);
                    continue;
                }
                if (b.lower == null) continue;
                rtn.add(b.lower);
                continue;
            }
            if (b.sbSelect == SidebandSelect.Upper) {
                if (b.upper == null) continue;
                rtn.add(b.upper);
                continue;
            }
            if (b.sbSelect == SidebandSelect.Lower) {
                if (b.lower == null) continue;
                rtn.add(b.lower);
                continue;
            }
            if (b.sbSelect != SidebandSelect.Both) continue;
            if (b.upper != null) {
                rtn.add(b.upper);
            }
            if (b.lower == null) continue;
            rtn.add(b.lower);
        }
        return rtn;
    }

    static List<BasebandInfo> dsbBasebandVec(List<BasebandInfo> bbinfo) {
        ArrayList<BasebandInfo> dsbBB = new ArrayList<BasebandInfo>();
        for (BasebandInfo bb : bbinfo) {
            if (bb == null || !bb.isUsed || bb.sbSelect != SidebandSelect.Both) continue;
            dsbBB.add(bb);
        }
        return dsbBB;
    }

    static List<SSBbasebandInfo> ssbBasebandVec(List<BasebandInfo> bbinfo, SidebandSelect sbSel) throws Exception {
        if (sbSel == SidebandSelect.Either) {
            throw new Exception("Cannot request sideband Either for ssbBasebandVec()");
        }
        ArrayList<SSBbasebandInfo> ssbBB = new ArrayList<SSBbasebandInfo>();
        for (BasebandInfo bb : bbinfo) {
            boolean isNotDSB;
            boolean bl = isNotDSB = bb.sbSelect != SidebandSelect.Both;
            if (bb == null || !bb.isUsed || !isNotDSB) continue;
            for (SSBbasebandInfo s : bb.sb) {
                if (s == null || sbSel != SidebandSelect.Both && s.sbSelect != sbSel) continue;
                ssbBB.add(s);
            }
        }
        return ssbBB;
    }

    static List<BasebandInfo> basebandVec(List<BasebandInfo> bbinfo, SidebandSelect sbSel) throws Exception {
        if (sbSel == SidebandSelect.Either) {
            throw new Exception("Cannot request sideband Either for basebandVec()");
        }
        ArrayList<BasebandInfo> selbb = new ArrayList<BasebandInfo>();
        if (sbSel == SidebandSelect.Both) {
            for (BasebandInfo bb : bbinfo) {
                if (bb == null || !bb.isUsed) continue;
                selbb.add(bb);
            }
            return selbb;
        }
        List<SSBbasebandInfo> ssbBB = BasebandInfo.ssbBasebandVec(bbinfo, sbSel);
        for (SSBbasebandInfo sb : ssbBB) {
            selbb.add(new BasebandInfo(sb));
        }
        return selbb;
    }

    static List<SSBbasebandInfo> sidebandVec(List<BasebandInfo> bbinfo, SidebandSelect lo1sb) {
        ArrayList<SSBbasebandInfo> rtn = new ArrayList<SSBbasebandInfo>();
        for (BasebandInfo b : bbinfo) {
            if (b == null || !b.isUsed) continue;
            for (SSBbasebandInfo s : b.sb) {
                if (s == null) continue;
                boolean match = true;
                match = lo1sb == SidebandSelect.Upper || lo1sb == SidebandSelect.Lower ? lo1sb == s.sbSelect : true;
                if (!match) continue;
                rtn.add(s);
            }
        }
        return rtn;
    }

    static List<FreqBBindex> freqBBindexVec(List<BasebandInfo> bbinfo) {
        ArrayList<FreqBBindex> rtn = new ArrayList<FreqBBindex>();
        for (BasebandInfo b : bbinfo) {
            if (b == null) continue;
            if (SidebandSelect.numSidebandFreqs(b.sbSelect) == 1) {
                SSBbasebandInfo s = b.sb.get(0);
                rtn.add(new FreqBBindex(s.skyFreqHz, b.index));
                continue;
            }
            for (SSBbasebandInfo s : b.sb) {
                rtn.add(new FreqBBindex(s.skyFreqHz, b.index));
            }
        }
        return rtn;
    }
}

