/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.client;

import alma.cdbErrType.CDBFieldDoesNotExistEx;
import alma.cdbErrType.WrongCDBDataTypeEx;
import com.cosylab.CDB.DAOOperations;
import com.cosylab.cdb.client.DAOProxyConnectionListener;
import java.util.Iterator;
import java.util.LinkedList;

public class DAOProxy
implements DAOOperations {
    protected String curl = null;
    protected DAOOperations dao = null;
    protected LinkedList listeners = new LinkedList();
    private String elementName = null;

    public DAOProxy(String curl, DAOOperations dao) {
        assert (curl != null);
        this.curl = curl;
        this.dao = dao;
    }

    public DAOProxy(String curl) {
        assert (curl != null);
        this.curl = curl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(DAOOperations dao) {
        if (dao == null) {
            this.destroy();
        } else {
            this.dao = dao;
            LinkedList linkedList = this.listeners;
            synchronized (linkedList) {
                Iterator iter = this.listeners.iterator();
                while (iter.hasNext()) {
                    try {
                        ((DAOProxyConnectionListener)iter.next()).connected(this);
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                    }
                }
            }
        }
    }

    public String getCURL() {
        return this.curl;
    }

    public DAOOperations getDAO() {
        return this.dao;
    }

    public double[] get_double_seq(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.dao.get_double_seq(propertyName);
    }

    public double get_double(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.dao.get_double(propertyName);
    }

    public String get_field_data(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.dao.get_field_data(propertyName);
    }

    public int[] get_long_seq(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.dao.get_long_seq(propertyName);
    }

    public int get_long(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.dao.get_long(propertyName);
    }

    public String[] get_string_seq(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.dao.get_string_seq(propertyName);
    }

    public String get_string(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.dao.get_string(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.dao.destroy();
        this.dao = null;
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                try {
                    ((DAOProxyConnectionListener)iter.next()).disconnected(this);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(DAOProxyConnectionListener listener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(DAOProxyConnectionListener listener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(listener);
        }
    }

    public String toString() {
        return "Proxy of " + this.curl;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }
}

