/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb;

import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.swing.tree.DefaultMutableTreeNode;

public class CDBTreeNode
extends DefaultMutableTreeNode {
    private boolean areChildrenDefined = false;
    private String name;
    private Context parent = null;
    private Context context = null;

    public CDBTreeNode(String name, Context parent, Context context) {
        this.name = name;
        this.parent = parent;
        this.context = context;
    }

    @Override
    public boolean isLeaf() {
        return this.context == null && this.parent == null;
    }

    @Override
    public int getChildCount() {
        if (!this.areChildrenDefined) {
            this.areChildrenDefined = true;
            try {
                if (this.context == null) {
                    this.context = (Context)this.parent.lookup(this.name);
                }
                NamingEnumeration<NameClassPair> names = this.context.list("");
                while (names.hasMore()) {
                    NameClassPair pair = names.next();
                    if (pair.getClassName().equals(Context.class.getName())) {
                        this.add(new CDBTreeNode(pair.getName(), this.context, null));
                        continue;
                    }
                    this.add(new CDBTreeNode(pair.getName(), null, null));
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return super.getChildCount();
    }

    public String getValue() {
        if (!this.isLeaf()) {
            return null;
        }
        CDBTreeNode parent = (CDBTreeNode)this.getParent();
        String retVal = null;
        try {
            retVal = (String)parent.context.lookup(this.name);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

