/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.ClientLogManager;
import alma.acs.util.ACSPorts;
import alma.cdbErrType.CDBXMLErrorEx;
import alma.cdbErrType.wrappers.AcsJCDBXMLErrorEx;
import com.cosylab.CDB.WDAL;
import com.cosylab.CDB.WDALHelper;
import com.cosylab.CDB.WDAO;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class CDBChangeDeployment {
    static int indent = 0;
    private static Logger m_logger;

    public static void main(String[] args) {
        try {
            if (args.length != 3) {
                System.out.println("Usage: cmd instance_name newcontainer newcode");
                return;
            }
            m_logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("CDBChangeDeployment", true);
            String in_name = args[0];
            String new_container = args[1];
            String new_code = args[2];
            String curl = "MACI/Components";
            String strIOR = "corbaloc::" + InetAddress.getLocalHost().getHostName() + ":" + ACSPorts.getCDBPort() + "/CDB";
            ORB orb = ORB.init((String[])args, null);
            WDAL wdal = WDALHelper.narrow((Object)orb.string_to_object(strIOR));
            try {
                WDAO wdao = wdal.get_WDAO_Servant(curl);
                wdao.set_string(in_name + "/Container", new_container);
                wdao.set_string(in_name + "/Code", new_code);
            }
            catch (Exception e) {
                WDAO wdao = wdal.get_WDAO_Servant(curl + "/" + in_name);
                wdao.set_string("Container", new_container);
                wdao.set_string("Code", new_code);
            }
        }
        catch (CDBXMLErrorEx e) {
            AcsJCDBXMLErrorEx je = AcsJCDBXMLErrorEx.fromCDBXMLErrorEx((CDBXMLErrorEx)e);
            m_logger.log((Level)AcsLogLevel.NOTICE, "CDBXMLErrorEx Error", e);
            je.log(m_logger);
            e.printStackTrace(System.out);
        }
        catch (Exception e) {
            m_logger.log((Level)AcsLogLevel.NOTICE, "Error", e);
            e.printStackTrace(System.out);
        }
    }
}

