/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.cdb.rest;

import alma.acs.cdb.rest.model.CDBEntry;
import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.ClientLogManager;
import alma.acs.util.ACSPorts;
import alma.cdbErrType.CDBExceptionEx;
import alma.cdbErrType.CDBFieldDoesNotExistEx;
import alma.cdbErrType.CDBFieldIsReadOnlyEx;
import alma.cdbErrType.CDBRecordAlreadyExistsEx;
import alma.cdbErrType.CDBRecordDoesNotExistEx;
import alma.cdbErrType.CDBRecordIsReadOnlyEx;
import alma.cdbErrType.CDBXMLErrorEx;
import alma.cdbErrType.wrappers.AcsJCDBRecordAlreadyExistsEx;
import alma.cdbErrType.wrappers.AcsJCDBRecordDoesNotExistEx;
import alma.cdbErrType.wrappers.AcsJCDBRecordIsReadOnlyEx;
import alma.cdbErrType.wrappers.AcsJCDBXMLErrorEx;
import com.cosylab.CDB.DAL;
import com.cosylab.CDB.DALHelper;
import com.cosylab.CDB.JDAL;
import com.cosylab.CDB.JDALHelper;
import com.cosylab.CDB.WDAL;
import com.cosylab.CDB.WDALHelper;
import com.cosylab.CDB.WDAO;
import com.cosylab.cdb.jdal.XMLHandler;
import com.cosylab.cdb.jdal.XMLTreeNode;
import java.io.StringReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class CDBConnector {
    private static Logger m_logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("CDBConnector", false);

    private static HashMap<String, java.lang.Object> xmlToMap(XMLTreeNode node) {
        Iterator<String> nodesIter;
        HashMap<String, java.lang.Object> nodeMap = new HashMap<String, java.lang.Object>();
        Iterator<String> iterator = node.getFieldMap().keySet().iterator();
        if (iterator.hasNext()) {
            nodeMap.put("Node", node.getName());
            while (iterator.hasNext()) {
                String key = iterator.next();
                String value = node.getFieldMap().get(key);
                nodeMap.put(key, value);
            }
        }
        if ((nodesIter = node.getNodesMap().keySet().iterator()).hasNext()) {
            ArrayList<HashMap<String, java.lang.Object>> subNodesMap = new ArrayList<HashMap<String, java.lang.Object>>();
            while (nodesIter.hasNext()) {
                String key = nodesIter.next();
                XMLTreeNode value = node.getNodesMap().get(key);
                subNodesMap.add(CDBConnector.xmlToMap(value));
            }
            nodeMap.put("subnodes", subNodesMap);
        }
        return nodeMap;
    }

    private static String cdbEntryToXml(CDBEntry cdbEntry) {
        String node;
        if (cdbEntry.node == "") {
            String[] curlArray = cdbEntry.curl.split("/");
            node = curlArray[curlArray.length - 1];
        } else {
            node = cdbEntry.node;
        }
        java.lang.Object properties = "";
        for (Map.Entry<String, String> set : cdbEntry.properties.entrySet()) {
            String field = set.getKey();
            String value = set.getValue();
            properties = (String)properties + " " + field + "=\"" + value + "\"";
        }
        java.lang.Object subnodes = "";
        if (cdbEntry.hasSubnodes()) {
            for (int i = 0; i < cdbEntry.subnodes.length; ++i) {
                subnodes = (String)subnodes + CDBConnector.cdbEntryToXml(cdbEntry.subnodes[i]);
            }
        }
        String xmlCdbEntry = "<" + node + (String)properties + ">" + (String)subnodes + "</" + node + ">";
        return xmlCdbEntry;
    }

    public static HashMap<String, java.lang.Object> readCurlInCDB(String curl, String strIOR) {
        try {
            if (strIOR == null) {
                strIOR = "corbaloc::" + InetAddress.getLocalHost().getHostName() + ":" + ACSPorts.getCDBPort() + "/CDB";
            }
            ORB orb = ORB.init((String[])new String[0], null);
            DAL dal = DALHelper.narrow((Object)orb.string_to_object((String)strIOR));
            String xml = dal.get_DAO(curl);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLHandler xmlSolver = new XMLHandler(false, m_logger);
            saxParser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)xmlSolver);
            if (xmlSolver.m_errorString != null) {
                m_logger.log((Level)AcsLogLevel.ERROR, "XML parser error: " + xmlSolver.m_errorString);
                CDBXMLErrorEx xmlErr = new CDBXMLErrorEx();
                throw xmlErr;
            }
            m_logger.log((Level)AcsLogLevel.INFO, "Query to CDB was successful, formatting JSON equivalent to " + curl);
            HashMap<String, java.lang.Object> resultQuery = CDBConnector.xmlToMap(xmlSolver.m_rootNode);
            return resultQuery;
        }
        catch (CDBXMLErrorEx e) {
            AcsJCDBXMLErrorEx je = AcsJCDBXMLErrorEx.fromCDBXMLErrorEx((CDBXMLErrorEx)e);
            String smsg = "XML Error \tCURL='" + je.getCurl() + "'\n\t\tFilename='" + je.getFilename() + "'\n\t\tNodename='" + je.getNodename() + "'\n\t\tMSG='" + je.getErrorString() + "'";
            smsg = smsg + "\n CDBXMLErrorEx: " + e.getMessage();
            m_logger.log((Level)AcsLogLevel.NOTICE, smsg, je);
            return new HashMap<String, java.lang.Object>();
        }
        catch (CDBRecordDoesNotExistEx e) {
            AcsJCDBRecordDoesNotExistEx je = AcsJCDBRecordDoesNotExistEx.fromCDBRecordDoesNotExistEx((CDBRecordDoesNotExistEx)e);
            String smsg = "Record does not exist \tCURL='" + je.getCurl() + "'";
            m_logger.log((Level)AcsLogLevel.NOTICE, smsg, je);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap<String, String> writeCDBEntry(CDBEntry cdbEntry, String strIOR) {
        HashMap<String, String> writeResult = new HashMap<String, String>();
        if (cdbEntry.properties.isEmpty()) {
            m_logger.log((Level)AcsLogLevel.ERROR, "CDB entry has no properties to change. Returning");
            writeResult.put("error", "No properties in given CDB entry");
            return writeResult;
        }
        String curl = cdbEntry.curl;
        if (curl == null || curl == "") {
            m_logger.log((Level)AcsLogLevel.ERROR, "CDB entry has no given CURL. Returning");
            writeResult.put("error", "CURL is empty");
            return writeResult;
        }
        try {
            ORB orb = ORB.init((String[])new String[0], null);
            WDAL wdal = WDALHelper.narrow((Object)orb.string_to_object(strIOR));
            WDAO wdao = wdal.get_WDAO_Servant(curl);
            for (Map.Entry<String, String> set : cdbEntry.properties.entrySet()) {
                String field = set.getKey();
                String value = set.getValue();
                try {
                    wdao.set_string(field, value);
                    writeResult.put(field, "success");
                }
                catch (CDBFieldDoesNotExistEx e) {
                    writeResult.put(field, "ERROR: Field does not exist");
                }
                catch (CDBFieldIsReadOnlyEx e) {
                    writeResult.put(field, "ERROR: Field is read only");
                }
            }
            CDBConnector.clearCache(strIOR, orb);
            writeResult.put("INFO", "write");
            m_logger.log((Level)AcsLogLevel.INFO, "Write to " + cdbEntry.curl + " finished");
            return writeResult;
        }
        catch (CDBRecordDoesNotExistEx e) {
            m_logger.log((Level)AcsLogLevel.INFO, "Record for curl " + cdbEntry.curl + "does not exist. Adding new entry");
            writeResult.clear();
            boolean added = CDBConnector.writeNewCDBEntry(cdbEntry, strIOR);
            if (added) {
                writeResult.put("message", "New CDB entry added");
            } else {
                writeResult.put("error", "New CDB entry could not be added");
            }
            writeResult.put("INFO", "add");
            m_logger.log((Level)AcsLogLevel.INFO, "New CDB entry " + cdbEntry.curl + " added");
            return writeResult;
        }
        catch (CDBRecordIsReadOnlyEx e) {
            AcsJCDBRecordIsReadOnlyEx je = AcsJCDBRecordIsReadOnlyEx.fromCDBRecordIsReadOnlyEx((CDBRecordIsReadOnlyEx)e);
            String smsg = "Record is read only \tCURL='" + je.getCurl() + "'";
            m_logger.log((Level)AcsLogLevel.ERROR, smsg);
            writeResult.clear();
            writeResult.put("error", "Record is read only");
            return writeResult;
        }
        catch (CDBXMLErrorEx e) {
            AcsJCDBXMLErrorEx e2 = new AcsJCDBXMLErrorEx((Throwable)e);
            System.out.println("XMLerror : " + e2.getCurl());
            e.printStackTrace(System.out);
            writeResult.put("error", "There was an XMLerror during writting process");
            return writeResult;
        }
        catch (Exception e) {
            System.out.println("ERROR : " + e);
            e.printStackTrace(System.out);
            writeResult.put("error", "internal server error");
            return writeResult;
        }
    }

    public static boolean writeNewCDBEntry(CDBEntry cdbEntry, String strIOR) {
        String xml = CDBConnector.cdbEntryToXml(cdbEntry);
        if (xml.equals("")) {
            return false;
        }
        try {
            ORB orb = ORB.init((String[])new String[0], null);
            WDAL wdal = WDALHelper.narrow((Object)orb.string_to_object(strIOR));
            wdal.add_node(cdbEntry.curl, xml);
            CDBConnector.clearCache(strIOR, orb);
            return true;
        }
        catch (CDBRecordAlreadyExistsEx e) {
            AcsJCDBRecordAlreadyExistsEx e2 = new AcsJCDBRecordAlreadyExistsEx((Throwable)e);
            System.out.println("CDBRecordAlreadyExistsError : " + e2.getCurl());
            return false;
        }
        catch (CDBXMLErrorEx e) {
            AcsJCDBXMLErrorEx e2 = new AcsJCDBXMLErrorEx((Throwable)e);
            System.out.println("XMLerror : " + e2.getCurl());
            e.printStackTrace(System.out);
            return false;
        }
        catch (CDBExceptionEx e) {
            e.printStackTrace(System.out);
            return false;
        }
        catch (Exception e) {
            System.out.println("ERROR : " + e);
            e.printStackTrace(System.out);
            return false;
        }
    }

    public static String[] listNodes(String curl, String strIOR) {
        try {
            ORB orb;
            DAL dal;
            String stringList;
            String[] list;
            if (strIOR == null) {
                strIOR = "corbaloc::" + InetAddress.getLocalHost().getHostName() + ":" + ACSPorts.getCDBPort() + "/CDB";
            }
            if ((list = (stringList = (dal = DALHelper.narrow((Object)(orb = ORB.init((String[])new String[0], null)).string_to_object((String)strIOR))).list_nodes(curl)).split(" ")).length == 0 || list.length == 1 && list[0] == "") {
                String xml = dal.get_DAO(curl);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                XMLHandler xmlSolver = new XMLHandler(false, m_logger);
                saxParser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)xmlSolver);
                if (xmlSolver.m_errorString != null) {
                    m_logger.log((Level)AcsLogLevel.ERROR, "XML parser error: " + xmlSolver.m_errorString);
                    CDBXMLErrorEx xmlErr = new CDBXMLErrorEx();
                    throw xmlErr;
                }
                m_logger.log((Level)AcsLogLevel.INFO, "Query to CDB was successful, formatting list equivalent to " + curl);
                HashMap<String, java.lang.Object> resultQuery = CDBConnector.xmlToMap(xmlSolver.m_rootNode);
                ArrayList subnodes = (ArrayList)resultQuery.get("subnodes");
                String[] listKeys = new String[subnodes.size()];
                for (int i = 0; i < subnodes.size(); ++i) {
                    listKeys[i] = ((HashMap)subnodes.get(i)).get("Node").toString();
                }
                return listKeys;
            }
            return list;
        }
        catch (Exception e) {
            m_logger.log((Level)AcsLogLevel.NOTICE, "ERROR : " + e);
            e.printStackTrace(System.out);
            return null;
        }
    }

    public static HashMap<String, String> deleteNode(String curl, String strIOR) {
        HashMap<String, String> returnValue = new HashMap<String, String>();
        returnValue.put("curl", curl);
        try {
            if (strIOR == null) {
                strIOR = "corbaloc::" + InetAddress.getLocalHost().getHostName() + ":" + ACSPorts.getCDBPort() + "/CDB";
            }
            ORB orb = ORB.init((String[])new String[0], null);
            WDAL wdal = WDALHelper.narrow((Object)orb.string_to_object((String)strIOR));
            wdal.remove_node(curl);
            CDBConnector.clearCache((String)strIOR, orb);
            returnValue.put("success", "CDB entry deleted");
            return returnValue;
        }
        catch (CDBRecordDoesNotExistEx e) {
            AcsJCDBRecordDoesNotExistEx je = AcsJCDBRecordDoesNotExistEx.fromCDBRecordDoesNotExistEx((CDBRecordDoesNotExistEx)e);
            String smsg = "Record does not exist \tCURL='" + je.getCurl() + "'";
            m_logger.log((Level)AcsLogLevel.NOTICE, smsg, je);
            returnValue.put("error", "Record does not exist");
            return returnValue;
        }
        catch (CDBRecordIsReadOnlyEx e) {
            AcsJCDBRecordIsReadOnlyEx je = AcsJCDBRecordIsReadOnlyEx.fromCDBRecordIsReadOnlyEx((CDBRecordIsReadOnlyEx)e);
            String smsg = "Record is read only \tCURL='" + je.getCurl() + "'";
            m_logger.log((Level)AcsLogLevel.ERROR, smsg, (Throwable)je);
            returnValue.put("error", "Record is read only");
            return returnValue;
        }
        catch (Exception e) {
            System.out.println("ERROR : " + e);
            e.printStackTrace(System.out);
            returnValue.put("error", "Internal server error");
            return returnValue;
        }
    }

    private static void clearCache(String strIOR, ORB orb) {
        JDAL dal = JDALHelper.narrow((Object)orb.string_to_object(strIOR));
        dal.clear_cache_all();
    }
}

