/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.AsciiTable;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.TableData;
import nom.tam.fits.TableHDU;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.Cursor;

public class AsciiTableHDU
extends TableHDU {
    AsciiTable data;
    private String[] keyStems = new String[]{"TFORM", "TZERO", "TNULL", "TTYPE", "TUNIT"};

    public AsciiTableHDU(Header h, Data d) {
        super((TableData)((Object)d));
        this.myHeader = h;
        this.data = (AsciiTable)d;
        this.myData = d;
    }

    public static boolean isHeader(Header header) {
        return header.getStringValue("XTENSION").trim().equals("TABLE");
    }

    public boolean isHeader() {
        return AsciiTableHDU.isHeader(this.myHeader);
    }

    public static boolean isData(Object o) {
        if (o instanceof Object[]) {
            Object[] oo = (Object[])o;
            for (int i = 0; i < oo.length; ++i) {
                if (oo[i] instanceof String[] || oo[i] instanceof int[] || oo[i] instanceof long[] || oo[i] instanceof float[] || oo[i] instanceof double[]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Data manufactureData(Header hdr) throws FitsException {
        return new AsciiTable(hdr);
    }

    public Data manufactureData() throws FitsException {
        return AsciiTableHDU.manufactureData(this.myHeader);
    }

    public static Header manufactureHeader(Data d) throws FitsException {
        Header hdr = new Header();
        d.fillHeader(hdr);
        Cursor iter = hdr.iterator();
        return hdr;
    }

    public static Data encapsulate(Object o) throws FitsException {
        Object[] oo = (Object[])o;
        AsciiTable d = new AsciiTable();
        for (int i = 0; i < oo.length; ++i) {
            d.addColumn(oo[i]);
        }
        return d;
    }

    public void readData(ArrayDataInput stream) throws FitsException {
        this.myData.read(stream);
    }

    public void setNull(int row, int col, boolean flag) {
        String nullStr;
        if (flag && (nullStr = this.myHeader.getStringValue("TNULL" + (col + 1))) == null) {
            this.setNullString(col, "NULL");
        }
        this.data.setNull(row, col, flag);
    }

    public boolean isNull(int row, int col) {
        return this.data.isNull(row, col);
    }

    public void setNullString(int col, String newNull) {
        this.myHeader.positionAfterIndex("TBCOL", col + 1);
        try {
            this.myHeader.addValue("TNULL" + (col + 1), newNull, null);
        }
        catch (HeaderCardException e) {
            System.err.println("Impossible exception in setNullString" + e);
        }
        this.data.setNullString(col, newNull);
    }

    public int addColumn(Object newCol) throws FitsException {
        this.data.addColumn(newCol);
        Cursor iter = this.myHeader.positionAfterIndex("TBCOL", this.data.getNCols());
        int rowlen = this.data.addColInfo(this.getNCols(), iter);
        int oldRowlen = this.myHeader.getIntValue("NAXIS1");
        this.myHeader.setNaxis(1, rowlen + oldRowlen);
        int oldTfields = this.myHeader.getIntValue("TFIELDS");
        try {
            this.myHeader.addValue("TFIELDS", oldTfields + 1, (String)null);
        }
        catch (Exception e) {
            System.err.println("Impossible exception at addColumn:" + e);
        }
        return this.getNCols();
    }

    public void info() {
        System.out.println("ASCII Table:");
        System.out.println("  Header:");
        System.out.println("    Number of fields:" + this.myHeader.getIntValue("TFIELDS"));
        System.out.println("    Number of rows:  " + this.myHeader.getIntValue("NAXIS2"));
        System.out.println("    Length of row:   " + this.myHeader.getIntValue("NAXIS1"));
        System.out.println("  Data:");
        Object[] data = (Object[])this.getKernel();
        for (int i = 0; i < this.getNCols(); ++i) {
            System.out.println("      " + i + ":" + ArrayFuncs.arrayDescription(data[i]));
        }
    }

    public Data getData() {
        return this.data;
    }

    public String[] columnKeyStems() {
        return this.keyStems;
    }
}

