/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.astrogrid.samp.xmlrpc.internal.XmlRpcFormatException;
import org.astrogrid.samp.xmlrpc.internal.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlRpcCall {
    private final String methodName_;
    private final List params_;

    public XmlRpcCall(String methodName, List params) {
        this.methodName_ = methodName;
        this.params_ = Collections.unmodifiableList(params);
    }

    public String getMethodName() {
        return this.methodName_;
    }

    public List getParams() {
        return this.params_;
    }

    public static XmlRpcCall createCall(Document callDoc) throws XmlRpcFormatException {
        Element callEl = XmlUtils.getChild(callDoc, "methodCall");
        String methodName = null;
        Element paramsEl = null;
        Element[] methodChildren = XmlUtils.getChildren(callEl);
        for (int i = 0; i < methodChildren.length; ++i) {
            Element el = methodChildren[i];
            String tagName = el.getTagName();
            if (tagName.equals("methodName")) {
                methodName = XmlUtils.getTextContent(el);
                continue;
            }
            if (!tagName.equals("params")) continue;
            paramsEl = el;
        }
        if (methodName == null) {
            throw new XmlRpcFormatException("No methodName element");
        }
        Element[] paramEls = paramsEl == null ? new Element[]{} : XmlUtils.getChildren(paramsEl);
        int np = paramEls.length;
        ArrayList<Object> paramList = new ArrayList<Object>(np);
        for (int i = 0; i < np; ++i) {
            Element paramEl = paramEls[i];
            if (!"param".equals(paramEl.getTagName())) {
                throw new XmlRpcFormatException("Non-param child of params");
            }
            Element valueEl = XmlUtils.getChild(paramEl, "value");
            paramList.add(XmlUtils.parseSampValue(valueEl));
        }
        return new XmlRpcCall(methodName, paramList);
    }
}

