/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.xmlrpc.internal.InternalClient;

public class RpcLoggingInternalClient
extends InternalClient {
    private final PrintStream out_;

    public RpcLoggingInternalClient(URL endpoint, PrintStream out) {
        super(endpoint);
        this.out_ = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serializeCall(String method, List paramList) throws IOException {
        String paramString = SampUtils.formatObject(paramList, 2);
        PrintStream printStream = this.out_;
        synchronized (printStream) {
            this.out_.println("CLIENT OUT:");
            this.out_.println(method);
            this.out_.println(paramString);
            this.out_.println();
        }
        return super.serializeCall(method, paramList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserializeResponse(InputStream in) throws IOException {
        Object response = super.deserializeResponse(in);
        if (!(response == null || response instanceof String && ((String)response).length() == 0 || response instanceof Map && ((Map)response).isEmpty() || response instanceof List && ((List)response).isEmpty())) {
            String responseString = SampUtils.formatObject(response, 2);
            PrintStream printStream = this.out_;
            synchronized (printStream) {
                this.out_.println("CLIENT IN:");
                this.out_.println(responseString);
                this.out_.println();
            }
        }
        return response;
    }
}

