/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.astrogrid.samp.Platform;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.web.WebHubConnection;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClient;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClientFactory;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;

public class WebClientProfile
implements ClientProfile {
    private final SampXmlRpcClientFactory xClientFactory_;
    private final Map securityMap_;
    private final URL hubEndpoint_;
    public static final int WEBSAMP_PORT = 21012;
    public static final String WEBSAMP_PATH = "/";
    public static final String WEBSAMP_HUB_PREFIX = "samp.webhub.";
    public static final String WEBSAMP_CLIENT_PREFIX = "";
    public static final String URLTRANS_KEY = "samp.url-translator";
    public static final String WEBPROFILE_HUB_PREFIX = "web-appname:";

    public WebClientProfile(Map securityMap, SampXmlRpcClientFactory xClientFactory, URL hubEndpoint) {
        this.securityMap_ = securityMap;
        this.xClientFactory_ = xClientFactory;
        this.hubEndpoint_ = hubEndpoint;
    }

    public WebClientProfile(String appName) {
        this(WebClientProfile.createSecurityMap(appName), XmlRpcKit.getInstance().getClientFactory(), WebClientProfile.getDefaultHubEndpoint());
    }

    public WebClientProfile() {
        this(WebClientProfile.getDefaultAppName());
    }

    public boolean isHubRunning() {
        try {
            SampXmlRpcClient xClient = this.xClientFactory_.createClient(this.hubEndpoint_);
            xClient.callAndWait("samp.webhub.ping", new ArrayList());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public HubConnection register() throws SampException {
        try {
            return new WebHubConnection(this.xClientFactory_.createClient(this.hubEndpoint_), this.securityMap_);
        }
        catch (SampException e) {
            for (Throwable ex = e; ex != null; ex = ex.getCause()) {
                if (!(ex instanceof ConnectException)) continue;
                return null;
            }
            throw e;
        }
        catch (ConnectException e) {
            return null;
        }
        catch (IOException e) {
            throw new SampException(e);
        }
    }

    public URL getHubEndpoint() {
        return this.hubEndpoint_;
    }

    public static URL getDefaultHubEndpoint() {
        String surl = "http://" + SampUtils.getLocalhost() + ":" + 21012 + WEBSAMP_PATH;
        try {
            return new URL(surl);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)("http scheme not supported?? " + surl));
        }
    }

    public static WebClientProfile getInstance() {
        return new WebClientProfile();
    }

    public static String getDefaultAppName() {
        String hubloc = Platform.getPlatform().getEnv("SAMP_HUB");
        return hubloc != null && hubloc.startsWith(WEBPROFILE_HUB_PREFIX) ? hubloc.substring(WEBPROFILE_HUB_PREFIX.length()) : "Unknown Application";
    }

    private static Map createSecurityMap(String appName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("samp.name", appName);
        return map;
    }
}

