/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.Map;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.web.CorsHttpServer;
import org.astrogrid.samp.web.OriginAuthorizer;

public class LoggingCorsHttpServer
extends CorsHttpServer {
    private final PrintStream out_;
    private int iSeq_;

    public LoggingCorsHttpServer(ServerSocket socket, OriginAuthorizer auth, PrintStream out) throws IOException {
        super(socket, auth);
        this.out_ = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpServer.Response serve(HttpServer.Request request) {
        int iseq;
        LoggingCorsHttpServer loggingCorsHttpServer = this;
        synchronized (loggingCorsHttpServer) {
            iseq = ++this.iSeq_;
        }
        this.logRequest(request, iseq);
        return new LoggedResponse(super.serve(request), iseq, "POST".equals(request.getMethod()));
    }

    private void logRequest(HttpServer.Request request, int iseq) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('\n');
        this.appendBanner(sbuf, '>', iseq);
        sbuf.append(request.getMethod()).append(' ').append(request.getUrl()).append('\n');
        this.appendHeaders(sbuf, request.getHeaderMap());
        byte[] body = request.getBody();
        if (body != null && body.length > 0) {
            sbuf.append('\n');
            try {
                sbuf.append(new String(request.getBody(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)"No utf-8??");
            }
        }
        this.out_.println(sbuf);
    }

    private void appendBanner(StringBuffer sbuf, char c, int iseq) {
        String label = Integer.toString(iseq);
        int nc = 75 - label.length();
        for (int i = 0; i < nc; ++i) {
            sbuf.append(c);
        }
        sbuf.append(' ').append(label).append('\n');
    }

    private void appendHeaders(StringBuffer sbuf, Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sbuf.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
    }

    private static class CountOutputStream
    extends OutputStream {
        long count_;

        private CountOutputStream() {
        }

        public void write(byte[] b) {
            this.count_ += (long)b.length;
        }

        public void write(byte[] b, int off, int len) {
            this.count_ += (long)len;
        }

        public void write(int b) {
            ++this.count_;
        }
    }

    private class LoggedResponse
    extends HttpServer.Response {
        private final HttpServer.Response base_;
        private final boolean logBody_;
        private final String headText_;
        private String bodyText_;

        LoggedResponse(HttpServer.Response base, int iseq, boolean logBody) {
            super(base.getStatusCode(), base.getStatusPhrase(), base.getHeaderMap());
            this.base_ = base;
            this.logBody_ = logBody;
            StringBuffer sbuf = new StringBuffer();
            sbuf.append('\n');
            LoggingCorsHttpServer.this.appendBanner(sbuf, '<', iseq);
            sbuf.append(this.getStatusCode()).append(' ').append(this.getStatusPhrase()).append('\n');
            LoggingCorsHttpServer.this.appendHeaders(sbuf, this.getHeaderMap());
            this.headText_ = sbuf.toString();
        }

        public void writeBody(final OutputStream out) throws IOException {
            String slog;
            final OutputStream lout = this.logBody_ ? new ByteArrayOutputStream(){

                public String toString() {
                    String txt;
                    try {
                        txt = new String(this.buf, 0, this.count, "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        txt = e.toString();
                    }
                    return "\n" + txt + "\n";
                }
            } : new CountOutputStream(){

                public String toString() {
                    return this.count_ > 0L ? "<" + this.count_ + " bytes of output omitted>\n" : "";
                }
            };
            OutputStream teeOut = new OutputStream(){

                public void write(byte[] b) throws IOException {
                    lout.write(b);
                    out.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    lout.write(b, off, len);
                    out.write(b, off, len);
                }

                public void write(int b) throws IOException {
                    lout.write(b);
                    out.write(b);
                }
            };
            try {
                this.base_.writeBody(teeOut);
                slog = lout.toString();
            }
            catch (IOException e) {
                slog = "log error? " + e + "\n";
            }
            this.bodyText_ = slog;
        }

        public void writeResponse(OutputStream out) throws IOException {
            super.writeResponse(out);
            LoggingCorsHttpServer.this.out_.print(this.headText_ + this.bodyText_);
        }
    }
}

