/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.test.TestException;

abstract class ReplyCollector
implements CallableClient {
    private final HubConnection connection_;
    private final Set sentSet_;
    private final Map replyMap_;
    private boolean allowTagReuse_;

    public ReplyCollector(HubConnection connection) {
        this.connection_ = connection;
        this.sentSet_ = Collections.synchronizedSet(new HashSet());
        this.replyMap_ = Collections.synchronizedMap(new HashMap());
    }

    public void setAllowTagReuse(boolean allow) {
        this.allowTagReuse_ = allow;
    }

    public String call(String recipientId, String msgTag, Map msg) throws SampException {
        Object key = ReplyCollector.createKey(recipientId, msgTag);
        if (!this.allowTagReuse_ && this.sentSet_.contains(key)) {
            throw new IllegalArgumentException("Key " + key + " reused");
        }
        this.sentSet_.add(key);
        return this.connection_.call(recipientId, msgTag, msg);
    }

    public Map callAll(String msgTag, Map msg) throws SampException {
        Object key = ReplyCollector.createKey(null, msgTag);
        if (!this.allowTagReuse_ && this.sentSet_.contains(key)) {
            throw new IllegalArgumentException("Key " + key + " reused");
        }
        this.sentSet_.add(key);
        return this.connection_.callAll(msgTag, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveResponse(String responderId, String msgTag, Response response) {
        Object result;
        Object key = ReplyCollector.createKey(responderId, msgTag);
        try {
            if (!this.allowTagReuse_ && this.replyMap_.containsKey(key)) {
                throw new TestException("Response for " + key + " already received");
            }
            if (!this.sentSet_.contains(key) && !this.sentSet_.contains(ReplyCollector.createKey(null, msgTag))) {
                throw new TestException("Message " + key + " never sent");
            }
            result = response;
        }
        catch (TestException e) {
            result = e;
        }
        Map map = this.replyMap_;
        synchronized (map) {
            if (!this.replyMap_.containsKey(key)) {
                this.replyMap_.put(key, new ArrayList());
            }
            ((List)this.replyMap_.get(key)).add(result);
            this.replyMap_.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReplyCount() {
        int count = 0;
        Map map = this.replyMap_;
        synchronized (map) {
            Iterator it = this.replyMap_.values().iterator();
            while (it.hasNext()) {
                count += ((List)it.next()).size();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response waitForReply(String responderId, String msgTag) {
        Object key = ReplyCollector.createKey(responderId, msgTag);
        try {
            Map map = this.replyMap_;
            synchronized (map) {
                while (!this.replyMap_.containsKey(key) || ((List)this.replyMap_.get(key)).isEmpty()) {
                    this.replyMap_.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted", e);
        }
        return this.getReply(responderId, msgTag);
    }

    public Response getReply(String responderId, String msgTag) {
        Object key = ReplyCollector.createKey(responderId, msgTag);
        Map map = this.replyMap_;
        synchronized (map) {
            Object result;
            List list = (List)this.replyMap_.get(key);
            Object v0 = result = list == null || list.isEmpty() ? null : list.remove(0);
            if (result == null) {
                return null;
            }
            if (result instanceof Response) {
                return result;
            }
            if (result instanceof Throwable) {
                throw new TestException(result);
            }
            throw new AssertionError();
        }
    }

    private static Object createKey(String recipientId, String msgTag) {
        return Arrays.asList(recipientId, msgTag);
    }
}

