/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.IconStore;
import org.astrogrid.samp.gui.SubscribedClientListModel;

public abstract class SendActionManager {
    private final GuiHubConnector connector_;
    final ListModel subscribedClientModel_;
    private final List menuList_;
    private final ListDataListener subscriptionListener_;
    private final ChangeListener connectionListener_;
    private boolean enabled_;
    private Action broadcastAct_;
    private boolean broadcastActCreated_;
    private Action[] sendActs_;
    private static Icon SEND_ICON;
    private static Icon BROADCAST_ICON;
    private static final Logger logger_;
    public static final String BROADCAST_TARGET = "All Clients";

    protected SendActionManager(GuiHubConnector connector, ListModel clientListModel) {
        this.connector_ = connector;
        this.subscribedClientModel_ = clientListModel;
        this.subscriptionListener_ = new ListDataListener(){

            public void intervalAdded(ListDataEvent evt) {
                SendActionManager.this.updateState();
            }

            public void intervalRemoved(ListDataEvent evt) {
                SendActionManager.this.updateState();
            }

            public void contentsChanged(ListDataEvent evt) {
                SendActionManager.this.updateState();
            }
        };
        this.subscribedClientModel_.addListDataListener(this.subscriptionListener_);
        this.connectionListener_ = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SendActionManager.this.updateEnabledness();
            }
        };
        connector.addConnectionListener(this.connectionListener_);
        this.enabled_ = true;
        this.menuList_ = new ArrayList();
    }

    protected abstract Action createBroadcastAction();

    protected abstract Action getSendAction(Client var1);

    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
        this.updateEnabledness();
    }

    public Action getBroadcastAction() {
        if (!this.broadcastActCreated_) {
            this.broadcastAct_ = this.createBroadcastAction();
            this.broadcastActCreated_ = true;
            this.updateEnabledness();
        }
        return this.broadcastAct_;
    }

    public JMenu createSendMenu(String name) {
        JMenu menu = new JMenu(name);
        for (int is = 0; is < this.sendActs_.length; ++is) {
            menu.add(this.sendActs_[is]);
        }
        this.menuList_.add(menu);
        this.updateEnabledness();
        return menu;
    }

    public void disposeSendMenu(JMenu menu) {
        this.menuList_.remove(menu);
    }

    public void dispose() {
        this.subscribedClientModel_.removeListDataListener(this.subscriptionListener_);
        if (this.subscribedClientModel_ instanceof SubscribedClientListModel) {
            ((SubscribedClientListModel)this.subscribedClientModel_).dispose();
        }
        this.connector_.removeConnectionListener(this.connectionListener_);
    }

    public void updateState() {
        int nsub = this.subscribedClientModel_.getSize();
        Object[] sendActs = new Action[nsub];
        for (int ia = 0; ia < nsub; ++ia) {
            sendActs[ia] = this.getSendAction((Client)this.subscribedClientModel_.getElementAt(ia));
        }
        if (!Arrays.equals(sendActs, this.sendActs_)) {
            this.sendActs_ = sendActs;
            Iterator menuIt = this.menuList_.iterator();
            while (menuIt.hasNext()) {
                JMenu menu = (JMenu)menuIt.next();
                menu.removeAll();
                for (int is = 0; is < sendActs.length; ++is) {
                    menu.add((Action)sendActs[is]);
                }
            }
            this.updateEnabledness();
        }
    }

    public ListModel getClientListModel() {
        return this.subscribedClientModel_;
    }

    public ComboBoxModel createTargetSelector() {
        return new TargetComboBoxModel(this.subscribedClientModel_);
    }

    public Action createTargetAction(final ComboBoxModel targetSelector) {
        return new AbstractAction("Send to selected target"){

            public void actionPerformed(ActionEvent evt) {
                Object target = targetSelector.getSelectedItem();
                if (target instanceof Client) {
                    SendActionManager.this.getSendAction((Client)target).actionPerformed(evt);
                } else if (SendActionManager.BROADCAST_TARGET.equals(target)) {
                    SendActionManager.this.getBroadcastAction().actionPerformed(evt);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    logger_.warning("Unknown send target: " + target + " - no action");
                }
            }
        };
    }

    public GuiHubConnector getConnector() {
        return this.connector_;
    }

    private void updateEnabledness() {
        boolean active;
        boolean bl = active = this.enabled_ && this.connector_.isConnected() && this.sendActs_.length > 0;
        if (this.broadcastAct_ != null) {
            this.broadcastAct_.setEnabled(active);
        }
        Iterator it = this.menuList_.iterator();
        while (it.hasNext()) {
            ((JMenu)it.next()).setEnabled(active);
        }
    }

    public static Icon getSendIcon() {
        if (SEND_ICON == null) {
            SEND_ICON = IconStore.createResourceIcon("phone2.gif");
        }
        return SEND_ICON;
    }

    public static Icon getBroadcastIcon() {
        if (BROADCAST_ICON == null) {
            BROADCAST_ICON = IconStore.createResourceIcon("tx3.gif");
        }
        return BROADCAST_ICON;
    }

    static {
        logger_ = Logger.getLogger(SendActionManager.class.getName());
    }

    private static class TargetComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final ListModel clientListModel_;
        private Object selectedItem_ = "All Clients";

        TargetComboBoxModel(ListModel clientListModel) {
            this.clientListModel_ = clientListModel;
            this.clientListModel_.addListDataListener(new ListDataListener(){

                public void contentsChanged(ListDataEvent evt) {
                    TargetComboBoxModel.this.fireContentsChanged(evt.getSource(), this.adjustIndex(evt.getIndex0()), this.adjustIndex(evt.getIndex1()));
                }

                public void intervalAdded(ListDataEvent evt) {
                    TargetComboBoxModel.this.fireIntervalAdded(evt.getSource(), this.adjustIndex(evt.getIndex0()), this.adjustIndex(evt.getIndex1()));
                }

                public void intervalRemoved(ListDataEvent evt) {
                    TargetComboBoxModel.this.fireIntervalRemoved(evt.getSource(), this.adjustIndex(evt.getIndex0()), this.adjustIndex(evt.getIndex1()));
                }

                private int adjustIndex(int index) {
                    return index >= 0 ? index + 1 : index;
                }
            });
        }

        public int getSize() {
            return this.clientListModel_.getSize() + 1;
        }

        public Object getElementAt(int index) {
            return index == 0 ? SendActionManager.BROADCAST_TARGET : this.clientListModel_.getElementAt(index - 1);
        }

        public Object getSelectedItem() {
            return this.selectedItem_;
        }

        public void setSelectedItem(Object item) {
            this.selectedItem_ = item;
        }
    }
}

