/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.ErrInfo;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.Platform;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.AbstractMessageHandler;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.ClientTracker;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.MessageHandler;
import org.astrogrid.samp.client.ResponseHandler;
import org.astrogrid.samp.client.ResultHandler;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.client.TrackedClientSet;

public class HubConnector {
    private final ClientProfile profile_;
    private final TrackedClientSet clientSet_;
    private final List messageHandlerList_;
    private final List responseHandlerList_;
    private final ConnectorCallableClient callable_;
    private final Map responseMap_;
    private final ClientTracker clientTracker_;
    private final CallHandler callHandler_;
    private volatile boolean isActive_;
    private volatile HubConnection connection_;
    private volatile Metadata metadata_;
    private volatile Subscriptions subscriptions_;
    private volatile int autoSec_;
    private volatile Timer regTimer_;
    private volatile int iCall_;
    private final Logger logger_ = Logger.getLogger(HubConnector.class.getName());
    private static final String SHUTDOWN_MTYPE = "samp.hub.event.shutdown";
    private static final String DISCONNECT_MTYPE = "samp.hub.disconnect";
    private static final String PING_MTYPE = "samp.app.ping";
    private static final String GETENV_MTYPE = "client.env.get";
    static final /* synthetic */ boolean $assertionsDisabled;

    public HubConnector(ClientProfile profile) {
        this(profile, new TrackedClientSet());
    }

    public HubConnector(ClientProfile profile, TrackedClientSet clientSet) {
        this.profile_ = profile;
        this.clientSet_ = clientSet;
        this.isActive_ = true;
        this.messageHandlerList_ = Collections.synchronizedList(new ArrayList());
        this.responseHandlerList_ = Collections.synchronizedList(new ArrayList());
        this.callable_ = new ConnectorCallableClient();
        this.responseMap_ = Collections.synchronizedMap(new HashMap());
        this.clientTracker_ = new ClientTracker(this.clientSet_);
        this.addMessageHandler(this.clientTracker_);
        this.addMessageHandler(new AbstractMessageHandler(SHUTDOWN_MTYPE){
            static final /* synthetic */ boolean $assertionsDisabled;

            public Map processCall(HubConnection connection, String senderId, Message message) {
                String mtype = message.getMType();
                if (!$assertionsDisabled && !HubConnector.SHUTDOWN_MTYPE.equals(mtype)) {
                    throw new AssertionError();
                }
                HubConnector.this.checkHubMessage(connection, senderId, mtype);
                HubConnector.this.disconnect();
                return null;
            }

            static {
                $assertionsDisabled = !(class$org$astrogrid$samp$client$HubConnector == null ? (class$org$astrogrid$samp$client$HubConnector = HubConnector.class$("org.astrogrid.samp.client.HubConnector")) : class$org$astrogrid$samp$client$HubConnector).desiredAssertionStatus();
            }
        });
        this.addMessageHandler(new AbstractMessageHandler(DISCONNECT_MTYPE){
            static final /* synthetic */ boolean $assertionsDisabled;

            public Map processCall(HubConnection connection, String senderId, Message message) {
                String mtype = message.getMType();
                if (!$assertionsDisabled && !HubConnector.DISCONNECT_MTYPE.equals(mtype)) {
                    throw new AssertionError();
                }
                if (senderId.equals(connection.getRegInfo().getHubId())) {
                    Object reason = message.getParam("reason");
                    HubConnector.this.logger_.warning("Forcible disconnect from hub" + (reason == null ? " [no reason given]" : " (" + reason + ")"));
                    HubConnector.this.disconnect();
                    HubConnector.this.isActive_ = false;
                    return null;
                }
                throw new IllegalArgumentException("Ignoring " + mtype + " message from non-hub" + " client " + senderId);
            }

            static {
                $assertionsDisabled = !(class$org$astrogrid$samp$client$HubConnector == null ? (class$org$astrogrid$samp$client$HubConnector = HubConnector.class$("org.astrogrid.samp.client.HubConnector")) : class$org$astrogrid$samp$client$HubConnector).desiredAssertionStatus();
            }
        });
        this.addMessageHandler(new AbstractMessageHandler(PING_MTYPE){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map processCall(HubConnection connection, String senderId, Message message) throws InterruptedException {
                String waitMillis = (String)message.getParam("waitMillis");
                if (waitMillis != null) {
                    Object lock;
                    Object object = lock = new Object();
                    synchronized (object) {
                        lock.wait(SampUtils.decodeInt(waitMillis));
                    }
                }
                return null;
            }
        });
        this.addMessageHandler(new AbstractMessageHandler(GETENV_MTYPE){

            public Map processCall(HubConnection connection, String senderId, Message message) {
                String name = (String)message.getParam("name");
                String value = Platform.getPlatform().getEnv(name);
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("value", value == null ? "" : value);
                return result;
            }
        });
        this.addResponseHandler(new ResponseHandler(){

            public boolean ownsTag(String msgTag) {
                return HubConnector.this.responseMap_.containsKey(msgTag);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receiveResponse(HubConnection connection, String responderId, String msgTag, Response response) {
                Map map = HubConnector.this.responseMap_;
                synchronized (map) {
                    if (HubConnector.this.responseMap_.containsKey(msgTag) && HubConnector.this.responseMap_.get(msgTag) == null) {
                        HubConnector.this.responseMap_.put(msgTag, response);
                        HubConnector.this.responseMap_.notifyAll();
                    }
                }
            }
        });
        this.callHandler_ = new CallHandler();
        this.addResponseHandler(this.callHandler_);
    }

    public synchronized void setAutoconnect(int autoSec) {
        this.autoSec_ = autoSec;
        this.configureRegisterTimer(this.autoSec_);
    }

    private synchronized void configureRegisterTimer(int autoSec) {
        if (this.regTimer_ != null) {
            this.regTimer_.cancel();
            this.regTimer_ = null;
        }
        if (autoSec > 0) {
            TimerTask regTask = new TimerTask(){

                public void run() {
                    if (!HubConnector.this.isConnected()) {
                        try {
                            HubConnection conn = HubConnector.this.getConnection();
                            if (conn == null) {
                                HubConnector.this.logger_.config("SAMP autoconnection attempt failed");
                            } else {
                                HubConnector.this.logger_.info("SAMP autoconnection attempt succeeded");
                            }
                        }
                        catch (SampException e) {
                            HubConnector.this.logger_.config("SAMP Autoconnection attempt  failed: " + e);
                        }
                    }
                }
            };
            this.regTimer_ = new Timer(true);
            this.regTimer_.schedule(regTask, 0L, (long)(this.autoSec_ * 1000));
        }
    }

    public void declareMetadata(Map meta) {
        Metadata md = Metadata.asMetadata(meta);
        md.check();
        this.metadata_ = md;
        if (this.isConnected()) {
            try {
                this.connection_.declareMetadata(md);
            }
            catch (SampException e) {
                this.logger_.log(Level.WARNING, "SAMP metadata declaration failed", e);
            }
        }
    }

    public Metadata getMetadata() {
        return this.metadata_;
    }

    public void declareSubscriptions(Map subscriptions) {
        Subscriptions subs = Subscriptions.asSubscriptions(subscriptions);
        subs.check();
        this.subscriptions_ = subs;
        if (this.isConnected()) {
            try {
                this.connection_.declareSubscriptions(subs);
            }
            catch (SampException e) {
                this.logger_.log(Level.WARNING, "Subscriptions declaration failed", e);
            }
        }
    }

    public Subscriptions getSubscriptions() {
        return this.subscriptions_;
    }

    public Subscriptions computeSubscriptions() {
        MessageHandler[] mhandlers = this.messageHandlerList_.toArray(new MessageHandler[0]);
        HashMap subs = new HashMap();
        for (int ih = mhandlers.length - 1; ih >= 0; --ih) {
            subs.putAll(mhandlers[ih].getSubscriptions());
        }
        return Subscriptions.asSubscriptions(subs);
    }

    public void addMessageHandler(MessageHandler handler) {
        this.messageHandlerList_.add(handler);
    }

    public void removeMessageHandler(MessageHandler handler) {
        this.messageHandlerList_.remove(handler);
    }

    public void addResponseHandler(ResponseHandler handler) {
        this.responseHandlerList_.add(handler);
    }

    public void removeResponseHandler(ResponseHandler handler) {
        this.responseHandlerList_.remove(handler);
    }

    public void setActive(boolean active) {
        this.isActive_ = active;
        if (active) {
            if (this.connection_ == null) {
                try {
                    this.getConnection();
                }
                catch (SampException e) {
                    this.logger_.log(Level.WARNING, "Hub connection attempt failed", e);
                }
            }
            this.configureRegisterTimer(this.autoSec_);
        } else {
            HubConnection connection = this.connection_;
            if (connection != null) {
                this.disconnect();
                try {
                    connection.unregister();
                }
                catch (SampException e) {
                    this.logger_.log(Level.INFO, "Unregister attempt failed", e);
                }
            }
            this.configureRegisterTimer(0);
        }
    }

    public boolean isActive() {
        return this.isActive_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response callAndWait(String recipientId, Map msg, int timeout) throws SampException {
        long finish = timeout > 0 ? System.currentTimeMillis() + (long)(timeout * 1000) : Long.MAX_VALUE;
        HubConnection connection = this.getConnection();
        String msgTag = this.createTag(this);
        this.responseMap_.put(msgTag, null);
        connection.call(recipientId, msgTag, msg);
        Map map = this.responseMap_;
        synchronized (map) {
            while (this.responseMap_.containsKey(msgTag) && this.responseMap_.get(msgTag) == null && System.currentTimeMillis() < finish) {
                long millis = finish - System.currentTimeMillis();
                if (millis <= 0L) continue;
                try {
                    this.responseMap_.wait(millis);
                }
                catch (InterruptedException e) {
                    throw new SampException("Wait interrupted", e);
                }
            }
            if (this.responseMap_.containsKey(msgTag)) {
                Response response = (Response)this.responseMap_.remove(msgTag);
                if (response != null) {
                    return response;
                }
                if (!$assertionsDisabled && System.currentTimeMillis() < finish) {
                    throw new AssertionError();
                }
                throw new SampException("Synchronous call timeout");
            }
            if (connection != this.connection_) {
                throw new SampException("Hub connection lost");
            }
            throw new AssertionError();
        }
    }

    public void call(String recipientId, Map msg, ResultHandler resultHandler, int timeout) throws SampException {
        HubConnection connection = this.getConnection();
        if (connection == null) {
            throw new SampException("Not connected");
        }
        String tag = this.createTag(this);
        this.callHandler_.registerHandler(tag, resultHandler, timeout);
        try {
            connection.call(recipientId, tag, msg);
            this.callHandler_.setRecipients(tag, new String[]{recipientId});
        }
        catch (SampException e) {
            this.callHandler_.unregisterHandler(tag);
            throw e;
        }
    }

    public void callAll(Map msg, ResultHandler resultHandler, int timeout) throws SampException {
        HubConnection connection = this.getConnection();
        if (connection == null) {
            throw new SampException("Not connected");
        }
        String tag = this.createTag(this);
        this.callHandler_.registerHandler(tag, resultHandler, timeout);
        try {
            Map callMap = connection.callAll(tag, msg);
            this.callHandler_.setRecipients(tag, callMap.keySet().toArray(new String[0]));
        }
        catch (SampException e) {
            this.callHandler_.unregisterHandler(tag);
            throw e;
        }
    }

    public boolean isConnected() {
        return this.connection_ != null;
    }

    public HubConnection getConnection() throws SampException {
        HubConnection connection = this.connection_;
        if (connection == null && this.isActive_ && (connection = this.createConnection()) != null) {
            this.connection_ = connection;
            this.configureConnection(connection);
            this.clientTracker_.initialise(connection);
            this.connectionChanged(true);
        }
        return connection;
    }

    public void configureConnection(HubConnection connection) throws SampException {
        if (this.metadata_ != null) {
            connection.declareMetadata(this.metadata_);
        }
        if (this.callable_ != null) {
            connection.setCallable(this.callable_);
            this.callable_.setConnection(connection);
            if (this.subscriptions_ != null) {
                connection.declareSubscriptions(this.subscriptions_);
            }
        }
    }

    public Map getClientMap() {
        if (this.subscriptions_ == null) {
            this.logger_.warning("Danger: you should call declareSubscriptions before using client map");
        }
        return this.getClientSet().getClientMap();
    }

    protected TrackedClientSet getClientSet() {
        return this.clientSet_;
    }

    protected HubConnection createConnection() throws SampException {
        return this.profile_.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        boolean wasConnected = this.connection_ != null;
        this.connection_ = null;
        this.clientTracker_.clear();
        this.callHandler_.stopTimeouter();
        Map map = this.responseMap_;
        synchronized (map) {
            this.responseMap_.clear();
            this.responseMap_.notifyAll();
        }
        if (wasConnected) {
            this.connectionChanged(false);
        }
    }

    protected void connectionChanged(boolean isConnected) {
    }

    private void checkHubMessage(HubConnection connection, String senderId, String mtype) {
        if (!senderId.equals(connection.getRegInfo().getHubId())) {
            this.logger_.warning("Hub admin message " + mtype + " received from " + "non-hub client.  Acting on it anyhow");
        }
    }

    public synchronized String createTag(Object owner) {
        return (owner == null ? "tag" : String.valueOf(owner) + ":") + ++this.iCall_;
    }

    static {
        $assertionsDisabled = !HubConnector.class.desiredAssertionStatus();
    }

    private class CallItem
    implements Comparable {
        final ResultHandler handler_;
        final long finish_;
        volatile Map responseMap_;
        volatile Map recipientMap_;

        CallItem(ResultHandler handler, long finish) {
            this.handler_ = handler;
            this.finish_ = finish;
        }

        public synchronized void setRecipients(String[] recipientIds) {
            this.recipientMap_ = new HashMap();
            Map clientMap = HubConnector.this.getClientMap();
            for (int ir = 0; ir < recipientIds.length; ++ir) {
                String id = recipientIds[ir];
                Client client = (Client)clientMap.get(id);
                this.recipientMap_.put(id, client);
            }
            if (this.responseMap_ != null) {
                Iterator it = this.responseMap_.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String responderId = (String)entry.getKey();
                    Response response = (Response)entry.getValue();
                    this.processResponse(responderId, response);
                }
                this.responseMap_ = null;
            }
        }

        public synchronized void addResponse(String responderId, Response response) {
            if (this.recipientMap_ != null) {
                this.processResponse(responderId, response);
            } else {
                if (this.responseMap_ == null) {
                    this.responseMap_ = new HashMap();
                }
                this.responseMap_.put(responderId, response);
            }
        }

        private synchronized void processResponse(final String responderId, Response response) {
            if (this.recipientMap_.containsKey(responderId)) {
                Client client = (Client)this.recipientMap_.get(responderId);
                if (client == null) {
                    client = (Client)HubConnector.this.getClientMap().get(responderId);
                }
                if (client == null) {
                    client = new Client(){

                        public String getId() {
                            return responderId;
                        }

                        public Metadata getMetadata() {
                            return null;
                        }

                        public Subscriptions getSubscriptions() {
                            return null;
                        }
                    };
                }
                this.handler_.result(client, response);
                this.recipientMap_.remove(responderId);
            }
        }

        public synchronized boolean isDone() {
            return this.recipientMap_ != null && this.recipientMap_.isEmpty() || System.currentTimeMillis() >= this.finish_;
        }

        public int compareTo(Object o) {
            CallItem other = (CallItem)o;
            if (this.finish_ < other.finish_) {
                return -1;
            }
            if (this.finish_ > other.finish_) {
                return 1;
            }
            return System.identityHashCode(this) - System.identityHashCode(other);
        }
    }

    private class CallHandler
    implements ResponseHandler {
        private final SortedMap tagMap_ = new TreeMap();
        private Thread timeouter_;

        CallHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readyTimeouter() {
            SortedMap sortedMap = this.tagMap_;
            synchronized (sortedMap) {
                if (this.timeouter_ == null) {
                    this.timeouter_ = new Thread("ResultHandler timeout watcher"){

                        public void run() {
                            CallHandler.this.watchTimeouts();
                        }
                    };
                    this.timeouter_.setDaemon(true);
                    this.timeouter_.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopTimeouter() {
            SortedMap sortedMap = this.tagMap_;
            synchronized (sortedMap) {
                if (this.timeouter_ != null) {
                    this.timeouter_.interrupt();
                }
                this.timeouter_ = null;
                this.tagMap_.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void watchTimeouts() {
            while (!Thread.currentThread().isInterrupted()) {
                SortedMap sortedMap = this.tagMap_;
                synchronized (sortedMap) {
                    long nextFinish = this.tagMap_.isEmpty() ? Long.MAX_VALUE : ((CallItem)this.tagMap_.get(this.tagMap_.firstKey())).finish_;
                    long delay = nextFinish - System.currentTimeMillis();
                    if (delay > 0L) {
                        try {
                            this.tagMap_.wait(delay);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    long now = System.currentTimeMillis();
                    Iterator it = this.tagMap_.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        CallItem item = (CallItem)entry.getValue();
                        if (now < item.finish_) continue;
                        item.handler_.done();
                        it.remove();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerHandler(String tag, ResultHandler handler, int timeout) {
            long finish = timeout > 0 ? System.currentTimeMillis() + (long)(timeout * 1000) : Long.MAX_VALUE;
            CallItem item = new CallItem(handler, finish);
            if (!item.isDone()) {
                SortedMap sortedMap = this.tagMap_;
                synchronized (sortedMap) {
                    this.readyTimeouter();
                    this.tagMap_.put(tag, item);
                    this.tagMap_.notifyAll();
                }
            } else {
                handler.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRecipients(String tag, String[] recipients) {
            CallItem item;
            SortedMap sortedMap = this.tagMap_;
            synchronized (sortedMap) {
                item = (CallItem)this.tagMap_.get(tag);
            }
            item.setRecipients(recipients);
            this.retireIfDone(tag, item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterHandler(String tag) {
            SortedMap sortedMap = this.tagMap_;
            synchronized (sortedMap) {
                this.tagMap_.remove(tag);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean ownsTag(String tag) {
            SortedMap sortedMap = this.tagMap_;
            synchronized (sortedMap) {
                return this.tagMap_.containsKey(tag);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveResponse(HubConnection connection, String responderId, String msgTag, Response response) {
            CallItem item;
            SortedMap sortedMap = this.tagMap_;
            synchronized (sortedMap) {
                item = (CallItem)this.tagMap_.get(msgTag);
            }
            if (item != null) {
                item.addResponse(responderId, response);
                this.retireIfDone(msgTag, item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void retireIfDone(String tag, CallItem item) {
            if (item.isDone()) {
                SortedMap sortedMap = this.tagMap_;
                synchronized (sortedMap) {
                    item.handler_.done();
                    this.tagMap_.remove(tag);
                }
            }
        }
    }

    private class ConnectorCallableClient
    implements CallableClient {
        private HubConnection conn_;

        private ConnectorCallableClient() {
        }

        private void setConnection(HubConnection connection) {
            this.conn_ = connection;
        }

        public void receiveNotification(String senderId, Message message) {
            MessageHandler[] mhandlers = HubConnector.this.messageHandlerList_.toArray(new MessageHandler[0]);
            for (int ih = 0; ih < mhandlers.length; ++ih) {
                String mtype;
                MessageHandler handler = mhandlers[ih];
                Subscriptions subs = Subscriptions.asSubscriptions(handler.getSubscriptions());
                if (!subs.isSubscribed(mtype = message.getMType())) continue;
                try {
                    handler.receiveNotification(this.conn_, senderId, message);
                    continue;
                }
                catch (Throwable e) {
                    HubConnector.this.logger_.log(Level.WARNING, "Notify handler failed " + mtype, e);
                }
            }
        }

        public void receiveCall(String senderId, String msgId, Message message) {
            String mtype = message.getMType();
            ErrInfo errInfo = null;
            MessageHandler[] mhandlers = HubConnector.this.messageHandlerList_.toArray(new MessageHandler[0]);
            for (int ih = 0; ih < mhandlers.length; ++ih) {
                MessageHandler handler = mhandlers[ih];
                Subscriptions subs = Subscriptions.asSubscriptions(handler.getSubscriptions());
                if (!subs.isSubscribed(mtype)) continue;
                try {
                    handler.receiveCall(this.conn_, senderId, msgId, message);
                    return;
                }
                catch (Throwable e) {
                    errInfo = new ErrInfo(e);
                    HubConnector.this.logger_.log(Level.WARNING, "Call handler failed " + mtype, e);
                }
            }
            if (errInfo == null) {
                HubConnector.this.logger_.warning("No handler for subscribed MType " + mtype);
                errInfo = new ErrInfo("No handler found");
                errInfo.setUsertxt("No handler was found for the supplied MType. Looks like a programming error at the  recipient end.  Sorry.");
            }
            Response response = Response.createErrorResponse(errInfo);
            response.check();
            try {
                this.conn_.reply(msgId, response);
            }
            catch (SampException e) {
                HubConnector.this.logger_.warning("Failed to reply to " + msgId);
            }
        }

        public void receiveResponse(String responderId, String msgTag, Response response) {
            int handleCount = 0;
            ResponseHandler[] rhandlers = HubConnector.this.responseHandlerList_.toArray(new ResponseHandler[0]);
            for (int ih = 0; ih < rhandlers.length; ++ih) {
                ResponseHandler handler = rhandlers[ih];
                if (!handler.ownsTag(msgTag)) continue;
                ++handleCount;
                try {
                    handler.receiveResponse(this.conn_, responderId, msgTag, response);
                    continue;
                }
                catch (Exception e) {
                    HubConnector.this.logger_.log(Level.WARNING, "Response handler failed", e);
                }
            }
            if (handleCount == 0) {
                HubConnector.this.logger_.warning("No handler for message " + msgTag + " response");
            } else if (handleCount > 1) {
                HubConnector.this.logger_.warning("Multiple (" + handleCount + ")" + " handlers handled message " + msgTag + " respose");
            }
        }
    }
}

