/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import java.net.URL;
import java.util.Map;
import org.astrogrid.samp.SampMap;
import org.astrogrid.samp.SampUtils;

public class Metadata
extends SampMap {
    public static final String NAME_KEY = "samp.name";
    public static final String DESCTEXT_KEY = "samp.description.text";
    public static final String DESCHTML_KEY = "samp.description.html";
    public static final String ICONURL_KEY = "samp.icon.url";
    public static final String DOCURL_KEY = "samp.documentation.url";
    private static final String[] KNOWN_KEYS = new String[]{"samp.name", "samp.description.text", "samp.description.html", "samp.icon.url", "samp.documentation.url"};

    public Metadata() {
        super(KNOWN_KEYS);
    }

    public Metadata(Map map) {
        this();
        this.putAll(map);
    }

    public void setName(String name) {
        this.put(NAME_KEY, name);
    }

    public String getName() {
        return (String)this.get(NAME_KEY);
    }

    public void setDescriptionText(String txt) {
        this.put(DESCTEXT_KEY, txt);
    }

    public String getDescriptionText() {
        return (String)this.get(DESCTEXT_KEY);
    }

    public void setDescriptionHtml(String html) {
        this.put(DESCHTML_KEY, html);
    }

    public String getDescriptionHtml() {
        return (String)this.get(DESCHTML_KEY);
    }

    public void setIconUrl(String url) {
        this.put(ICONURL_KEY, url);
    }

    public URL getIconUrl() {
        return this.getUrl(ICONURL_KEY);
    }

    public void setDocumentationUrl(String url) {
        this.put(DOCURL_KEY, url);
    }

    public URL getDocumentationUrl() {
        return this.getUrl(DOCURL_KEY);
    }

    public void check() {
        super.check();
        SampUtils.checkUrl(this.getString(DOCURL_KEY));
        SampUtils.checkUrl(this.getString(ICONURL_KEY));
    }

    public static Metadata asMetadata(Map map) {
        return map instanceof Metadata || map == null ? (Metadata)map : new Metadata(map);
    }
}

