/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.ukatc.xsltchain;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import uk.ac.roe.ukatc.xsltchain.AlmaPckg;
import uk.ac.roe.ukatc.xsltchain.ApplicationOptions;
import uk.ac.roe.ukatc.xsltchain.ChainTranslator;
import uk.ac.roe.ukatc.xsltchain.XsltChain;
import uk.ac.roe.ukatc.xsltchain.XsltChainException;

public class ConvertZip {
    static Properties props;
    static ApplicationOptions ap;
    static Vector<String> PropList;
    static Map<String, String> versionMap;

    public static void main(String[] args) {
        PropList = new Vector();
        ap = new ApplicationOptions();
        ap.AddOption("v", "version", true, "Output version name");
        ap.AddOption("i", "input", true, "Input filename");
        ap.AddOption("o", "output", true, "Output filename");
        ap.AddOption("t", "table", true, "Version table URL");
        ap.AddOption("m", "map", true, "Version map URL");
        ap.AddOption("d", "debug", false, "Issue (some) debug information to stdout");
        ap.AddOption("h", "help", false, "Output help and config");
        ap.ParseArgs(args);
        if (ap.hasOpt("help")) {
            ConvertZip.helpAndConfig();
            System.exit(1);
        }
        if (!(ap.VerifyOpt("input") && ap.VerifyOpt("version") && ap.VerifyOpt("map") && ap.VerifyOpt("table"))) {
            System.exit(1);
        }
        try {
            ConvertZip.ConvertZipFile();
        }
        catch (IOException e) {
            System.err.println("Error: cannot open zipfile? " + ap.getOpt("input"));
            e.printStackTrace();
        }
        catch (TransformerException e) {
            System.err.println("Problem trying to convert project");
            e.printStackTrace();
        }
    }

    public static void Converter(String infile, String versionmap, String versiontable, String outputversion, String outfile) throws TransformerException {
        ap = new ApplicationOptions();
        ap.AddOption("v", "version", true, "Output version name");
        ap.AddOption("i", "input", true, "Input filename");
        ap.AddOption("o", "output", true, "Output filename");
        ap.AddOption("t", "table", true, "Version table URL");
        ap.AddOption("m", "map", true, "Version map URL");
        ap.AddOption("d", "debug", false, "Issue (some) debug information to stdout");
        ap.AddOption("h", "help", false, "Output help and config");
        String[] args = new String[]{"--input=" + infile, "--map=" + versionmap, "--table=" + versiontable, "--version=" + outputversion, "--output=" + outfile};
        ap.ParseArgs(args);
        if (!(ap.VerifyOpt("input") && ap.VerifyOpt("version") && ap.VerifyOpt("table") && ap.VerifyOpt("map"))) {
            System.out.println("Problems with arguments");
        }
        try {
            ConvertZip.ConvertZipFile();
        }
        catch (IOException e) {
            System.err.println("Error: cannot open zipfile? " + ap.getOpt("input"));
            e.printStackTrace();
            throw new TransformerException("Problem converting project", e);
        }
    }

    static void helpAndConfig() {
        System.out.println("== USAGE ==");
        System.out.println("ConvertZip --input url --output url --version str --table url");
        System.out.println("== CONFIG ==");
        System.out.println("Properties;");
        for (String s : PropList) {
            System.out.println("     ->" + s);
        }
        System.out.print("Requested version:");
        System.out.println(ap.getOpt("version"));
        System.out.print("Requested input:");
        System.out.println(ap.getOpt("input"));
        System.out.print("Requested output:");
        System.out.println(ap.getOpt("output"));
        System.out.print("Requested table:");
        System.out.println(ap.getOpt("table"));
        System.out.print("Requested version map:");
        System.out.println(ap.getOpt("map"));
        URL base = ConvertZip.getBaseURL();
        System.out.println("Base URL: " + base);
    }

    static void ConvertZipFile() throws IOException, TransformerException {
        URL base = ConvertZip.getBaseURL();
        if (ap.hasOpt("debug")) {
            System.out.println("Debug output included below");
        }
        versionMap = ConvertZip.getVersionMap(base);
        XsltChain xc = ConvertZip.getXsltChain(base);
        String out_ver = ap.getOpt("version");
        AlmaPckg alma = new AlmaPckg(ap.getOpt("input"));
        ZipOutputStream os = null;
        if (ap.hasOpt("output")) {
            String outfile = ap.getOpt("output");
            os = ConvertZip.createOutputZipfile(outfile, alma);
        }
        int files_copied = 0;
        int files_translated = 0;
        for (String name : alma.keySet()) {
            String XSD = null;
            String rev = null;
            String ver = null;
            try {
                XSD = alma.getXSD(name);
                rev = alma.getVersion(name);
                if (rev == null) {
                    throw new TransformerException("This project predates versioning - it is too old to be upgraded");
                }
                ver = ConvertZip.getVersionFromMap(rev);
                if (ver.equals(out_ver)) {
                    System.out.println("Warning: File " + name + " is already at requested version (" + out_ver + ") ");
                    System.out.println("       : will do simple copy instead of translation!");
                    if (os != null) {
                        ConvertZip.simple_copy(alma.getStream(name), os);
                    } else {
                        ConvertZip.simple_copy(alma.getStream(name), System.out);
                    }
                    ++files_copied;
                    continue;
                }
                if (XSD.equals("binary")) {
                    System.out.println("File " + name + " is a binary ");
                    System.out.println("       : will just copy");
                    if (os != null) {
                        os.putNextEntry(new ZipEntry(name));
                        ConvertZip.binary_copy(alma.getStream(name), alma.getSize(name), os);
                        os.flush();
                        os.closeEntry();
                    }
                    ++files_copied;
                    continue;
                }
                System.out.print("File " + name);
                ChainTranslator ct = base != null ? xc.getChainTranslator(XSD, ver, out_ver, base) : xc.getChainTranslator(XSD, ver, out_ver);
                if (ap.hasOpt("debug")) {
                    List l = xc.getTranslationList(XSD, ver, out_ver);
                    Iterator i = l.iterator();
                    System.out.println("        Translations to be applied (in order);");
                    while (i.hasNext()) {
                        String s = (String)i.next();
                        System.out.println("           " + s);
                    }
                }
                if (os != null) {
                    if (ct.GetNFilters() < 1) {
                        System.out.println("Warning: There are NO filters defined to convert to" + out_ver);
                        System.out.println("       : This will be a NULL transform of " + name);
                    }
                    os.putNextEntry(new ZipEntry(name));
                    ct.Convert(alma.getStream(name), os);
                    os.closeEntry();
                    System.out.print(" Converted [" + ver + "] to [" + out_ver + "] in " + ap.getOpt("output"));
                    if (ap.hasOpt("debug")) {
                        System.out.print("\n        Used " + ct.GetNFilters() + " filters in total");
                    }
                } else {
                    ct.Convert(alma.getStream(name), System.out);
                }
                ++files_translated;
                System.out.print("\n");
            }
            catch (TransformerConfigurationException e) {
                System.err.println("Error: cannot init transformer.");
                e.printStackTrace();
                throw new TransformerException("Problem converting project", e);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new TransformerException("Problem converting project", e);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                throw new TransformerException("Problem converting project", e);
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new TransformerException("Problem converting project", e);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new TransformerException("Problem converting project", e);
            }
            catch (TransformerException e) {
                e.printStackTrace();
                throw new TransformerException("Problem converting project", e);
            }
            catch (XsltChainException xce) {
                System.err.println("Error: cannot convert document");
                System.err.println("    Input (" + name + " in " + ap.getOpt("input"));
                System.err.println("    document based on " + XSD + " schema");
                System.err.println("    Input ver = " + ver);
                System.err.println("    Output ver = " + out_ver);
                xce.printStackTrace();
                throw new TransformerException("Problem converting project", xce);
            }
        }
        System.out.println("Copied " + files_copied + " files and translated " + files_translated + " files to output");
        if (os != null) {
            os.close();
        }
    }

    private static void simple_copy(InputStream is, OutputStream os) throws IOException {
        int byte_;
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        int i = 0;
        while ((byte_ = bis.read()) != -1) {
            char[] c = Character.toChars(byte_);
            System.out.print(c);
            if (i == 40) {
                System.out.println("");
                i = 0;
            }
            bos.write(byte_);
            ++i;
        }
    }

    private static void binary_copy(InputStream is, long size, OutputStream os) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        byte[] data = new byte[(int)size];
        try {
            int totalRead = 0;
            while (totalRead < data.length) {
                int nRead = bis.read(data, totalRead, bis.available());
                if (nRead == -1) {
                    break;
                }
                totalRead += nRead;
            }
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception exception) {}
        }
        bos.write(data, 0, (int)size);
    }

    public static Properties get_properties(String FileName) throws IOException {
        File pf = new File(FileName);
        if (pf.canRead()) {
            FileInputStream ps = new FileInputStream(pf);
            Properties p = new Properties();
            p.load(ps);
            p.setProperty("PropertyFile", FileName);
            return p;
        }
        return null;
    }

    public static void load_defaults() throws FileNotFoundException, IOException {
        PropList = new Vector();
        String config_filename = System.getProperty("convertrc");
        if (config_filename != null) {
            Properties p = ConvertZip.get_properties(config_filename);
            if (p == null) {
                throw new FileNotFoundException("Not found or not readable :" + config_filename);
            }
            PropList.add("Loaded properties from " + config_filename + " supplied by system property convertrc");
            props = p;
            return;
        }
        PropList.add("Failed to find properties: No system property convertrc");
        String fs = System.getProperty("file.separator");
        String CWD = System.getProperty("user.dir");
        config_filename = String.valueOf(CWD) + fs + ".convertrc";
        System.out.println(config_filename);
        Properties p = ConvertZip.get_properties(config_filename);
        if (p != null) {
            props = p;
            PropList.add("Loaded properties from " + config_filename);
            return;
        }
        PropList.add("Failed to find properties: No .convertrc in CWD");
        String homedir = System.getProperty("user.home");
        config_filename = String.valueOf(homedir) + fs + ".convertrc";
        p = ConvertZip.get_properties(config_filename);
        if (p != null) {
            props = p;
            PropList.add("Loaded properties from " + config_filename);
            return;
        }
        PropList.add("Failed to find properties: No .convertrc in homedir");
        props = new Properties();
        props.setProperty("PropertyFile", "");
        PropList.add("Loaded an empty properties file");
    }

    static URL getBaseURL() {
        URL base = null;
        try {
            base = new URL("http://www.roe.ac.uk/ukatc/projects/alma/ConversionScripts/");
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        props = System.getProperties();
        if (props.containsKey("BASE_URL")) {
            try {
                base = new URL(props.getProperty("BASE_URL"));
            }
            catch (MalformedURLException e) {
                System.out.println("Error: Malformed BASE_URL :" + props.getProperty("BASE_URL"));
                e.printStackTrace();
            }
            System.out.println("BASE_URL = " + props.getProperty("BASE_URL"));
        }
        return base;
    }

    public static void setBaseURL(String base) {
        props = System.getProperties();
        props.setProperty("BASE_URL", base);
    }

    static Map<String, String> getVersionMap(URL base) {
        String map_url = ap.getOpt("map");
        URL vm = null;
        try {
            vm = base != null ? new URL(base, map_url) : new URL(map_url);
            System.out.println("Base = " + base.toString());
            System.out.println("URL = " + vm.toString());
        }
        catch (MalformedURLException e) {
            System.out.println("Error: Malformed versionmap URL :" + map_url);
            e.printStackTrace();
            System.exit(1);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(vm.openStream()));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() != 2) {
                    System.err.println("Skipping ill-formatted line " + line);
                    continue;
                }
                String vers = st.nextToken();
                String revlist = st.nextToken();
                map.put(vers, revlist);
                System.out.println("Added " + line);
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return map;
    }

    static String getVersionFromMap(String revno) {
        String vers = "0";
        block0: for (Map.Entry<String, String> e : versionMap.entrySet()) {
            String[] versions = e.getValue().split(",");
            int i = 0;
            while (i < versions.length) {
                if (versions[i].equals(revno)) {
                    vers = e.getKey();
                    continue block0;
                }
                ++i;
            }
        }
        System.out.println("Found vers= " + vers);
        return vers;
    }

    static XsltChain getXsltChain(URL base) {
        String table_url = ap.getOpt("table");
        URL vt = null;
        try {
            vt = base != null ? new URL(base, table_url) : new URL(table_url);
            System.out.println("Base = " + base.toString());
            System.out.println("URL = " + vt.toString());
        }
        catch (MalformedURLException e) {
            System.out.println("Error: Malformed versiontable URL :" + table_url);
            e.printStackTrace();
            System.exit(1);
        }
        XsltChain xc = new XsltChain();
        try {
            xc.addTranslatorsFromStream(vt.openStream());
        }
        catch (IOException e) {
            System.out.println("Error: IOException on URL :" + table_url);
            e.printStackTrace();
        }
        return xc;
    }

    static ZipOutputStream createOutputZipfile(String filename, AlmaPckg ap) {
        ZipOutputStream ret = null;
        try {
            ret = new ZipOutputStream(new FileOutputStream(filename));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return ret;
    }
}

