/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.ukatc.xsltchain;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import uk.ac.roe.ukatc.xsltchain.AlmaFile;

public class AlmaPckg {
    private Map<String, AlmaFile> dir = new HashMap<String, AlmaFile>();
    private Map<String, String> verLocations = this.loadVersionLocations();
    private Map<String, String> backupverLocations = this.loadBackupVersionLocations();
    private DocumentBuilder builder;
    private XPath xpath;

    AlmaPckg(String zipfilename) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.builder = null;
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        XPathFactory xfactory = XPathFactory.newInstance();
        this.xpath = xfactory.newXPath();
        ZipFile zfile = new ZipFile(zipfilename);
        Enumeration<? extends ZipEntry> z = zfile.entries();
        while (z.hasMoreElements()) {
            ZipEntry ze = z.nextElement();
            if (ze.isDirectory()) continue;
            AlmaFile af = new AlmaFile(zfile, ze);
            if (ze.getName().endsWith(".pdf")) {
                af.setXSD("binary");
                af.setVer("0");
            } else {
                this.parse(af);
            }
            String name = ze.getName();
            this.dir.put(name, af);
        }
    }

    private Map<String, String> loadVersionLocations() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("ObsProject", "//ObsProject/@schemaVersion");
        m.put("ObsProposal", "//ObsProposal/@schemaVersion");
        m.put("SchedBlock", "//SchedBlock/@schemaVersion");
        m.put("ObsAttachment", "//ObsAttachment/@schemaVersion");
        return m;
    }

    private Map<String, String> loadBackupVersionLocations() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("ObsProject", "//ObsProjectEntity/@datamodelVersion");
        m.put("ObsProposal", "//ObsProposalEntity/@datamodelVersion");
        m.put("SchedBlock", "//SchedBlockEntity/@datamodelVersion");
        m.put("ObsAttachment", "//ObsAttachmentEntity/@datamodelVersion");
        return m;
    }

    String getVersionFromDocument(String xsd, Document doc) {
        String lookup = this.verLocations.get(xsd);
        String retval = null;
        if (lookup == null) {
            return null;
        }
        try {
            retval = this.xpath.evaluate(lookup, doc);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        if (retval.equals("")) {
            String backup = this.backupverLocations.get(xsd);
            if (backup == null) {
                return null;
            }
            try {
                retval = this.xpath.evaluate(backup, doc);
            }
            catch (XPathExpressionException e2) {
                e2.printStackTrace();
            }
        }
        return retval;
    }

    boolean parse(AlmaFile af) {
        Document document = null;
        try {
            document = this.builder.parse(af.getStream());
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String xsd = document.getDocumentElement().getAttribute("xsi:type");
        xsd = xsd.substring(xsd.indexOf(":") + 1);
        af.setXSD(xsd);
        String ver = this.getVersionFromDocument(xsd, document);
        if (ver != null) {
            af.setVer(ver);
        }
        return true;
    }

    InputStream getStream(String name) {
        AlmaFile af = this.dir.get(name);
        return af.getStream();
    }

    long getSize(String name) {
        AlmaFile af = this.dir.get(name);
        return af.getSize();
    }

    Set<String> keySet() {
        return this.dir.keySet();
    }

    String getVersion(String fn) {
        return this.dir.get(fn).getVer();
    }

    String getXSD(String fn) {
        return this.dir.get(fn).getXSD();
    }

    void print() {
        for (String name : this.dir.keySet()) {
            AlmaFile af = this.dir.get(name);
            System.out.print(String.valueOf(name) + " (");
            System.out.print(String.valueOf(af.getXSD()) + ") [");
            System.out.print(String.valueOf(af.getVer()) + "]\n");
        }
    }
}

